//  -----------------------------------------------------------------------------------------
//    g x264 o(GUI) Ex  v1.xx/2.xx by rigaya
//  -----------------------------------------------------------------------------------------
//   \[XR[hɂ
//   Eۏ؂łB
//   E{\[XR[hgpƂɂ邢Ȃ鑹QEguɂrigaya͐ӔC𕉂܂B
//   ȏɗĒꍇA{\[XR[h̎gpAAρAĔЕzsĒč\܂B
//  -----------------------------------------------------------------------------------------

#ifndef _AUO_SETTINGS_H_
#define _AUO_SETTINGS_H_

#include <Windows.h>
#include <vector>
#include "auo.h"

//----    ftHgl    ---------------------------------------------------

static const BOOL   DEFAULT_LARGE_CMD_BOX         = 0;
static const BOOL   DEFAULT_AUTO_AFS_DISABLE      = 0;
static const int    DEFAULT_OUTPUT_EXT            = 0;
static const BOOL   DEFAULT_AUTO_DEL_STATS        = 0;
static const BOOL   DEFAULT_AUTO_DEL_CHAP         = 1;
static const BOOL   DEFAULT_KEEP_QP_FILE          = 0;
static const BOOL   DEFAULT_DISABLE_TOOLTIP_HELP  = 0;
static const BOOL   DEFAULT_DISABLE_VISUAL_STYLES = 0;
static const BOOL   DEFAULT_ENABLE_STG_ESC_KEY    = 0;
static const BOOL   DEFAULT_SAVE_RELATIVE_PATH    = 0;
static const int    DEFAULT_AMP_RETRY_LIMIT       = 3;
static const double DEFAULT_AMP_MARGIN            = 0.05;
static const double DEFAULT_AMP_REENC_AUDIO_MULTI = 0.10;
static const BOOL   DEFAULT_AMP_KEEP_OLD_FILE     = 0;
static const BOOL   DEFAULT_RUN_BAT_MINIMIZED     = 0;
static const BOOL   DEFAULT_SET_KEYFRAME_AFS24FPS = 0;

static const BOOL   DEFAULT_LOG_START_MINIMIZED  = 0;
static const BOOL   DEFAULT_LOG_TRANSPARENT      = 1;
static const BOOL   DEFAULT_LOG_AUTO_SAVE        = 0;
static const int    DEFAULT_LOG_AUTO_SAVE_MODE   = 0;
static const BOOL   DEFAULT_LOG_SHOW_STATUS_BAR  = 1;
static const BOOL   DEFAULT_LOG_TASKBAR_PROGRESS = 1;
static const BOOL   DEFAULT_LOG_SAVE_SIZE        = 0;
static const int    DEFAULT_LOG_WIDTH            = 0;
static const int    DEFAULT_LOG_HEIGHT           = 0;
static const int    DEFAULT_LOG_TRANSPARENCY     = 28;
static const int    DEFAULT_LOG_POS[2]           = { 100, 100 };

///O\ŎgF                                        R    G    B
static const int    DEFAULT_LOG_COLOR_BACKGROUND[3] =   {   0,   0,   0 };
static const int    DEFAULT_LOG_COLOR_TEXT[3][3]    = { { 198, 253, 226 },   //LOG_INFO
                                                        { 245, 218,  90 },   //LOG_WARNING
                                                        { 253,  83, 121 } }; //LOG_ERROR

static const BOOL   DEFAULT_FBC_CALC_BITRATE         = 1;
static const BOOL   DEFAULT_FBC_CALC_TIME_FROM_FRAME = 0;
static const int    DEFAULT_FBC_LAST_FRAME_NUM       = 0;
static const double DEFAULT_FBC_LAST_FPS             = 29.970;
static const int    DEFAULT_FBC_LAST_TIME_IN_SEC     = 0;
static const double DEFAULT_FBC_INITIAL_SIZE         = 39.8;

typedef struct {
	char *name; //x264ł̃IvV
	WCHAR *desc; //GUIł̕\p
} X264_OPTION_STR;

const int FAW_INDEX_ERROR = -1;

const int AUTO_SAVE_LOG_OUTPUT_DIR = 0;
const int AUTO_SAVE_LOG_CUSTOM = 1;

//[؂荏݂܂B
class mem_cutter {
private:
	char *init_ptr;
	char *mp;
	size_t mp_init_size;
	size_t mp_size;
public:
	mem_cutter() {
		mp = NULL;
		init_ptr = NULL;
		mp_init_size = 0;
		mp_size = mp_init_size;
	};
	~mem_cutter() {
		clear();
	};
	void init(size_t size) {
		clear();
		mp_init_size = size;
		mp_size = mp_init_size;
		init_ptr = (char*)calloc(mp_init_size, 1);
		mp = init_ptr;
	};
	void clear() {
		if (init_ptr) free(init_ptr); init_ptr = NULL;
		mp = NULL;
		mp_size = 0;
	};
	void *CutMem(size_t size) {
		if (mp_size - size < 0)
			return NULL;
		void *ptr = mp;
		mp += size;
		mp_size -= size;
		return ptr;
	};
	char *SetPrivateProfileString(const char *section, const char *keyname, const char *defaultString, const char *ini_file) {
		char *ptr = NULL;
		if (mp_size > 0) {
			size_t len = GetPrivateProfileString(section, keyname, defaultString, mp, (DWORD)mp_size, ini_file);
			ptr = mp;
			mp += len + 1;
			mp_size -= len + 1;
		}
		return ptr;
	};
	void *GetPtr() {
		return mp;
	};
	size_t GetRemain() {
		return mp_size;
	};
	void CutString(int sizeof_chr) {
		size_t cut_size = (strlen(mp) + 1) * sizeof_chr;
		mp += cut_size;
		mp_size -= cut_size;
	};
};

typedef struct {
	char *name;          //O
	char *cmd;           //R}hC
	BOOL bitrate;        //rbg[gw胂[h
	int bitrate_min;     //rbg[g̍ŏl
	int bitrate_max;     //rbg[g̍ől
	int bitrate_default; //rbg[g̃ftHgl
	int bitrate_step;    //NbNł̕ω
	int enc_2pass;       //2passGRs
	int use_8bit;        //8bitwav͂
	char *disp_list;     //\̃Xg
	char *cmd_list;      //R}hC̃Xg
} AUDIO_ENC_MODE;

typedef struct {
	char *keyName;               //init@Cł̃ZNV
	char *dispname;              //O
	char *filename;              //gqtO
	char fullpath[MAX_PATH_LEN]; //GR[_̏ꏊ(tpX)
	char *aud_appendix;          //쐬鉹t@Cɒǉ镶
	int pipe_input;              //pCv͂\
	char *cmd_base;              //1st passpR}hC
	char *cmd_2pass;             //2nd passpR}hC
	char *cmd_help;              //wv\pR}hC
	int mode_count;              //GR[h[h̐
	AUDIO_ENC_MODE *mode;        //GR[h[h̐ݒ
} AUDIO_SETTINGS;

typedef struct {
	char *name;      //gIvV̖O
	char *cmd;       //gIvṼR}hC
	char *cmd_apple; //Applep[h̎̃R}hC
	char *chap_file; //`v^[t@C
} MUXER_CMD_EX;

typedef struct {
	char *keyName;                //init@Cł̃ZNV
	char *dispname;               //O
	char *filename;               //gqtO
	char fullpath[MAX_PATH_LEN];  //GR[_̏ꏊ(tpX)
	char *out_ext;                //muxt@C̊gq
	char *base_cmd;               //ƂƂȂR}hC
	char *vid_cmd;                //fmuxp̃R}hC
	char *aud_cmd;                //muxp̃R}hC
	char *tc_cmd;                 //^CR[hmuxp̃R}hC
	char *tmp_cmd;                //ꎞtH_wpR}hC
	char *help_cmd;               //wv\pR}hC
	int ex_count;                 //gIvV̐
	MUXER_CMD_EX *ex_cmd;         //gIvV
	int post_mux;                 //muxersƂɕʂmuxers
} MUXER_SETTINGS;

typedef struct {
	X264_OPTION_STR *name;  //eݒpx264R}h̖O(zAŌnull)
	char **cmd;   //eݒpx264R}h(zAŌnull)
} X264_CMD;

typedef struct {
	char *filename;                      //x264̃t@C
	char fullpath[MAX_PATH_LEN];         //x264̏ꏊ(tpX)
	char fullpath_highbit[MAX_PATH_LEN]; //x264̏ꏊ(tpX) highbitp
	char *default_cmd;                   //ftHgݒpR}hC
	char *default_cmd_highbit;           //highbit depthftHgݒpǉR}hC
	char *help_cmd;                      //wv\pcmd
	int preset_count;                    //preset̐
	int tune_count;                      //tune̐
	int profile_count;                   //profile̐
	int default_preset;                  //ftHgpreset̃CfbNX
	int default_tune;                    //ftHgtunẽCfbNX
	int default_profile;                 //ftHgprofilẽCfbNX
	X264_CMD preset;                     //presetR}hCW
	X264_CMD tune;                       //tuneR}hCW
	X264_CMD profile;                    //profileR}hCW
	float *profile_vbv_multi;            //profileɂvbv{
} X264_SETTINGS;

typedef struct {
	char *from; //u
	char *to;   //u敶
} FILENAME_REPLACE;

typedef struct {
	BOOL minimized;                        //ŏŋN
	BOOL transparent;                      //ŕ\
	int  transparency;                     //ߓx
	BOOL auto_save_log;                    //Oۑsǂ
	int  auto_save_log_mode;               //Oۑ̃[h
	char auto_save_log_path[MAX_PATH_LEN]; //Oۑt@C
	BOOL show_status_bar;                  //Xe[^Xo[̕\
	BOOL taskbar_progress;                 //^XNo[ɐi\
	BOOL save_log_size;                    //Ȏ傫ۑ
	int  log_width;                        //O
	int  log_height;                       //O
	int  log_pos[2];                       //Oʒu
	int  log_color_background[3];          //OwiF
	int  log_color_text[3][3];             //OF
	AUO_FONT_INFO log_font;                //OtHg
} LOG_WINDOW_SETTINGS;

typedef struct {
	BOOL   calc_bitrate;          //rbg[gvZ[h
	BOOL   calc_time_from_frame;  //t[ƃt[[g瓮掞ԂvZ
	int    last_frame_num;        //ŌɎw肵t[
	double last_fps;              //ŌɎw肵t[[g
	DWORD  last_time_in_sec;      //ŌɎw肵
	double initial_size;          //TCY
} BITRATE_CALC_SETTINGS;

typedef struct {
	BOOL   large_cmdbox;                        //gTCYŃR}hCvr[s
	DWORD  audio_buffer_size;                   //pobt@TCY
	BOOL   auto_afs_disable;                    //Iafs𖳌
	int    default_output_ext;                  //ftHgŎgpgq
	BOOL   auto_del_stats;                      //}`pXAXe[^Xt@CIɍ폜
	BOOL   auto_del_chap;                       //`v^[t@C̎폜
	BOOL   keep_qp_file;                        //L[t[oō쐬qpt@C폜Ȃ
	BOOL   disable_tooltip_help;                //|bvAbvwv}
	BOOL   disable_visual_styles;               //oʂItɂ
	BOOL   enable_stg_esc_key;                  //ݒʂEscL[L
	AUO_FONT_INFO conf_font;                    //ݒʂ̃tHg
	int    amp_retry_limit;                     //}`pXs񐔐
	double amp_bitrate_margin_multi;            //}`pXŁAt@CTCYrbg[gČvZƂ̔{
	double amp_reenc_audio_multi;               //}`pXŁAăGRărbg[g{
	BOOL   amp_keep_old_file;                   //}`pXŁA𒴂Ă܂t@C폜Ȃ
	BOOL   get_relative_path;                   //΃pXŕۑ
	BOOL   run_bat_minimized;                   //GROob`ŏŎs
	BOOL   set_keyframe_as_afs_24fps;           //tB[hVtggpɂ24fpsƂăL[t[ݒIɍs
	char   custom_tmp_dir[MAX_PATH_LEN];        //ꎞtH_
	char   custom_audio_tmp_dir[MAX_PATH_LEN];  //pꎞtH_
	char   custom_mp4box_tmp_dir[MAX_PATH_LEN]; //mp4boxpꎞtH_
	char   stg_dir[MAX_PATH_LEN];               //vt@Cݒt@CۑtH_
	char   app_dir[MAX_PATH_LEN];               //st@C̃tH_
	char   bat_dir[MAX_PATH_LEN];               //ob`t@C̃tH_
} LOCAL_SETTINGS;

typedef struct {
	char aud[2][MAX_APPENDIX_LEN];     //t@Cɒǉ镶...GR[hiKŐݒ肷
	char tc[MAX_APPENDIX_LEN];         //^CR[ht@Cɒǉ镶
	char qp[MAX_APPENDIX_LEN];         //qpt@Cɒǉ镶
	char chap[MAX_APPENDIX_LEN];       //`v^[t@Cɒǉ镶
	char chap_apple[MAX_APPENDIX_LEN]; //Apple`̃`v^[ɒǉ镶
	char wav[MAX_APPENDIX_LEN];        //ꎞwavt@Cɒǉ镶
} FILE_APPENDIX;

class guiEx_settings {
private:
	mem_cutter s_x264_mc;
	mem_cutter fn_rep_mc;
	mem_cutter s_aud_mc;
	mem_cutter s_mux_mc;

	static BOOL  init;                        //ÓImۂ̂
	static char  ini_section_main[256];       //CZNV
	static char  auo_path[MAX_PATH_LEN];      //(auo)̃tpX
	static char  ini_fileName[MAX_PATH_LEN];  //init@C(ǂݍݗp)̏ꏊ
	static char  conf_fileName[MAX_PATH_LEN]; //configt@C(ǂݏp)̏ꏊ
	static DWORD ini_filesize;                //init@C(ǂݍݗp)̃TCY

	void load_x264_cmd(X264_CMD *x264cmd, int *count, int *default_index, const char *section);  //x264R}hCݒ̓ǂݍ
	void clear_x264_cmd(X264_CMD *x264cmd, int count);                                             //x264R}hCݒ̏

	void load_aud();          //GR[_֘A̐ݒ̓ǂݍ݁EXV
	void load_mux();          //muxer̐ݒ̓ǂݍ݁EXV
	void load_x264();         //x264֘A̐ݒ̓ǂݍ݁EXV
	void load_local();        //t@C̏ꏊ̐ݒ̓ǂݍ݁EXV

	int get_faw_index();             //FAW̃CfbNX擾
	BOOL s_x264_refresh;             //x264ݒ̍ă[h

	void make_default_stg_dir(char *default_stg_dir, DWORD nSize); //vt@Cݒt@C̕ۑꏊ̍쐬
	BOOL check_inifile();            //init@Cǂ߂邩eXg

public:
	static char blog_url[MAX_PATH_LEN];      //uOy[Wurl
	int s_aud_count;                 //GR[_̐
	int s_mux_count;                 //muxer̐ ({3Œ)
	AUDIO_SETTINGS *s_aud;           //GR[_̐ݒ
	MUXER_SETTINGS *s_mux;           //muxer̐ݒ
	X264_SETTINGS  s_x264;           //x264֘A̐ݒ
	LOCAL_SETTINGS s_local;          //t@C̏ꏊ
	std::vector<FILENAME_REPLACE> fn_rep;  //ꎞt@Cu
	LOG_WINDOW_SETTINGS s_log;       //OEBhE֘A̐ݒ
	FILE_APPENDIX s_append;          //et@Cɒǉ閼O
	BITRATE_CALC_SETTINGS s_fbc;    //ȈՃrbg[gvZ@ݒ

	int s_aud_faw_index;            //FAW̃CfbNX

	guiEx_settings();
	guiEx_settings(BOOL disable_loading);
	guiEx_settings(BOOL disable_loading, const char *_auo_path, const char *main_section);
	~guiEx_settings();

	BOOL get_init_success();                 //init@C݂Ao[W
	BOOL get_init_success(BOOL no_message);  //init@C݂Ao[W
	void load_encode_stg();                  //fEE֘A̐ݒ̓ǂݍ݁EXV
	void load_fn_replace();                  //ꎞt@Cu̐ݒ̓ǂݍ݁EXV
	void load_log_win();                     //OEBhE̐ݒ̓ǂݍ݁EXV
	void load_append();                      //et@C̐ݒ̓ǂݍ݁EXV
	void load_fbc();                         //ȈՃrbg[gvZ@ݒ̓ǂݍ݁EXV

	void save_local();        //t@C̏ꏊ̐ݒ̕ۑ
	void save_log_win();      //OEBhE̐ݒ̕ۑ
	void save_fbc();          //ȈՃrbg[gvZ@ݒ̕ۑ

	void apply_fn_replace(char *target_filename, DWORD nSize);  //ꎞt@Cu̓Kp

	BOOL get_reset_s_x264_referesh(); //s_x264XVꂽ

private:
	void initialize(BOOL disable_loading);
	void initialize(BOOL disable_loading, const char *_auo_path, const char *main_section);

	void clear_aud();         //GR[_֘A̐ݒ̏
	void clear_mux();         //muxer̐ݒ̏
	void clear_x264();        //x264֘A̐ݒ̏
	void clear_local();       //t@C̏ꏊ̐ݒ̏
	void clear_fn_replace();  //ꎞt@Cȕ
	void clear_log_win();     //OEBhE̐ݒ̏
	void clear_append();      //et@C̐ݒ̏
	void clear_fbc();         //ȈՃrbg[gvZ@ݒ̃NA
};

#endif //_AUO_SETTINGS_H_
