//  -----------------------------------------------------------------------------------------
//    g x264 o(GUI) Ex  v1.xx/2.xx by rigaya
//  -----------------------------------------------------------------------------------------
//   \[XR[hɂ
//   Eۏ؂łB
//   E{\[XR[hgpƂɂ邢Ȃ鑹QEguɂrigaya͐ӔC𕉂܂B
//   ȏɗĒꍇA{\[XR[h̎gpAAρAĔЕzsĒč\܂B
//  -----------------------------------------------------------------------------------------

#ifndef _AUO_CONF_H_
#define _AUO_CONF_H_

#include <Windows.h>
#include "auo.h"
#include "auo_options.h"

const int CONF_INITIALIZED = 1;

enum {
	TMP_DIR_OUTPUT = 0,
	TMP_DIR_SYSTEM = 1,
	TMP_DIR_CUSTOM = 2,
};

enum {
	RUN_BAT_NONE   = 0x00,
	RUN_BAT_AFTER  = 0x01,
	RUN_BAT_BEFORE = 0x02,
};

static const char *const CONF_NAME    = "x264guiEx ConfigFile";
const int CONF_NAME_BLOCK_LEN         = 32;
const int CONF_BLOCK_MAX              = 32;
const int CONF_BLOCK_COUNT            = 5; //ő CONF_BLOCK_MAX܂
const int CONF_HEAD_SIZE              = (3 + CONF_BLOCK_MAX) * sizeof(int) + CONF_BLOCK_MAX * sizeof(size_t) + CONF_NAME_BLOCK_LEN;

enum {
	CONF_ERROR_NONE = 0,
	CONF_ERROR_FILE_OPEN,
	CONF_ERROR_BLOCK_SIZE,
	CONF_ERROR_INVALID_FILENAME,
};

const int CMDEX_MAX_LEN = 2048;    //ǉR}hC̍ő咷

enum {
	AMPLIMIT_FILE_SIZE = 0x01, //}`pXAt@CTCỸ`FbNs
	AMPLIMIT_BITRATE   = 0x02, //}`pXArbg[g̃`FbNs
};

enum {
	CHECK_KEYFRAME_NONE = 0x00,
	CHECK_KEYFRAME_AVIUTL = 0x01, //Aviutl̃L[t[tO`FbN
	CHECK_KEYFRAME_CHAPTER = 0x02, //`v^[̈ʒuɃL[t[ݒ肷
};

typedef struct {
	BOOL   afs;                      //tB[hVtg̎gp
	BOOL   afs_bitrate_correction;   //afs & 2passAhbvɉărbg[g␳
	BOOL   auo_tcfile_out;           //auoŃ^CR[ho͂
	DWORD  check_keyframe;           //L[t[`FbNs (CHECK_KEYFRAME_xxx)
	int    priority;                 //x264CPUDx(CfbNX)
	char   stats[MAX_PATH_LEN];      //x264pXe[^Xt@C̏ꏊ
	char   tcfile_in[MAX_PATH_LEN];  //x264 tcfile-inp^CR[ht@C̏ꏊ
	char   cqmfile[MAX_PATH_LEN];    //x264 cqmfilȅꏊ
	char   cmdex[CMDEX_MAX_LEN];     //ǉR}hC
	int    __yc48_colormatrix_conv;  //YC48̐Fϊ (gpĂ܂)
	DWORD  amp_check;                //}`pX̃`FbN̎(AMPLIMIT_FILE_SIZE/AMPLIMIT_BITRATE)
	double amp_limit_file_size;      //}`pX̃t@CTCY(MB)
	double amp_limit_bitrate;        //}`pX̃rbg[g(kbps)
	BOOL   input_as_lw48;            //LW48[h
} CONF_VIDEO; //pݒ(x264ȊO)

typedef struct {
	int  encoder;             //gp鉹GR[_
	int  enc_mode;            //gp鉹GR[_̐ݒ
	int  bitrate;             //rbg[gw胂[h
	BOOL use_2pass;           //2passGR[hs
	BOOL use_wav;             //pCvgpAwavo͂ăGR[hs
	BOOL faw_check;           //FAWChecks
	int  priority;            //GR[_CPUDx(CfbNX)
	BOOL minimized;           //GR[_ŏŎs
	int  aud_temp_dir;        //pꎞtH_
	int  audio_encode_timing; //ɃGR[h
} CONF_AUDIO; //pݒ

typedef struct {
	BOOL disable_mp4ext;  //mp4o͎AOmuxergp
	BOOL disable_mkvext;  //mkvo͎AOmuxergp
	int  mp4_mode;        //mp4 OmuxerpǉR}h̐ݒ
	int  mkv_mode;        //mkv OmuxerpǉR}h̐ݒ
	BOOL minimized;       //muxŏŎs
	int  priority;        //muxDx(CfbNX)
	int  mp4_temp_dir;    //mp4boxpꎞfBNg
	BOOL apple_mode;      //Applep[h(mp4np)
	BOOL disable_mpgext;  //mpgo͎AOmuxergp
	int  mpg_mode;        //mpg OmuxerpǉR}h̐ݒ
} CONF_MUX; //muxerpݒ

typedef struct {
	BOOL  disable_guicmd;         //GUIɂR}hC~(CLI[h)
	int   temp_dir;               //ꎞfBNg
	BOOL  out_audio_only;         //̂ݏo
	char  notes[128];             //
	DWORD run_bat;                //ob`t@Cs邩ǂ (RUN_BAT_xxx)
	DWORD dont_wait_bat_fin;      //ob`t@C̏Iҋ@邩ǂ (RUN_BAT_xxx)
	char  batfile_after[MAX_PATH_LEN];   //GRob`t@C̃pX
	char  batfile_before[MAX_PATH_LEN];  //GROob`t@C̃pX
} CONF_OTHER;

typedef struct {
	char        conf_name[CONF_NAME_BLOCK_LEN];  //ۑɎgp
	int         size_all;                        //ۑ: CONF_GUIEX̑STCY / ݒ蒆AGR: CONF_INITIALIZED
	int         head_size;                       //wb_̑STCY
	int         block_count;                     //wb_ݒ̃ubN
	int         block_size[CONF_BLOCK_MAX];      //eubÑTCY
	size_t      block_head_p[CONF_BLOCK_MAX];    //eubÑ|C^ʒu
	CONF_X264   x264;                            //x264ɂĂ̐ݒ
	CONF_VIDEO  vid;                             //̑ɂĂ̐ݒ
	CONF_AUDIO  aud;                             //ɂĂ̐ݒ
	CONF_MUX    mux;                             //muxɂĂ̐ݒ
	CONF_OTHER  oth;                             //̑̐ݒ
} CONF_GUIEX;

class guiEx_config {
private:
	static const size_t conf_block_pointer[CONF_BLOCK_COUNT];
	static const int conf_block_data[CONF_BLOCK_COUNT];
public:
	guiEx_config();
	static void write_conf_header(CONF_GUIEX *conf);
	static int  adjust_conf_size(CONF_GUIEX *conf_buf, void *old_data, int old_size);
	int  load_x264guiEx_conf(CONF_GUIEX *conf, const char *stg_file);       //ݒstgt@Cǂݍ
	int  save_x264guiEx_conf(const CONF_GUIEX *conf, const char *stg_file); //ݒstgt@CƂĕۑ
};

//`x264guiEx.cpp
void init_CONF_GUIEX(CONF_GUIEX *conf, BOOL use_highbit); //Ax264ݒ̃ftHgݒ

//o̓t@C̊gqtB^쐬
//filterNULLȂauoOUTPUT_PLUGIN_TABLEp̃tB^
void make_file_filter(char *filter, size_t nSize, int default_index);

void overwrite_aviutl_ini_file_filter(int idx);

#endif //_AUO_CONF_H_
