//  -----------------------------------------------------------------------------------------
//    g x264 o(GUI) Ex  v1.xx/2.xx by rigaya
//  -----------------------------------------------------------------------------------------
//   \[XR[hɂ
//   Eۏ؂łB
//   E{\[XR[hgpƂɂ邢Ȃ鑹QEguɂrigaya͐ӔC𕉂܂B
//   ȏɗĒꍇA{\[XR[h̎gpAAρAĔЕzsĒč\܂B
//  -----------------------------------------------------------------------------------------

//ȉwarning C4100ق点
//C4100 : ͊֐̖{̕ 1 xQƂ܂B
#pragma warning( push )
#pragma warning( disable: 4100 )

#include "auo_version.h"
#include "auo_frm.h"
#include "auo_faw2aac.h"
#include "frmConfig.h"
#include "frmSaveNewStg.h"
#include "frmOtherSettings.h"
#include "frmBitrateCalculator.h"

using namespace x264guiEx;

/// -------------------------------------------------
///     ݒʂ̕\
/// -------------------------------------------------
[STAThreadAttribute]
void ShowfrmConfig(CONF_GUIEX *conf, const SYSTEM_DATA *sys_dat) {
	if (!sys_dat->exstg->s_local.disable_visual_styles)
		System::Windows::Forms::Application::EnableVisualStyles();
	System::IO::Directory::SetCurrentDirectory(String(sys_dat->aviutl_dir).ToString());
	frmConfig frmConf(conf, sys_dat);
	frmConf.ShowDialog();
}

/// -------------------------------------------------
///     frmSaveNewStg ֐
/// -------------------------------------------------
System::Boolean frmSaveNewStg::checkStgFileName(String^ stgName) {
	String^ fileName;
	if (stgName->Length == 0)
		return false;
	
	if (!ValidiateFileName(stgName)) {
		MessageBox::Show(L"t@CɎgpłȂ܂܂Ă܂B\nۑł܂B", L"G[", MessageBoxButtons::OK, MessageBoxIcon::Error);
		return false;
	}
	if (String::Compare(Path::GetExtension(stgName), L".stg", true))
		stgName += L".stg";
	if (File::Exists(fileName = Path::Combine(fsnCXFolderBrowser->GetSelectedFolder(), stgName)))
		if (MessageBox::Show(stgName + L" ͂łɑ݂܂B㏑܂?", L"㏑mF", MessageBoxButtons::YesNo, MessageBoxIcon::Question)
			!= System::Windows::Forms::DialogResult::Yes)
			return false;
	StgFileName = fileName;
	return true;
}

System::Void frmSaveNewStg::setStgDir(String^ _stgDir) {
	StgDir = _stgDir;
	fsnCXFolderBrowser->SetRootDirAndReload(StgDir);
}


/// -------------------------------------------------
///     frmBitrateCalculator ֐
/// -------------------------------------------------
System::Void frmBitrateCalculator::Init(int VideoBitrate, int AudioBitrate, bool BTVBEnable, bool BTABEnable, int ab_max) {
	guiEx_settings exStg(true);
	exStg.load_fbc();
	enable_events = false;
	fbcTXSize->Text = exStg.s_fbc.initial_size.ToString("F2");
	fbcChangeTimeSetMode(exStg.s_fbc.calc_time_from_frame != 0);
	fbcRBCalcRate->Checked = exStg.s_fbc.calc_bitrate != 0;
	fbcRBCalcSize->Checked = !fbcRBCalcRate->Checked;
	fbcTXMovieFrameRate->Text = Convert::ToString(exStg.s_fbc.last_fps);
	fbcNUMovieFrames->Value = exStg.s_fbc.last_frame_num;
	fbcNULengthHour->Value = Convert::ToDecimal((int)exStg.s_fbc.last_time_in_sec / 3600);
	fbcNULengthMin->Value = Convert::ToDecimal((int)(exStg.s_fbc.last_time_in_sec % 3600) / 60);
	fbcNULengthSec->Value =  Convert::ToDecimal((int)exStg.s_fbc.last_time_in_sec % 60);
	SetBTVBEnabled(BTVBEnable);
	SetBTABEnabled(BTABEnable, ab_max);
	SetNUVideoBitrate(VideoBitrate);
	SetNUAudioBitrate(AudioBitrate);
	enable_events = true;
}
System::Void frmBitrateCalculator::frmBitrateCalculator_FormClosing(System::Object^  sender, System::Windows::Forms::FormClosingEventArgs^  e) {
	guiEx_settings exStg(true);
	exStg.load_fbc();
	exStg.s_fbc.calc_bitrate = fbcRBCalcRate->Checked;
	exStg.s_fbc.calc_time_from_frame = fbcPNMovieFrames->Visible;
	exStg.s_fbc.last_fps = Convert::ToDouble(fbcTXMovieFrameRate->Text);
	exStg.s_fbc.last_frame_num = Convert::ToInt32(fbcNUMovieFrames->Value);
	exStg.s_fbc.last_time_in_sec = Convert::ToInt32(fbcNULengthHour->Value) * 3600
		                         + Convert::ToInt32(fbcNULengthMin->Value) * 60
								 + Convert::ToInt32(fbcNULengthSec->Value);
	if (fbcRBCalcRate->Checked)
		exStg.s_fbc.initial_size = Convert::ToDouble(fbcTXSize->Text);
	exStg.save_fbc();
	frmConfig^ fcg = dynamic_cast<frmConfig^>(this->Owner);
	if (fcg != nullptr)
		fcg->InformfbcClosed();
}
System::Void frmBitrateCalculator::fbcRBCalcRate_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
	if (fbcRBCalcRate->Checked && Convert::ToDouble(fbcTXSize->Text) <= 0.0) {
		guiEx_settings exStg(true);
		exStg.load_fbc();
		fbcTXSize->Text = exStg.s_fbc.initial_size.ToString("F2");
	}
}
System::Void frmBitrateCalculator::fbcBTVBApply_Click(System::Object^  sender, System::EventArgs^  e) {
	frmConfig^ fcg = dynamic_cast<frmConfig^>(this->Owner);
	if (fcg != nullptr)
		fcg->SetVideoBitrate((int)fbcNUBitrateVideo->Value);
}
System::Void frmBitrateCalculator::fbcBTABApply_Click(System::Object^  sender, System::EventArgs^  e) {
	frmConfig^ fcg = dynamic_cast<frmConfig^>(this->Owner);
	if (fcg != nullptr)
		fcg->SetAudioBitrate((int)fbcNUBitrateAudio->Value);
}


/// -------------------------------------------------
///     frmConfig ֐  (frmBitrateCalculator֘A)
/// -------------------------------------------------
System::Void frmConfig::CloseBitrateCalc() {
	frmBitrateCalculator::Instance::get()->Close();
}
System::Void frmConfig::fcgTSBBitrateCalc_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
	if (fcgTSBBitrateCalc->Checked) {
		int videoBitrate = 0;
		bool videoBitrateMode = (x264_encmode_to_RCint[fcgCXX264Mode->SelectedIndex] == X264_RC_BITRATE);
		videoBitrateMode &= Int32::TryParse(fcgTXQuality->Text, videoBitrate);

		frmBitrateCalculator::Instance::get()->Init(
			(videoBitrateMode) ? videoBitrate : 0,
			(fcgNUAudioBitrate->Visible) ? (int)fcgNUAudioBitrate->Value : 0,
			videoBitrateMode,
			fcgNUAudioBitrate->Visible,
			(int)fcgNUAudioBitrate->Maximum
			);
		frmBitrateCalculator::Instance::get()->Owner = this;
		frmBitrateCalculator::Instance::get()->Show();
	} else {
		frmBitrateCalculator::Instance::get()->Close();
	}
}
System::Void frmConfig::SetfbcBTABEnable(bool enable, int max) {
	frmBitrateCalculator::Instance::get()->SetBTABEnabled(fcgNUAudioBitrate->Visible, max);
}
System::Void frmConfig::SetfbcBTVBEnable(bool enable) {
	frmBitrateCalculator::Instance::get()->SetBTVBEnabled(enable);
}

System::Void frmConfig::SetVideoBitrate(int bitrate) {
	if (x264_encmode_to_RCint[fcgCXX264Mode->SelectedIndex] == X264_RC_BITRATE)
		fcgTXQuality->Text = bitrate.ToString();
}

System::Void frmConfig::SetAudioBitrate(int bitrate) {
	SetNUValue(fcgNUAudioBitrate, bitrate);
}
System::Void frmConfig::InformfbcClosed() {
	fcgTSBBitrateCalc->Checked = false;
}


/// -------------------------------------------------
///     frmConfig ֐
/// -------------------------------------------------
/////////////   LocalStg֘A  //////////////////////
System::Void frmConfig::LoadLocalStg() {
	guiEx_settings *_ex_stg = sys_dat->exstg;
	_ex_stg->load_encode_stg();
	LocalStg.x264ExeName     = String(_ex_stg->s_x264.filename).ToString();
	LocalStg.x264Path        = String(_ex_stg->s_x264.fullpath).ToString();
	LocalStg.x264Pathhighbit = String(_ex_stg->s_x264.fullpath_highbit).ToString();
	LocalStg.CustomTmpDir    = String(_ex_stg->s_local.custom_tmp_dir).ToString();
	LocalStg.CustomAudTmpDir = String(_ex_stg->s_local.custom_audio_tmp_dir).ToString();
	LocalStg.CustomMP4TmpDir = String(_ex_stg->s_local.custom_mp4box_tmp_dir).ToString();
	LocalStg.LastAppDir      = String(_ex_stg->s_local.app_dir).ToString();
	LocalStg.LastBatDir      = String(_ex_stg->s_local.bat_dir).ToString();
	LocalStg.MP4MuxerExeName = String(_ex_stg->s_mux[MUXER_MP4].filename).ToString();
	LocalStg.MP4MuxerPath    = String(_ex_stg->s_mux[MUXER_MP4].fullpath).ToString();
	LocalStg.MKVMuxerExeName = String(_ex_stg->s_mux[MUXER_MKV].filename).ToString();
	LocalStg.MKVMuxerPath    = String(_ex_stg->s_mux[MUXER_MKV].fullpath).ToString();
	LocalStg.TC2MP4ExeName   = String(_ex_stg->s_mux[MUXER_TC2MP4].filename).ToString();
	LocalStg.TC2MP4Path      = String(_ex_stg->s_mux[MUXER_TC2MP4].fullpath).ToString();
	LocalStg.MPGMuxerExeName = String(_ex_stg->s_mux[MUXER_MPG].filename).ToString();
	LocalStg.MPGMuxerPath    = String(_ex_stg->s_mux[MUXER_MPG].fullpath).ToString();
	LocalStg.MP4RawExeName   = String(_ex_stg->s_mux[MUXER_MP4_RAW].filename).ToString();
	LocalStg.MP4RawPath      = String(_ex_stg->s_mux[MUXER_MP4_RAW].fullpath).ToString();

	LocalStg.audEncName->Clear();
	LocalStg.audEncExeName->Clear();
	LocalStg.audEncPath->Clear();
	for (int i = 0; i < _ex_stg->s_aud_count; i++) {
		LocalStg.audEncName->Add(String(_ex_stg->s_aud[i].dispname).ToString());
		LocalStg.audEncExeName->Add(String(_ex_stg->s_aud[i].filename).ToString());
		LocalStg.audEncPath->Add(String(_ex_stg->s_aud[i].fullpath).ToString());
	}
	if (_ex_stg->s_local.large_cmdbox)
		fcgTXCmd_DoubleClick(nullptr, nullptr); //Ԃ͏kȂ̂ŁAg
}

System::Boolean frmConfig::CheckLocalStg() {
	bool error = false;
	String^ err = "";
	//x264̃`FbN
	bool CheckX264highbit;
	if (fcgTSBCMDOnly->Checked) {
		//CLI[h̎̓R}hC͂highbitǂ
		CONF_GUIEX cnf;
		init_CONF_GUIEX(&cnf, FALSE);
		char cmdex[2048] = { 0 };
		GetCHARfromString(cmdex, sizeof(cmdex), fcgTXCmdEx->Text);
		set_cmd_to_conf(cmdex, &cnf.x264);
		CheckX264highbit = cnf.x264.use_highbit_depth != 0;
	} else {
		CheckX264highbit = fcgCBUsehighbit->Checked;
	}
	if (!CheckX264highbit && !File::Exists(LocalStg.x264Path)) {
		error = true;
		err += L"w肳ꂽ x264 ݂͑܂B\n [ " + LocalStg.x264Path + L" ]\n";
	}
	if (CheckX264highbit && !File::Exists(LocalStg.x264Pathhighbit)) {
		error = true;
		err += L"w肳ꂽ x264 (highbitp) ݂͑܂B\n [ " + LocalStg.x264Pathhighbit + L" ]\n";
	}
	//GR[_̃`FbN (st@CȂꍇ̓`FbNȂ)
	if (LocalStg.audEncExeName[fcgCXAudioEncoder->SelectedIndex]->Length) {
		String^ AudioEncoderPath = LocalStg.audEncPath[fcgCXAudioEncoder->SelectedIndex];
		if (!File::Exists(AudioEncoderPath) 
			&& (fcgCXAudioEncoder->SelectedIndex != sys_dat->exstg->s_aud_faw_index 
			    || !check_if_faw2aac_exists()) ) {
			//st@CȂ 
			//IꂽfawłȂ ܂ fawłĂfaw2aacȂ
			if (error) err += L"\n\n";
			error = true;
			err += L"w肳ꂽ GR[_ ݂͑܂B\n [ " + AudioEncoderPath + L" ]\n";
		}
	}
	//FAW̃`FbN
	if (fcgCBFAWCheck->Checked) {
		if (sys_dat->exstg->s_aud_faw_index == FAW_INDEX_ERROR) {
			if (error) err += L"\n\n";
			error = true;
			err += L"FAWCheckI܂Ax264guiEx.ini \n"
				+ L"FAW ̐ݒǂݍ߂܂łB\n"
				+ L"x264guiEx.ini mFĂB\n";
		} else if (!File::Exists(LocalStg.audEncPath[sys_dat->exstg->s_aud_faw_index])
			       && !check_if_faw2aac_exists()) {
			//faw̎st@C݂Ȃ  faw2aac݂Ȃ
			if (error) err += L"\n\n";
			error = true;
			err += L"FAWCheckI܂AFAW(fawcl)ւ̃pXw肳Ă܂B\n"
				+  L"xݒʂFAW(fawcl)ւ̃pXw肵ĂB\n";
		}
	}
	//}`pX̎rbg[gݒ̃`FbN
	if (fcgLBAMPAutoBitrate != nullptr && fcgLBAMPAutoBitrate->Visible) {
		if (error) err += L"\n\n";
		error = true;
		err += L"ڕWfrbg[gɐݒ肷ɂ́A\n"
			+ L"rbg[gAt@CTCY̏ȂƂЕ\n"
			+ L"K؂ɐݒ肷Kv܂B\n"
			+ L"rbg[gAt@CTCY̐ݒȂĂB";
	}
	if (error) 
		MessageBox::Show(this, err, L"G[", MessageBoxButtons::OK, MessageBoxIcon::Error);
	return error;
}

System::Void frmConfig::SaveLocalStg() {
	guiEx_settings *_ex_stg = sys_dat->exstg;
	_ex_stg->load_encode_stg();
	_ex_stg->s_local.large_cmdbox = fcgTXCmd->Multiline;
	GetCHARfromString(_ex_stg->s_x264.fullpath,               sizeof(_ex_stg->s_x264.fullpath),               LocalStg.x264Path);
	GetCHARfromString(_ex_stg->s_x264.fullpath_highbit,       sizeof(_ex_stg->s_x264.fullpath_highbit),       LocalStg.x264Pathhighbit);
	GetCHARfromString(_ex_stg->s_local.custom_tmp_dir,        sizeof(_ex_stg->s_local.custom_tmp_dir),        LocalStg.CustomTmpDir);
	GetCHARfromString(_ex_stg->s_local.custom_mp4box_tmp_dir, sizeof(_ex_stg->s_local.custom_mp4box_tmp_dir), LocalStg.CustomMP4TmpDir);
	GetCHARfromString(_ex_stg->s_local.custom_audio_tmp_dir,  sizeof(_ex_stg->s_local.custom_audio_tmp_dir),  LocalStg.CustomAudTmpDir);
	GetCHARfromString(_ex_stg->s_local.app_dir,               sizeof(_ex_stg->s_local.app_dir),               LocalStg.LastAppDir);
	GetCHARfromString(_ex_stg->s_local.bat_dir,               sizeof(_ex_stg->s_local.bat_dir),               LocalStg.LastBatDir);
	GetCHARfromString(_ex_stg->s_mux[MUXER_MP4].fullpath,     sizeof(_ex_stg->s_mux[MUXER_MP4].fullpath),     LocalStg.MP4MuxerPath);
	GetCHARfromString(_ex_stg->s_mux[MUXER_MKV].fullpath,     sizeof(_ex_stg->s_mux[MUXER_MKV].fullpath),     LocalStg.MKVMuxerPath);
	GetCHARfromString(_ex_stg->s_mux[MUXER_TC2MP4].fullpath,  sizeof(_ex_stg->s_mux[MUXER_TC2MP4].fullpath),  LocalStg.TC2MP4Path);
	GetCHARfromString(_ex_stg->s_mux[MUXER_MPG].fullpath,     sizeof(_ex_stg->s_mux[MUXER_MPG].fullpath),     LocalStg.MPGMuxerPath);
	GetCHARfromString(_ex_stg->s_mux[MUXER_MP4_RAW].fullpath, sizeof(_ex_stg->s_mux[MUXER_MP4_RAW].fullpath), LocalStg.MP4RawPath);
	for (int i = 0; i < _ex_stg->s_aud_count; i++)
		GetCHARfromString(_ex_stg->s_aud[i].fullpath,         sizeof(_ex_stg->s_aud[i].fullpath),             LocalStg.audEncPath[i]);
	_ex_stg->save_local();
}

System::Void frmConfig::SetLocalStg() {
	fcgLBX264Path->Text           = L"x264.exe ̎w";
	fcgLBX264PathSub->Text        = L"x264.exe ̎w";
	fcgTXX264Path->Text           = (fcgCBUsehighbit->Checked) ? LocalStg.x264Pathhighbit : LocalStg.x264Path;
	fcgTXX264PathSub->Text        = LocalStg.x264Path;
	fcgTXX264PathSubhighbit->Text = LocalStg.x264Pathhighbit;
	fcgTXMP4MuxerPath->Text       = LocalStg.MP4MuxerPath;
	fcgTXMKVMuxerPath->Text       = LocalStg.MKVMuxerPath;
	fcgTXTC2MP4Path->Text         = LocalStg.TC2MP4Path;
	fcgTXMPGMuxerPath->Text       = LocalStg.MPGMuxerPath;
	fcgTXMP4RawPath->Text         = LocalStg.MP4RawPath;
	fcgTXCustomAudioTempDir->Text = LocalStg.CustomAudTmpDir;
	fcgTXCustomTempDir->Text      = LocalStg.CustomTmpDir;
	fcgTXMP4BoxTempDir->Text      = LocalStg.CustomMP4TmpDir;
	fcgLBMP4MuxerPath->Text       = LocalStg.MP4MuxerExeName + L" ̎w";
	fcgLBMKVMuxerPath->Text       = LocalStg.MKVMuxerExeName + L" ̎w";
	fcgLBTC2MP4Path->Text         = LocalStg.TC2MP4ExeName   + L" ̎w";
	fcgLBMPGMuxerPath->Text       = LocalStg.MPGMuxerExeName + L" ̎w";
	fcgLBMP4RawPath->Text         = LocalStg.MP4RawExeName + L" ̎w";

	fcgTXX264Path->SelectionStart           = fcgTXX264Path->Text->Length;
	fcgTXX264PathSub->SelectionStart        = fcgTXX264PathSub->Text->Length;
	fcgTXX264PathSubhighbit->SelectionStart = fcgTXX264PathSubhighbit->Text->Length;
	fcgTXMP4MuxerPath->SelectionStart       = fcgTXMP4MuxerPath->Text->Length;
	fcgTXTC2MP4Path->SelectionStart         = fcgTXTC2MP4Path->Text->Length;
	fcgTXMKVMuxerPath->SelectionStart       = fcgTXMKVMuxerPath->Text->Length;
	fcgTXMPGMuxerPath->SelectionStart       = fcgTXMPGMuxerPath->Text->Length;
	fcgTXMP4RawPath->SelectionStart         = fcgTXMP4RawPath->Text->Length;
}

//////////////   TrackBarp^C}[֘A     /////////////////////////
System::Void frmConfig::qualityTimerChange(Object^ state) {
	this->Invoke(gcnew qualityTimerChangeDelegate(this, &frmConfig::fcgTBQualityChange));
}

System::Void frmConfig::fcgTBQualityChange() {
	int j = fcgTBQuality->Value;
	int i = j + timerChangeValue;
	i = clamp(i, fcgTBQuality->Minimum, fcgTBQuality->Maximum);
	fcgTBQuality->Value = i;
	if (i != j)
		fcgTBQuality_Scroll(nullptr, nullptr);
}

System::Void frmConfig::InitTimer() {
	qualityTimer = gcnew System::Threading::Timer(
		gcnew System::Threading::TimerCallback(this, &frmConfig::qualityTimerChange),
		nullptr, System::Threading::Timeout::Infinite, fcgTBQualityTimerPeriod);
	timerChangeValue = 1;
}


//////////////       ̑Cxg   ////////////////////////
System::Void frmConfig::ActivateToolTip(bool Enable) {
	fcgTTEx->Active = Enable;
	fcgTTX264->Active = Enable;
	fcgTTX264Version->Active = Enable;
}

System::Void frmConfig::fcgTSBOtherSettings_Click(System::Object^  sender, System::EventArgs^  e) {
	frmOtherSettings::Instance::get()->stgDir = String(sys_dat->exstg->s_local.stg_dir).ToString();
	frmOtherSettings::Instance::get()->ShowDialog();
	char buf[MAX_PATH_LEN];
	GetCHARfromString(buf, sizeof(buf), frmOtherSettings::Instance::get()->stgDir);
	if (_stricmp(buf, sys_dat->exstg->s_local.stg_dir)) {
		//ύXۑ
		strcpy_s(sys_dat->exstg->s_local.stg_dir, sizeof(sys_dat->exstg->s_local.stg_dir), buf);
		sys_dat->exstg->save_local();
		InitStgFileList();
	}
	//ēǂݍ
	guiEx_settings stg;
	stg.load_encode_stg();
	log_reload_settings();
	sys_dat->exstg->s_local.get_relative_path = stg.s_local.get_relative_path;
	SetStgEscKey(stg.s_local.enable_stg_esc_key != 0);
	ActivateToolTip(stg.s_local.disable_tooltip_help == FALSE);
	if (str_has_char(stg.s_local.conf_font.name))
		SetFontFamilyToForm(this, gcnew FontFamily(String(stg.s_local.conf_font.name).ToString()), this->Font->FontFamily);
}

System::Void frmConfig::fcgTSBCMDOnly_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
	//CLI[hƂ̐؂ւ
	//Ȃm񂪁AVisiblevpeBfalseɂ邾ł͔\ɂłȂ
	//傤Ȃ̂ŎQƂ̍폜Ƒ}s
	if (fcgTSBCMDOnly->Checked) {
		fcgtabControlVideo->TabPages->RemoveAt(2);
		fcgtabControlVideo->TabPages->RemoveAt(1);
		fcgtabControlVideo->TabPages->RemoveAt(0);
		fcgtabPageExSettings->Text = L"f";
		fcggroupBoxCmdEx->Text = L"R}hC";
	} else {
		fcgtabControlVideo->TabPages->Insert(0, fcgtabPageX264Main);
		fcgtabControlVideo->TabPages->Insert(1, fcgtabPageX264RC);
		fcgtabControlVideo->TabPages->Insert(2, fcgtabPageX264Frame);
		fcgtabPageExSettings->Text = L"g";
		fcggroupBoxCmdEx->Text = L"ǉR}h";
	}
	fcgChangeEnabled(sender, e);
	fcgRebuildCmd(sender, e);
}

System::Void frmConfig::fcgCBUsehighbit_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
	//8bit/highbitňقȂQP̍őŏǗ
	int old_max = (int)fcgNUQpmax->Maximum;
	fcgNUQpmax->Maximum = (fcgCBUsehighbit->Checked) ? X264_QP_MAX_10BIT : X264_QP_MAX_8BIT;
	fcgNUQpmin->Maximum = fcgNUQpmax->Maximum;
	fcgNUQpstep->Maximum = fcgNUQpmax->Maximum;
	fcgNUChromaQp->Minimum = -1 * fcgNUQpmax->Maximum;
	fcgNUChromaQp->Maximum = fcgNUQpmax->Maximum;
	if ((int)fcgNUQpmax->Value == old_max)
		fcgNUQpmax->Value = fcgNUQpmax->Maximum;
	fcgCXX264Mode_SelectedIndexChanged(sender, e);
	fcgTXX264Path->Text = (fcgCBUsehighbit->Checked) ? LocalStg.x264Pathhighbit : LocalStg.x264Path;
	fcgTXX264Path->SelectionStart = fcgTXX264Path->Text->Length;
	fcgLBX264Path->Text = (fcgCBUsehighbit->Checked) ? L"x264.exe(highbit) ̎w" : L"x264.exe ̎w";
	SetX264VersionToolTip(fcgTXX264Path->Text, fcgCBUsehighbit->Checked);
	SetTBValueToTextBox();
}

System::Void frmConfig::fcgCBAFS_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
	fcgCBAFSBitrateCorrection->Enabled = fcgCBAFS->Checked;
	fcgLBVBVafsWarning->Visible        = fcgCBAFS->Checked;
	if (fcgCBAFS->Checked) {
		//fcgCBMP4MuxerExt->Checked      = true;
		//fcgCBMKVMuxerExt->Checked      = true;
	}
	//fcgCBMP4MuxerExt->Enabled          = !fcgCBAFS->Checked;
	//fcgCBMKVMuxerExt->Enabled          = !fcgCBAFS->Checked;

	bool disable_keyframe_detect = fcgCBAFS->Checked && !sys_dat->exstg->s_local.set_keyframe_as_afs_24fps;
	if (disable_keyframe_detect)
		fcgCBCheckKeyframes->Checked   = false;
	fcgCBCheckKeyframes->Enabled       = !disable_keyframe_detect;

	int muxer_cmdex = fcgCXMP4CmdEx->SelectedIndex;
	setMuxerCmdExNames(fcgCXMP4CmdEx, (fcgCBAFS->Checked) ? MUXER_TC2MP4 : MUXER_MP4);
	fcgCXMP4CmdEx->SelectedIndex = muxer_cmdex;
}

System::Void frmConfig::fcgArrangeForAutoMultiPass(bool enable) {
	const int PNX264ModeOffset = +7;
	const int PNBitrateOffset  = -39;
	const int PNStatusFileOffset = -17;
	if (fcgLastX264ModeAsAMP == enable)
		return;
	Point NewPoint = fcgPNX264Mode->Location;
	NewPoint.Y += PNX264ModeOffset * ((enable) ? -1 : 1);
	fcgPNX264Mode->Location = NewPoint;
	fcgPNX264Mode->Height += (PNBitrateOffset - PNX264ModeOffset*2) * ((enable) ? -1 : 1);
	NewPoint = fcgPNBitrate->Location;
	NewPoint.Y += PNBitrateOffset * ((enable) ? -1 : 1);
	fcgPNBitrate->Location = NewPoint;
	NewPoint = fcgPNStatusFile->Location;
	NewPoint.Y += PNStatusFileOffset * ((enable) ? -1 : 1);
	fcgPNStatusFile->Location = NewPoint;
	fcgLastX264ModeAsAMP = enable;
	fcgCBAMPLimitBitrate->Visible = enable;
	fcgCBAMPLimitFileSize->Visible = enable;
	fcgNUAMPLimitBitrate->Visible = enable;
	fcgNUAMPLimitFileSize->Visible = enable;
}

System::Void frmConfig::fcgCheckAMPAutoBitrateEvent(System::Object^  sender, System::EventArgs^  e) {
	if (fcgLBAMPAutoBitrate == nullptr)
		return;
	if (fcgCXX264Mode->SelectedIndex == 5) {
		if (   0 == String::Compare(fcgTXQuality->Text, STR_BITRATE_AUTO)
			|| 0 == String::Compare(fcgTXQuality->Text, L"-1")) {
				if (!fcgCBAMPLimitBitrate->Checked && !fcgCBAMPLimitFileSize->Checked) {
				fcgLBAMPAutoBitrate->Visible = true;
				return;
				}
		}
	}
	fcgLBAMPAutoBitrate->Visible = false;
}

System::Void frmConfig::AddCheckAMPAutoBitrateEvent() {
	fcgCBAMPLimitBitrate->CheckedChanged += gcnew System::EventHandler(this, &frmConfig::fcgCheckAMPAutoBitrateEvent);
	fcgCBAMPLimitFileSize->CheckedChanged += gcnew System::EventHandler(this, &frmConfig::fcgCheckAMPAutoBitrateEvent);
	fcgCXX264Mode->SelectedIndexChanged += gcnew System::EventHandler(this, &frmConfig::fcgCheckAMPAutoBitrateEvent);
	fcgTXQuality->TextChanged += gcnew System::EventHandler(this, &frmConfig::fcgCheckAMPAutoBitrateEvent);
}

System::Void frmConfig::fcgCXX264Mode_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
	int index = fcgCXX264Mode->SelectedIndex;
	cnf_fcgTemp->rc_mode = x264_encmode_to_RCint[index];
	cnf_fcgTemp->use_auto_npass = (fcgCXX264Mode->SelectedIndex == 5 || fcgCXX264Mode->SelectedIndex == 6);
	switch (cnf_fcgTemp->rc_mode) {
		case X264_RC_BITRATE:
			fcgLBQuality->Text = (fcgCXX264Mode->SelectedIndex == 5) ? L"ڕWfrbg[g(kbps, \"-1\"Ŏ)" : L"rbg[g(kbps)";
			fcgLBQualityLeft->Text = L"i";
			fcgLBQualityRight->Text = L"i";
			fcgTBQuality->Minimum = 0;
			fcgTBQuality->Maximum = TBBConvert.getMaxCount();
			cnf_fcgTemp->pass = x264_encmode_to_passint[index];
			if (fcgCXX264Mode->SelectedIndex >= 3) {
				fcgCBNulOut->Enabled = true;
				fcgCBNulOut->Checked = cnf_fcgTemp->nul_out != 0;
				if (fcgCXX264Mode->SelectedIndex == 4) {
					fcgCBFastFirstPass->Enabled = false; //Enabled̕ύX
					fcgCBFastFirstPass->Checked = false;
				} else {
					fcgCBFastFirstPass->Enabled = true; //Enabled̕ύX
					fcgCBFastFirstPass->Checked = !cnf_fcgTemp->slow_first_pass;
				}
			} else {
				fcgCBNulOut->Enabled = false; //Enabled̕ύX
				fcgCBNulOut->Checked = false;
				fcgCBFastFirstPass->Enabled = false; //Enabled̕ύX
				fcgCBFastFirstPass->Checked = false;
			}
			//(-1)ύXꂽƂ̏u  1000ɖ߂
			if ((cnf_fcgTemp->bitrate == -1) && (fcgCXX264Mode->SelectedIndex != 5))
				cnf_fcgTemp->bitrate = 1000;
			//XV
			if ((cnf_fcgTemp->bitrate == -1) && (fcgCXX264Mode->SelectedIndex == 5))
				fcgTXQuality->Text = STR_BITRATE_AUTO; //-1̓Ꮘu(-1: )
			else
				fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->bitrate);
			SetfbcBTVBEnable(true);
			break;
		case X264_RC_QP:
			fcgLBQuality->Text = L"ʎq(Quantizer)";
			fcgLBQualityLeft->Text = L"i";
			fcgLBQualityRight->Text = L"i";
			fcgTBQuality->Minimum = 0;
			fcgTBQuality->Maximum = 69;
			fcgCBNulOut->Enabled = false; //Enabled̕ύX
			fcgCBNulOut->Checked = false;
			fcgCBFastFirstPass->Enabled = false; //Enabled̕ύX
			fcgCBFastFirstPass->Checked = false;
			fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->qp);
			SetfbcBTVBEnable(false);
			break;
		case X264_RC_CRF:
		default:
			fcgLBQuality->Text = L"i(Quality)";
			fcgLBQualityLeft->Text = L"i";
			fcgLBQualityRight->Text = L"i";
			fcgTBQuality->Minimum = (fcgCBUsehighbit->Checked) ? -12*2 : 0;
			fcgTBQuality->Maximum = 51*2;
			fcgCBNulOut->Enabled = false; //Enabled̕ύX
			fcgCBNulOut->Checked = false;
			fcgCBFastFirstPass->Enabled = false; //Enabled̕ύX
			fcgCBFastFirstPass->Checked = false;
			fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->crf / 100.0);
			SetfbcBTVBEnable(false);
			break;
	}
	fcgNUAutoNPass->Enabled = (fcgCXX264Mode->SelectedIndex == 5);
	fcgArrangeForAutoMultiPass(cnf_fcgTemp->use_auto_npass != 0);
}

System::Void frmConfig::fcgTXQuality_Enter(System::Object^  sender, System::EventArgs^  e) {
	if (0 == String::Compare(fcgTXQuality->Text, STR_BITRATE_AUTO)) {
		fcgTXQuality->Text = L"-1";
		fcgTXQuality->Select(0, fcgTXQuality->Text->Length);
	}
}

System::Void frmConfig::fcgTXQuality_TextChanged(System::Object^  sender, System::EventArgs^  e) {
	if (fcgTXQuality->Text->Length == 0 || String::Compare(fcgTXQuality->Text, L"-") == 0)
		return;
	//[h̕ɕύXꂽƂ̏
	if (0 == String::Compare(fcgTXQuality->Text, STR_BITRATE_AUTO)) {
		fcgTXQuality->Text = STR_BITRATE_AUTO;
		cnf_fcgTemp->bitrate = -1;
		fcgTBQuality->Value = TBBConvert.BitrateToTB(cnf_fcgTemp->bitrate);
		lastQualityStr = fcgTXQuality->Text;
		fcgTXQuality->SelectionStart = fcgTXQuality->Text->Length;
		fcgTXQuality->SelectionLength = 0;
		return;
	}
	int c = fcgTXQuality->SelectionStart;
	int index = fcgCXX264Mode->SelectedIndex;
	bool restore = false;
	int i;
	double d;
	if (!Double::TryParse(fcgTXQuality->Text, d)) {
		fcgTXQuality->Text = lastQualityStr;
		restore = true;
	} else {
		switch (x264_encmode_to_RCint[index]) {
		case X264_RC_BITRATE:
			//}`pX-1()蓾
			if (Int32::TryParse(fcgTXQuality->Text, i) && i >= ((fcgCXX264Mode->SelectedIndex == 5) ? -1 : 0)) {
				cnf_fcgTemp->bitrate = i;
				fcgTXQuality->Text = i.ToString();
				fcgTBQuality->Value = TBBConvert.BitrateToTB(cnf_fcgTemp->bitrate);
			} else {
				fcgTXQuality->Text = lastQualityStr;
				restore = true;
			}
			break;
		case X264_RC_QP:
			if (Int32::TryParse(fcgTXQuality->Text, i)) {
				i = SetTBValue(fcgTBQuality, i);
				cnf_fcgTemp->qp = i;
				fcgTXQuality->Text = Convert::ToString(i);
			}
			break;
		case X264_RC_CRF:
		default:
			if (Double::TryParse(fcgTXQuality->Text, d)) {
				int TBmin = fcgTBQuality->Minimum * 50;
				int TBmax = fcgTBQuality->Maximum * 50;
				i = clamp((int)Math::Round(d * 100), TBmin, TBmax);
				cnf_fcgTemp->crf = i;
				//_ȉ3ڃJbgl
				if (d*1000 != cnf_fcgTemp->crf * 10)
					fcgTXQuality->Text = Convert::ToString(i / 100.0);
			}
			fcgTBQuality->Value = (int)Math::Round(cnf_fcgTemp->crf / 50);
			break;
		}
	}
	//J[\̈ʒu𓮂Ȃ悤   ̂ȂAO͖̓͂̃nY
	fcgTXQuality->SelectionStart = clamp(c - Convert::ToInt32(restore), 0, fcgTXQuality->Text->Length);
	fcgTXQuality->SelectionLength = 0;
	lastQualityStr = fcgTXQuality->Text;
}

System::Void frmConfig::fcgTXQuality_Validating(System::Object^  sender, System::ComponentModel::CancelEventArgs^  e) {
	switch (x264_encmode_to_RCint[fcgCXX264Mode->SelectedIndex]) {
		case X264_RC_BITRATE:
			//[h̏ꍇ͏
			if (fcgCXX264Mode->SelectedIndex == 5 && cnf_fcgTemp->bitrate == -1) {
				fcgTXQuality->Text = STR_BITRATE_AUTO;
			} else
				fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->bitrate);
			break;
		case X264_RC_QP:
			fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->qp);
			break;
		case X264_RC_CRF:
			fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->crf / 100.0);
		default:
			break;
	}
}

System::Void frmConfig::SetTBValueToTextBox() {
	int index = fcgCXX264Mode->SelectedIndex;
	switch (x264_encmode_to_RCint[index]) {
		case X264_RC_BITRATE:
			cnf_fcgTemp->bitrate = TBBConvert.TBToBitrate(fcgTBQuality->Value);
			fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->bitrate);
			break;
		case X264_RC_QP:
			cnf_fcgTemp->qp = fcgTBQuality->Value;
			fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->qp);
			break;
		case X264_RC_CRF:
		default:
			cnf_fcgTemp->crf = fcgTBQuality->Value * 50;
			fcgTXQuality->Text = Convert::ToString(cnf_fcgTemp->crf / 100.0);
			break;
	}
}
System::Boolean frmConfig::EnableSettingsNoteChange(bool Enable) {
	if (fcgTSTSettingsNotes->Visible == Enable &&
		fcgTSLSettingsNotes->Visible == !Enable)
		return true;
	if (CountStringBytes(fcgTSTSettingsNotes->Text) > fcgTSTSettingsNotes->MaxLength - 1) {
		MessageBox::Show(this, L"͂ꂽ܂B炵ĂB", L"G[", MessageBoxButtons::OK, MessageBoxIcon::Error);
		fcgTSTSettingsNotes->Focus();
		fcgTSTSettingsNotes->SelectionStart = fcgTSTSettingsNotes->Text->Length;
		return false;
	}
	fcgTSTSettingsNotes->Visible = Enable;
	fcgTSLSettingsNotes->Visible = !Enable;
	if (Enable) {
		fcgTSTSettingsNotes->Text = fcgTSLSettingsNotes->Text;
		fcgTSTSettingsNotes->Focus();
		bool isDefaultNote = String::Compare(fcgTSTSettingsNotes->Text, String(DefaultStgNotes).ToString()) == 0;
		fcgTSTSettingsNotes->Select((isDefaultNote) ? 0 : fcgTSTSettingsNotes->Text->Length, fcgTSTSettingsNotes->Text->Length);
	} else {
		SetfcgTSLSettingsNotes(fcgTSTSettingsNotes->Text);
		CheckOtherChanges(nullptr, nullptr);
	}
	return true;
}
System::Void frmConfig::fcgTSLSettingsNotes_DoubleClick(System::Object^  sender, System::EventArgs^  e) {
	EnableSettingsNoteChange(true);
}
System::Void frmConfig::fcgTSTSettingsNotes_Leave(System::Object^  sender, System::EventArgs^  e) {
	EnableSettingsNoteChange(false);
}
System::Void frmConfig::fcgTSTSettingsNotes_KeyDown(System::Object^  sender, System::Windows::Forms::KeyEventArgs^  e) {
	if (e->KeyCode == Keys::Return)
		EnableSettingsNoteChange(false);
}
System::Void frmConfig::fcgTSTSettingsNotes_TextChanged(System::Object^  sender, System::EventArgs^  e) {
	SetfcgTSLSettingsNotes(fcgTSTSettingsNotes->Text);
	CheckOtherChanges(nullptr, nullptr);
}
System::Void frmConfig::fcgCXCmdExInsert_FontChanged(System::Object^  sender, System::EventArgs^  e) {
	InitCXCmdExInsert();
}
System::Void frmConfig::fcgCXCmdExInsert_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
	String^ insertStr;
	if (       0 == fcgCXCmdExInsert->SelectedIndex) {
		//Ȃ
	} else if (1 == fcgCXCmdExInsert->SelectedIndex) {			
		//WinXPɂāAOpenFileDialogCurrentDirctoryɕύX₪̂ŁA
		//xۑAƂēKp
		String^ CurrentDir = Directory::GetCurrentDirectory();
		OpenFileDialog^ ofd = gcnew OpenFileDialog();
		ofd->FileName = L"";
		ofd->Multiselect = false;
		ofd->Filter = L"(*.*)|*.*";
		bool ret = (ofd->ShowDialog() == Windows::Forms::DialogResult::OK);
		if (ret) {
			if (sys_dat->exstg->s_local.get_relative_path)
				ofd->FileName = GetRelativePath(ofd->FileName, CurrentDir);
			insertStr = ofd->FileName;
		}
		Directory::SetCurrentDirectory(CurrentDir);
	} else {
		insertStr = String(REPLACE_STRINGS_LIST[fcgCXCmdExInsert->SelectedIndex-2].string).ToString();
	}
	if (insertStr != nullptr && insertStr->Length > 0) {
		int current_selection = fcgTXCmdEx->SelectionStart;
		fcgTXCmdEx->Text = fcgTXCmdEx->Text->Insert(fcgTXCmdEx->SelectionStart, insertStr);
		fcgTXCmdEx->SelectionStart = current_selection + insertStr->Length; //܂ɕςȂƂ֍ŝŔÔߕKv
		fcgTXCmdEx->Focus();
	}
	fcgCXCmdExInsert->SelectedIndex = 0;
}

System::Void frmConfig::AdjustCXDropDownWidth(ComboBox^ CX) {
	System::Drawing::Graphics^ ds = CX->CreateGraphics();
	float maxwidth = 0.0;
	for (int i = 0; i < CX->Items->Count; i++)
		maxwidth = max(maxwidth, ds->MeasureString(CX->Items[i]->ToString(), CX->Font).Width);
	CX->DropDownWidth = (int)(maxwidth + 0.5);
	delete ds;
}

System::Void frmConfig::InitCXCmdExInsert() {
	fcgCXCmdExInsert->BeginUpdate();
	fcgCXCmdExInsert->Items->Clear();
	fcgCXCmdExInsert->Items->Add(L"}...");
	fcgCXCmdExInsert->Items->Add(L"t@C tpX...");
	System::Drawing::Graphics^ ds = fcgCXCmdExInsert->CreateGraphics();
	float max_width_of_string = 0;
	for (int i = 0; REPLACE_STRINGS_LIST[i].desc; i++)
		max_width_of_string = max(max_width_of_string, ds->MeasureString(String(REPLACE_STRINGS_LIST[i].string).ToString() + L" c ", fcgCXCmdExInsert->Font).Width);
	for (int i = 0; REPLACE_STRINGS_LIST[i].desc; i++) {
		String^ AppenStr = String(REPLACE_STRINGS_LIST[i].string).ToString();
		const int length_of_string = AppenStr->Length;
		AppenStr += L" c ";
		for (float current_width = 0.0; current_width < max_width_of_string; AppenStr = AppenStr->Insert(length_of_string, L" "))
			current_width = ds->MeasureString(AppenStr, fcgCXCmdExInsert->Font).Width;
		AppenStr += String(REPLACE_STRINGS_LIST[i].desc).ToString();
		fcgCXCmdExInsert->Items->Add(AppenStr);
	}
	delete ds;
	fcgCXCmdExInsert->SelectedIndex = 0;
	AdjustCXDropDownWidth(fcgCXCmdExInsert);
	fcgCXCmdExInsert->EndUpdate();
}

/////////////    ݒ֘Å֐    ///////////////
System::Void frmConfig::fcgCBAudio2pass_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
	if (fcgCBAudio2pass->Checked) {
		fcgCBAudioUsePipe->Checked = false;
		fcgCBAudioUsePipe->Enabled = false;
	} else if (CurrentPipeEnabled) {
		fcgCBAudioUsePipe->Checked = true;
		fcgCBAudioUsePipe->Enabled = true;
	}
}

System::Void frmConfig::fcgCXAudioEncoder_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
	setAudioDisplay();
}

System::Void frmConfig::fcgCXAudioEncMode_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
	AudioEncodeModeChanged();
}

System::Int32 frmConfig::GetCurrentAudioDefaultBitrate() {
	return sys_dat->exstg->s_aud[fcgCXAudioEncoder->SelectedIndex].mode[fcgCXAudioEncMode->SelectedIndex].bitrate_default;
}

System::Void frmConfig::setAudioDisplay() {
	int index = fcgCXAudioEncoder->SelectedIndex;
	AUDIO_SETTINGS *astg = &sys_dat->exstg->s_aud[index];
	//`̎w
	if (str_has_char(astg->filename)) {
		fcgLBAudioEncoderPath->Text = String(astg->filename).ToString() + L" ̎w";
		fcgTXAudioEncoderPath->Enabled = true;
		fcgTXAudioEncoderPath->Text = LocalStg.audEncPath[index];
		fcgBTAudioEncoderPath->Enabled = true;
	} else {
		//filename󕶎(wavo͎)
		fcgLBAudioEncoderPath->Text = L"";
		fcgTXAudioEncoderPath->Enabled = false;
		fcgTXAudioEncoderPath->Text = L"";
		fcgBTAudioEncoderPath->Enabled = false;
	}
	fcgTXAudioEncoderPath->SelectionStart = fcgTXAudioEncoderPath->Text->Length;
	fcgCXAudioEncMode->BeginUpdate();
	fcgCXAudioEncMode->Items->Clear();
	for (int i = 0; i < astg->mode_count; i++)
		fcgCXAudioEncMode->Items->Add(String(astg->mode[i].name).ToString());
	fcgCXAudioEncMode->EndUpdate();
	bool pipe_enabled = (astg->pipe_input && (!(fcgCBAudio2pass->Checked && astg->mode[index].enc_2pass != 0)));
	CurrentPipeEnabled = pipe_enabled;
	fcgCBAudioUsePipe->Enabled = pipe_enabled;
	fcgCBAudioUsePipe->Checked = pipe_enabled;
	if (fcgCXAudioEncMode->Items->Count > 0)
		fcgCXAudioEncMode->SelectedIndex = 0;
}

System::Void frmConfig::AudioEncodeModeChanged() {
	int index = fcgCXAudioEncMode->SelectedIndex;
	AUDIO_SETTINGS *astg = &sys_dat->exstg->s_aud[fcgCXAudioEncoder->SelectedIndex];
	if (astg->mode[index].bitrate) {
		fcgCXAudioEncMode->Width = fcgCXAudioEncModeSmallWidth;
		fcgLBAudioBitrate->Visible = true;
		fcgNUAudioBitrate->Visible = true;
		fcgNUAudioBitrate->Minimum = astg->mode[index].bitrate_min;
		fcgNUAudioBitrate->Maximum = astg->mode[index].bitrate_max;
		fcgNUAudioBitrate->Increment = astg->mode[index].bitrate_step;
		SetNUValue(fcgNUAudioBitrate, (conf->aud.bitrate != 0) ? conf->aud.bitrate : astg->mode[index].bitrate_default);
	} else {
		fcgCXAudioEncMode->Width = fcgCXAudioEncModeLargeWidth;
		fcgLBAudioBitrate->Visible = false;
		fcgNUAudioBitrate->Visible = false;
		fcgNUAudioBitrate->Minimum = 0;
		fcgNUAudioBitrate->Maximum = 1536; //̍ő僌[g1536kbps
	}
	fcgCBAudio2pass->Enabled = astg->mode[index].enc_2pass != 0;
	if (!fcgCBAudio2pass->Enabled) fcgCBAudio2pass->Checked = false;
	SetfbcBTABEnable(fcgNUAudioBitrate->Visible, (int)fcgNUAudioBitrate->Maximum);
}

///////////////   ݒt@C֘A   //////////////////////
System::Void frmConfig::CheckTSItemsEnabled(CONF_GUIEX *current_conf) {
	bool selected = (CheckedStgMenuItem != nullptr);
	fcgTSBSave->Enabled = (selected && memcmp(cnf_stgSelected, current_conf, sizeof(CONF_GUIEX)));
	fcgTSBDelete->Enabled = selected;
}

System::Void frmConfig::UncheckAllDropDownItem(ToolStripItem^ mItem) {
	ToolStripDropDownItem^ DropDownItem = dynamic_cast<ToolStripDropDownItem^>(mItem);
	if (DropDownItem == nullptr)
		return;
	for (int i = 0; i < DropDownItem->DropDownItems->Count; i++) {
		UncheckAllDropDownItem(DropDownItem->DropDownItems[i]);
		ToolStripMenuItem^ item = dynamic_cast<ToolStripMenuItem^>(DropDownItem->DropDownItems[i]);
		if (item != nullptr)
			item->Checked = false;
	}
}

System::Void frmConfig::CheckTSSettingsDropDownItem(ToolStripMenuItem^ mItem) {
	UncheckAllDropDownItem(fcgTSSettings);
	CheckedStgMenuItem = mItem;
	fcgTSSettings->Text = (mItem == nullptr) ? L"vt@C" : mItem->Text;
	if (mItem != nullptr)
		mItem->Checked = true;
	fcgTSBSave->Enabled = false;
	fcgTSBDelete->Enabled = (mItem != nullptr);
}

ToolStripMenuItem^ frmConfig::fcgTSSettingsSearchItem(String^ stgPath, ToolStripItem^ mItem) {
	if (stgPath == nullptr)
		return nullptr;
	ToolStripDropDownItem^ DropDownItem = dynamic_cast<ToolStripDropDownItem^>(mItem);
	if (DropDownItem == nullptr)
		return nullptr;
	for (int i = 0; i < DropDownItem->DropDownItems->Count; i++) {
		ToolStripMenuItem^ item = fcgTSSettingsSearchItem(stgPath, DropDownItem->DropDownItems[i]);
		if (item != nullptr)
			return item;
		item = dynamic_cast<ToolStripMenuItem^>(DropDownItem->DropDownItems[i]);
		if (item      != nullptr && 
			item->Tag != nullptr && 
			0 == String::Compare(item->Tag->ToString(), stgPath, true))
			return item;
	}
	return nullptr;
}

ToolStripMenuItem^ frmConfig::fcgTSSettingsSearchItem(String^ stgPath) {
	return fcgTSSettingsSearchItem((stgPath != nullptr && stgPath->Length > 0) ? Path::GetFullPath(stgPath) : nullptr, fcgTSSettings);
}

System::Void frmConfig::SaveToStgFile(String^ stgName) {
	size_t nameLen = CountStringBytes(stgName) + 1; 
	char *stg_name = (char *)malloc(nameLen);
	GetCHARfromString(stg_name, nameLen, stgName);
	init_CONF_GUIEX(cnf_stgSelected, fcgCBUsehighbit->Checked);
	FrmToConf(cnf_stgSelected);
	String^ stgDir = Path::GetDirectoryName(stgName);
	if (!Directory::Exists(stgDir))
		Directory::CreateDirectory(stgDir);
	guiEx_config exCnf;
	int result = exCnf.save_x264guiEx_conf(cnf_stgSelected, stg_name);
	free(stg_name);
	switch (result) {
		case CONF_ERROR_FILE_OPEN:
			MessageBox::Show(L"ݒt@CI[vɎs܂B", L"G[", MessageBoxButtons::OK, MessageBoxIcon::Error);
			return;
		case CONF_ERROR_INVALID_FILENAME:
			MessageBox::Show(L"t@CɎgpłȂ܂܂Ă܂B\nۑł܂B", L"G[", MessageBoxButtons::OK, MessageBoxIcon::Error);
			return;
		default:
			break;
	}
	init_CONF_GUIEX(cnf_stgSelected, fcgCBUsehighbit->Checked);
	FrmToConf(cnf_stgSelected);
}

System::Void frmConfig::fcgTSBSave_Click(System::Object^  sender, System::EventArgs^  e) {
	if (CheckedStgMenuItem != nullptr)
		SaveToStgFile(CheckedStgMenuItem->Tag->ToString());
	CheckTSSettingsDropDownItem(CheckedStgMenuItem);
}

System::Void frmConfig::fcgTSBSaveNew_Click(System::Object^  sender, System::EventArgs^  e) {
	frmSaveNewStg::Instance::get()->setStgDir(String(sys_dat->exstg->s_local.stg_dir).ToString());
	if (CheckedStgMenuItem != nullptr)
		frmSaveNewStg::Instance::get()->setFilename(CheckedStgMenuItem->Text);
	frmSaveNewStg::Instance::get()->ShowDialog();
	String^ stgName = frmSaveNewStg::Instance::get()->StgFileName;
	if (stgName != nullptr && stgName->Length)
		SaveToStgFile(stgName);
	RebuildStgFileDropDown(nullptr);
	CheckTSSettingsDropDownItem(fcgTSSettingsSearchItem(stgName));
}

System::Void frmConfig::DeleteStgFile(ToolStripMenuItem^ mItem) {
	if (System::Windows::Forms::DialogResult::OK ==
		MessageBox::Show(L"ݒt@C " + mItem->Text + L" 폜Ă낵ł?",
		L"G[", MessageBoxButtons::OKCancel, MessageBoxIcon::Exclamation)) 
	{
		File::Delete(mItem->Tag->ToString());
		RebuildStgFileDropDown(nullptr);
		CheckTSSettingsDropDownItem(nullptr);
		SetfcgTSLSettingsNotes(L"");
	}
}

System::Void frmConfig::fcgTSBDelete_Click(System::Object^  sender, System::EventArgs^  e) {
	DeleteStgFile(CheckedStgMenuItem);
}

System::Void frmConfig::fcgTSSettings_DropDownItemClicked(System::Object^  sender, System::Windows::Forms::ToolStripItemClickedEventArgs^  e) {
	ToolStripMenuItem^ ClickedMenuItem = dynamic_cast<ToolStripMenuItem^>(e->ClickedItem);
	if (ClickedMenuItem == nullptr)
		return;
	if (ClickedMenuItem->Tag == nullptr || ClickedMenuItem->Tag->ToString()->Length == 0)
		return;
	CONF_GUIEX load_stg;
	guiEx_config exCnf;
	char stg_path[MAX_PATH_LEN];
	GetCHARfromString(stg_path, sizeof(stg_path), ClickedMenuItem->Tag->ToString());
	if (exCnf.load_x264guiEx_conf(&load_stg, stg_path) == CONF_ERROR_FILE_OPEN) {
		if (MessageBox::Show(L"ݒt@CI[vɎs܂B\n"
			               + L"̃t@C폜܂?",
						   L"G[", MessageBoxButtons::YesNo, MessageBoxIcon::Error)
						   == System::Windows::Forms::DialogResult::Yes)
			DeleteStgFile(ClickedMenuItem);
		return;
	}
	ConfToFrm(&load_stg, true);
	CheckTSSettingsDropDownItem(ClickedMenuItem);
	memcpy(cnf_stgSelected, &load_stg, sizeof(CONF_GUIEX));
}

System::Void frmConfig::RebuildStgFileDropDown(ToolStripDropDownItem^ TS, String^ dir) {
	array<String^>^ subDirs = Directory::GetDirectories(dir);
	for (int i = 0; i < subDirs->Length; i++) {
		ToolStripMenuItem^ DDItem = gcnew ToolStripMenuItem(L"[ " + subDirs[i]->Substring(dir->Length+1) + L" ]");
		DDItem->DropDownItemClicked += gcnew System::Windows::Forms::ToolStripItemClickedEventHandler(this, &frmConfig::fcgTSSettings_DropDownItemClicked);
		DDItem->ForeColor = Color::Blue;
		DDItem->Tag = nullptr;
		RebuildStgFileDropDown(DDItem, subDirs[i]);
		TS->DropDownItems->Add(DDItem);
	}
	array<String^>^ stgList = Directory::GetFiles(dir, L"*.stg");
	for (int i = 0; i < stgList->Length; i++) {
		ToolStripMenuItem^ mItem = gcnew ToolStripMenuItem(Path::GetFileNameWithoutExtension(stgList[i]));
		mItem->Tag = stgList[i];
		TS->DropDownItems->Add(mItem);
	}
}

System::Void frmConfig::RebuildStgFileDropDown(String^ stgDir) {
	fcgTSSettings->DropDownItems->Clear();
	if (stgDir != nullptr)
		CurrentStgDir = stgDir;
	if (!Directory::Exists(CurrentStgDir))
		Directory::CreateDirectory(CurrentStgDir);
	RebuildStgFileDropDown(fcgTSSettings, Path::GetFullPath(CurrentStgDir));
}

//////////////   ֘A     ////////////////
System::Void frmConfig::InitData(CONF_GUIEX *set_config, const SYSTEM_DATA *system_data) {
	if (set_config->size_all != CONF_INITIALIZED) {
		//ĂȂΏ
		init_CONF_GUIEX(set_config, FALSE);
	}
	conf = set_config;
	sys_dat = system_data;
}

System::Void frmConfig::InitComboBox() {
	//R{{bNXɒlݒ肷
	setComboBox(fcgCXAQMode,         list_aq);
	setComboBox(fcgCXAspectRatio,    aspect_desc);
	setComboBox(fcgCXAudioTempDir,   audtempdir_desc);
	setComboBox(fcgCXBAdpapt,        list_b_adpat);
	setComboBox(fcgCXBpyramid,       list_b_pyramid);
	setComboBox(fcgCXColorMatrix,    list_colormatrix);
	setComboBox(fcgCXColorPrim,      list_colorprim);
	setComboBox(fcgCXInputRange,     list_input_range);
	setComboBox(fcgCXDirectME,       list_direct);
	setComboBox(fcgCXLevel,          list_x264guiEx_level);
	setComboBox(fcgCXLogLevel,       list_log_type);
	setComboBox(fcgCXME,             list_me);
	setComboBox(fcgCXMP4BoxTempDir,  mp4boxtempdir_desc);
	setComboBox(fcgCXNalHrd,         list_nal_hrd);
	setComboBox(fcgCXOutputCsp,      list_output_csp);
	setComboBox(fcgCXPreset,         sys_dat->exstg->s_x264.preset.name);
	setComboBox(fcgCXProfile,        sys_dat->exstg->s_x264.profile.name);
	setComboBox(fcgCXTune,		     sys_dat->exstg->s_x264.tune.name);
	setComboBox(fcgCXSubME,          list_subme);
	setComboBox(fcgCXTempDir,        tempdir_desc);
	setComboBox(fcgCXTransfer,       list_transfer);
	setComboBox(fcgCXTrellis,        list_trellis);
	setComboBox(fcgCXVideoFormat,    list_videoformat);
	setComboBox(fcgCXX264Mode,       x264_encodemode_desc);
	setComboBox(fcgCXWeightP,        list_weightp);
	setComboBox(fcgCXInterlaced,     interlaced_desc);

	setComboBox(fcgCXAudioEncTiming, audio_enc_timing_desc);

	InitCXCmdExInsert();

	setMuxerCmdExNames(fcgCXMP4CmdEx, MUXER_MP4);
	setMuxerCmdExNames(fcgCXMKVCmdEx, MUXER_MKV);
	setMuxerCmdExNames(fcgCXMPGCmdEx, MUXER_MPG);

	setAudioEncoderNames();

	setPriorityList(fcgCXX264Priority);
	setPriorityList(fcgCXMuxPriority);
	setPriorityList(fcgCXAudioPriority);
}

System::Void frmConfig::SetTXMaxLen(TextBox^ TX, int max_len) {
	TX->MaxLength = max_len;
	TX->Validating += gcnew System::ComponentModel::CancelEventHandler(this, &frmConfig::TX_LimitbyBytes);
}

System::Void frmConfig::SetTXMaxLenAll() {
	//MaxLengthɍő啶ZbgAƂɃoCgvZsCxgZbgB
	SetTXMaxLen(fcgTXCmdEx,                sizeof(conf->vid.cmdex) - 1);
	SetTXMaxLen(fcgTXX264Path,             sizeof(sys_dat->exstg->s_x264.fullpath) - 1);
	SetTXMaxLen(fcgTXX264PathSub,          sizeof(sys_dat->exstg->s_x264.fullpath) - 1);
	SetTXMaxLen(fcgTXX264PathSubhighbit,   sizeof(sys_dat->exstg->s_x264.fullpath_highbit) - 1);
	SetTXMaxLen(fcgTXAudioEncoderPath,     sizeof(sys_dat->exstg->s_aud[0].fullpath) - 1);
	SetTXMaxLen(fcgTXMP4MuxerPath,         sizeof(sys_dat->exstg->s_mux[MUXER_MP4].fullpath) - 1);
	SetTXMaxLen(fcgTXMKVMuxerPath,         sizeof(sys_dat->exstg->s_mux[MUXER_MKV].fullpath) - 1);
	SetTXMaxLen(fcgTXTC2MP4Path,           sizeof(sys_dat->exstg->s_mux[MUXER_TC2MP4].fullpath) - 1);
	SetTXMaxLen(fcgTXMPGMuxerPath,         sizeof(sys_dat->exstg->s_mux[MUXER_MPG].fullpath) - 1);
	SetTXMaxLen(fcgTXMP4RawPath,           sizeof(sys_dat->exstg->s_mux[MUXER_MP4_RAW].fullpath) - 1);
	SetTXMaxLen(fcgTXCustomTempDir,        sizeof(sys_dat->exstg->s_local.custom_tmp_dir) - 1);
	SetTXMaxLen(fcgTXCustomAudioTempDir,   sizeof(sys_dat->exstg->s_local.custom_audio_tmp_dir) - 1);
	SetTXMaxLen(fcgTXMP4BoxTempDir,        sizeof(sys_dat->exstg->s_local.custom_mp4box_tmp_dir) - 1);
	SetTXMaxLen(fcgTXStatusFile,           sizeof(conf->vid.stats) - 1);
	SetTXMaxLen(fcgTXTCIN,                 sizeof(conf->vid.tcfile_in) - 1);
	SetTXMaxLen(fcgTXCQM,                  sizeof(conf->vid.cqmfile) - 1);
	SetTXMaxLen(fcgTXBatBeforePath,        sizeof(conf->oth.batfile_before) - 1);
	SetTXMaxLen(fcgTXBatAfterPath,         sizeof(conf->oth.batfile_after) - 1);

	fcgTSTSettingsNotes->MaxLength     =   sizeof(conf->oth.notes) - 1;
}

System::Void frmConfig::InitStgFileList() {
	RebuildStgFileDropDown(String(sys_dat->exstg->s_local.stg_dir).ToString());
	stgChanged = false;
	CheckTSSettingsDropDownItem(nullptr);
}

System::Void frmConfig::fcgChangeEnabled(System::Object^  sender, System::EventArgs^  e) {
	fcgLBX264PathSub->Visible = fcgTSBCMDOnly->Checked;
	fcgLBX264PathSub8bit->Visible = fcgTSBCMDOnly->Checked;
	fcgLBX264PathSubhighbit->Visible = fcgTSBCMDOnly->Checked;
	fcgTXX264PathSub->Visible = fcgTSBCMDOnly->Checked;
	fcgBTX264PathSub->Visible = fcgTSBCMDOnly->Checked;
	fcgTXX264PathSubhighbit->Visible = fcgTSBCMDOnly->Checked;
	fcgBTX264PathSubhighbit->Visible = fcgTSBCMDOnly->Checked;
	fcggroupBoxDeblock->Enabled = fcgCBDeblock->Checked;
	fcgTXTCIN->Enabled = fcgCBTCIN->Checked;
	fcgBTTCIN->Enabled = fcgCBTCIN->Checked;
	fcgNUTimebaseDen->Enabled = fcgCBTimeBase->Checked;
	fcgNUTimebaseNum->Enabled = fcgCBTimeBase->Checked;
	fcgBTCmdEx->Visible = !fcgTSBCMDOnly->Checked;
	fcgCBNulOutCLI->Visible = fcgTSBCMDOnly->Checked;
}

System::Void frmConfig::fcgChangeMuxerVisible(System::Object^  sender, System::EventArgs^  e) {
	//tc2mp4̃`FbN
	const bool enable_tc2mp4_muxer = (0 != str_has_char(sys_dat->exstg->s_mux[MUXER_TC2MP4].base_cmd));
	fcgTXTC2MP4Path->Visible = enable_tc2mp4_muxer;
	fcgLBTC2MP4Path->Visible = enable_tc2mp4_muxer;
	fcgBTTC2MP4Path->Visible = enable_tc2mp4_muxer;
	//mp4 raw̃`FbN
	const bool enable_mp4raw_muxer = (0 != str_has_char(sys_dat->exstg->s_mux[MUXER_MP4_RAW].base_cmd));
	fcgTXMP4RawPath->Visible = enable_mp4raw_muxer;
	fcgLBMP4RawPath->Visible = enable_mp4raw_muxer;
	fcgBTMP4RawPath->Visible = enable_mp4raw_muxer;
	//ꎞtH_̃`FbN
	const bool enable_mp4_tmp = (0 != str_has_char(sys_dat->exstg->s_mux[MUXER_MP4].tmp_cmd));
	fcgCXMP4BoxTempDir->Visible = enable_mp4_tmp;
	fcgLBMP4BoxTempDir->Visible = enable_mp4_tmp;
	fcgTXMP4BoxTempDir->Visible = enable_mp4_tmp;
	fcgBTMP4BoxTempDir->Visible = enable_mp4_tmp;
	//Apple Chapter̃`FbN
	bool enable_mp4_apple_cmdex = false;
	for (int i = 0; i < sys_dat->exstg->s_mux[MUXER_MP4].ex_count; i++)
		enable_mp4_apple_cmdex |= (0 != str_has_char(sys_dat->exstg->s_mux[MUXER_MP4].ex_cmd[i].cmd_apple));
	fcgCBMP4MuxApple->Visible = enable_mp4_apple_cmdex;

	//ʒu̒
	static const int HEIGHT = 31;
	fcgLBTC2MP4Path->Location = Point(fcgLBTC2MP4Path->Location.X, fcgLBMP4MuxerPath->Location.Y + HEIGHT * enable_tc2mp4_muxer);
	fcgTXTC2MP4Path->Location = Point(fcgTXTC2MP4Path->Location.X, fcgTXMP4MuxerPath->Location.Y + HEIGHT * enable_tc2mp4_muxer);
	fcgBTTC2MP4Path->Location = Point(fcgBTTC2MP4Path->Location.X, fcgBTMP4MuxerPath->Location.Y + HEIGHT * enable_tc2mp4_muxer);
	fcgLBMP4RawPath->Location = Point(fcgLBMP4RawPath->Location.X, fcgLBTC2MP4Path->Location.Y   + HEIGHT * enable_mp4raw_muxer);
	fcgTXMP4RawPath->Location = Point(fcgTXMP4RawPath->Location.X, fcgTXTC2MP4Path->Location.Y   + HEIGHT * enable_mp4raw_muxer);
	fcgBTMP4RawPath->Location = Point(fcgBTMP4RawPath->Location.X, fcgBTTC2MP4Path->Location.Y   + HEIGHT * enable_mp4raw_muxer);
}

System::Void frmConfig::SetStgEscKey(bool Enable) {
	if (this->KeyPreview == Enable)
		return;
	this->KeyPreview = Enable;
	if (Enable)
		this->KeyDown += gcnew System::Windows::Forms::KeyEventHandler(this, &frmConfig::frmConfig_KeyDown);
	else
		this->KeyDown -= gcnew System::Windows::Forms::KeyEventHandler(this, &frmConfig::frmConfig_KeyDown);
}

System::Void frmConfig::AdjustLocation() {
	//fXNgbv̈(^XNo[)
	System::Drawing::Rectangle screen = System::Windows::Forms::Screen::GetWorkingArea(this);
	//݂̃fXNgbv̈̍W
	Point CurrentDesktopLocation = this->DesktopLocation::get();
	//`FbNJn
	bool ChangeLocation = false;
	if (CurrentDesktopLocation.X + this->Size.Width > screen.Width) {
		ChangeLocation = true;
		CurrentDesktopLocation.X = clamp(screen.X - this->Size.Width, 4, CurrentDesktopLocation.X);
	}
	if (CurrentDesktopLocation.Y + this->Size.Height > screen.Height) {
		ChangeLocation = true;
		CurrentDesktopLocation.Y = clamp(screen.Y - this->Size.Height, 4, CurrentDesktopLocation.Y);
	}
	if (ChangeLocation) {
		this->StartPosition = FormStartPosition::Manual;
		this->DesktopLocation::set(CurrentDesktopLocation);
	}
}

System::Void frmConfig::InitForm() {
	//[Jݒ̃[h
	LoadLocalStg();
	//[Jݒ̔f
	SetLocalStg();
	//ݒt@CW̏
	InitStgFileList();
	//R{{bNX̒lݒ
	InitComboBox();
	//^CR[happendix(tCq)𔽉f
	fcgCBAuoTcfileout->Text = L"^CR[ho (" + String(sys_dat->exstg->s_append.tc).ToString() + L")";
	//^Cg\
	this->Text = String(AUO_FULL_NAME).ToString();
	//o[W,RpC
	fcgLBVersion->Text     = String(AUO_VERSION_NAME).ToString();
	fcgLBVersionDate->Text = L"build " + String(__DATE__).ToString() + L" " + String(__TIME__).ToString();
	//Xbh
	int max_threads_set = (int)(cpu_core_count() * 1.5 + 0.51);
	fcgNUThreads->Maximum = max_threads_set;
	fcgNULookaheadThreads->Maximum = max_threads_set;
	//^C}[̏
	InitTimer();
	//c[`bv
	SetHelpToolTips();
	SetX264VersionToolTip(LocalStg.x264Path, false);
	SetX264VersionToolTip(LocalStg.x264Pathhighbit, true);
	ActivateToolTip(sys_dat->exstg->s_local.disable_tooltip_help == FALSE);
	//p[^Zbg
	ConfToFrm(conf, true);
	//CxgZbg
	SetTXMaxLenAll(); //eLXg{bNX̍ő啶
	SetAllCheckChangedEvents(this); //ύX̊mF,łNU
	//tH[̕ύXsXV
	fcgChangeMuxerVisible(nullptr, nullptr);
	fcgChangeEnabled(nullptr, nullptr);
	fcgCBAFS_CheckedChanged(nullptr, nullptr);
	EnableSettingsNoteChange(false);
	//R}hC̍XV
	fcgRebuildCmd(nullptr, nullptr);
	//\ʒu̒
	AdjustLocation();
	AddfcgLBAMPAutoBitrate();
	AddCheckAMPAutoBitrateEvent();
	//L[ݒ
	SetStgEscKey(sys_dat->exstg->s_local.enable_stg_esc_key != 0);
	//tHg̐ݒ
	if (str_has_char(sys_dat->exstg->s_local.conf_font.name))
		SetFontFamilyToForm(this, gcnew FontFamily(String(sys_dat->exstg->s_local.conf_font.name).ToString()), this->Font->FontFamily);
}

/////////////         f[^ <-> GUI     /////////////
System::Void frmConfig::ConfToFrm(CONF_GUIEX *cnf, bool all) {
	//Ђ珑B߂ǂ
	CONF_X264 *cx264 = &cnf->x264;
	memcpy(cnf_fcgTemp, cx264, sizeof(CONF_X264)); //ꎞۑp
	this->SuspendLayout();
	fcgCBUsehighbit->Checked = cx264->use_highbit_depth != 0;
	switch (cx264->rc_mode) {
		case X264_RC_QP:
			fcgCXX264Mode->SelectedIndex = 1;
			break;
		case X264_RC_BITRATE:
			if (cx264->use_auto_npass)
				fcgCXX264Mode->SelectedIndex = 5;
			else {
				switch (cx264->pass) {
					case 0:  fcgCXX264Mode->SelectedIndex = 0; break;
					case 1:  fcgCXX264Mode->SelectedIndex = 3; break;
					default: fcgCXX264Mode->SelectedIndex = 4; break;
				}
			}
			break;
		case X264_RC_CRF:
		default:
			fcgCXX264Mode->SelectedIndex = (cx264->use_auto_npass) ? 6 : 2;
			break;
	}
	fcgCXX264Mode_SelectedIndexChanged(nullptr, nullptr); //ƂȂƍXVȂƂ

	SetNUValue(fcgNUAutoNPass,        cx264->auto_npass);
	SetCXIndex(fcgCXPreset,           cx264->preset);
	SetCXIndex(fcgCXTune,             cx264->tune);
	SetCXIndex(fcgCXProfile,          cx264->profile);
	fcgCBAMPLimitBitrate->Checked  = (cnf->vid.amp_check & AMPLIMIT_BITRATE) != 0;
	fcgCBAMPLimitFileSize->Checked = (cnf->vid.amp_check & AMPLIMIT_FILE_SIZE) != 0;
	SetNUValue(fcgNUAMPLimitFileSize, cnf->vid.amp_limit_file_size);
	SetNUValue(fcgNUAMPLimitBitrate,  cnf->vid.amp_limit_bitrate);
	SetCXIndex(fcgCXLevel,            cx264->h264_level);
	SetCXIndex(fcgCXVideoFormat,      cx264->videoformat);
	fcgCBAud->Checked               = cx264->aud != 0;
	fcgCBPicStruct->Checked         = cx264->pic_struct != 0;
	SetCXIndex(fcgCXNalHrd,           cx264->nal_hrd);
	SetCXIndex(fcgCXOutputCsp,        cx264->output_csp);
	fcgCBBlurayCompat->Checked      = cx264->bluray_compat != 0;
	SetCXIndex(fcgCXColorMatrix,      cx264->colormatrix);
	SetCXIndex(fcgCXColorPrim,        cx264->colorprim);
	SetCXIndex(fcgCXTransfer,         cx264->transfer);
	SetCXIndex(fcgCXInputRange,       cx264->input_range);

	if (cx264->sar.x * cx264->sar.y < 0)
		cx264->sar.x = cx264->sar.y = 0;
	fcgCXAspectRatio->SelectedIndex= (cx264->sar.x < 0);
	SetNUValue(fcgNUAspectRatioX, abs(cx264->sar.x));
	SetNUValue(fcgNUAspectRatioY, abs(cx264->sar.y));

	SetNUValue(fcgNUThreads,          cx264->threads);
	SetNUValue(fcgNULookaheadThreads, cx264->lookahead_threads);
	fcgCBSlicedThreads->Checked     = cx264->sliced_threading != 0;

	SetCXIndex(fcgCXLogLevel,         cx264->log_mode);
	fcgCBPSNR->Checked              = cx264->psnr != 0;
	fcgCBSSIM->Checked              = cx264->ssim != 0;

	SetNUValue(fcgNUIPRatio,   ((int)(cx264->ip_ratio * 100 + 0.5) - 100));
	SetNUValue(fcgNUPBRatio,   ((int)(cx264->pb_ratio * 100 + 0.5) - 100));
	SetNUValue(fcgNUQcomp,      (int)(cx264->qp_compress * 100 + 0.5));
	SetNUValue(fcgNUQpmin,            cx264->qp_min);
	SetNUValue(fcgNUQpmax,            cx264->qp_max);
	SetNUValue(fcgNUQpstep,           cx264->qp_step);
	SetNUValue(fcgNUChromaQp,         cx264->chroma_qp_offset);
	SetCXIndex(fcgCXAQMode,           cx264->aq_mode);
	SetNUValue(fcgNUAQStrength,       cx264->aq_strength);
	SetNUValue(fcgNUPsyRDO,           cx264->psy_rd.x);
	SetNUValue(fcgNUPsyTrellis,       cx264->psy_rd.y);
	fcgCBMBTree->Checked            = cx264->mbtree != 0;
	SetNUValue(fcgNURCLookahead,      cx264->rc_lookahead);
	SetNUValue(fcgNUVBVmax,           cx264->vbv_maxrate);
	SetNUValue(fcgNUVBVbuf,           cx264->vbv_bufsize);

	SetNUValue(fcgNUScenecut,         cx264->scenecut);
	SetNUValue(fcgNUKeyint,           cx264->keyint_max);
	SetNUValue(fcgNUMinKeyint,        cx264->keyint_min);
	fcgCBOpenGOP->Checked           = cx264->open_gop != 0;

	fcgCBDeblock->Checked           = cx264->use_deblock != 0;
	SetNUValue(fcgNUDeblockStrength,  cx264->deblock.x);
	SetNUValue(fcgNUDeblockThreshold, cx264->deblock.y);

	fcgCBCABAC->Checked = cx264->cabac != 0;
	SetNUValue(fcgNUSlices,           cx264->slice_n);
	SetCXIndex(fcgCXWeightP,          cx264->weight_p);
	
	fcgCXInterlaced->SelectedIndex  = (!cx264->interlaced) ? 0 : ((cx264->tff) ? 1 : 2);

	SetNUValue(fcgNUBframes,          cx264->bframes);
	SetCXIndex(fcgCXBAdpapt,          cx264->b_adapt);
	SetNUValue(fcgNUBBias,            cx264->b_bias);
	SetCXIndex(fcgCXBpyramid,         cx264->b_pyramid);
	fcgCBWeightB->Checked           = cx264->weight_b != 0;

	fcgCB8x8dct->Checked            = cx264->dct8x8 != 0;
	fcgCBp8x8->Checked             = (cx264->mb_partition & MB_PARTITION_P8x8) != 0;
	fcgCBb8x8->Checked             = (cx264->mb_partition & MB_PARTITION_B8x8) != 0;
	fcgCBp4x4->Checked             = (cx264->mb_partition & MB_PARTITION_P4x4) != 0;
	fcgCBi8x8->Checked             = (cx264->mb_partition & MB_PARTITION_I8x8) != 0;
	fcgCBi4x4->Checked             = (cx264->mb_partition & MB_PARTITION_I4x4) != 0;

	fcgCBfastpskip->Checked         = cx264->no_fast_pskip == 0;
	fcgCBDctDecimate->Checked       = cx264->no_dct_decimate == 0;
	SetCXIndex(fcgCXTrellis,          cx264->trellis);
	SetCQM(cx264->cqm,                cnf->vid.cqmfile);

	SetCXIndex(fcgCXME,               cx264->me);
	SetCXIndex(fcgCXSubME,            cx264->subme);
	SetNUValue(fcgNUMERange,          cx264->me_range);
	fcgCBChromaME->Checked          = cx264->chroma_me != 0;
	SetCXIndex(fcgCXDirectME,         cx264->direct_mv);
	SetNUValue(fcgNURef,              cx264->ref_frames);
	fcgCBMixedRef->Checked          = cx264->mixed_ref != 0;

	fcgCBTCIN->Checked              = cx264->use_tcfilein != 0;
	fcgCBTimeBase->Checked          = cx264->use_timebase != 0;
	SetNUValue(fcgNUTimebaseNum,      cx264->timebase.x);
	SetNUValue(fcgNUTimebaseDen,      cx264->timebase.y);

	if (all) {
		//敔
		fcgTXStatusFile->Text = (str_has_char(cnf->vid.stats))     ? String(cnf->vid.stats).ToString() : String(DefaultStatusFilePath).ToString();
		fcgTXTCIN->Text       = (str_has_char(cnf->vid.tcfile_in)) ? String(cnf->vid.tcfile_in).ToString() : String(DefaultTcFilePath).ToString();

		fcgCBAFS->Checked                  = cnf->vid.afs != 0;
		fcgCBAFSBitrateCorrection->Checked = cnf->vid.afs_bitrate_correction != 0;
		fcgCBAuoTcfileout->Checked         = cnf->vid.auo_tcfile_out != 0;
		fcgCBCheckKeyframes->Checked       =(cnf->vid.check_keyframe & CHECK_KEYFRAME_AVIUTL) != 0;
		fcgCBSetKeyframeAtChapter->Checked =(cnf->vid.check_keyframe & CHECK_KEYFRAME_CHAPTER) != 0;
		fcgCBInputAsLW48->Checked          = cnf->vid.input_as_lw48 != 0;

		SetCXIndex(fcgCXX264Priority,        cnf->vid.priority);
		SetCXIndex(fcgCXTempDir,             cnf->oth.temp_dir);

		fcgTXCmdEx->Text            = String(cnf->vid.cmdex).ToString();
		if (cnf->oth.disable_guicmd)
			fcgCBNulOutCLI->Checked        = cnf->x264.nul_out != 0;

		//
		fcgCBAudioOnly->Checked            = cnf->oth.out_audio_only != 0;
		fcgCBFAWCheck->Checked             = cnf->aud.faw_check != 0;
		SetCXIndex(fcgCXAudioEncoder,        cnf->aud.encoder);
		fcgCBAudio2pass->Checked           = cnf->aud.use_2pass != 0;
		fcgCBAudioUsePipe->Checked = (CurrentPipeEnabled && !cnf->aud.use_wav);
		SetCXIndex(fcgCXAudioEncMode,        cnf->aud.enc_mode);
		SetNUValue(fcgNUAudioBitrate,       (cnf->aud.bitrate != 0) ? cnf->aud.bitrate : GetCurrentAudioDefaultBitrate());
		SetCXIndex(fcgCXAudioPriority,       cnf->aud.priority);
		SetCXIndex(fcgCXAudioTempDir,        cnf->aud.aud_temp_dir);
		SetCXIndex(fcgCXAudioEncTiming,      cnf->aud.audio_encode_timing);

		//mux
		fcgCBMP4MuxerExt->Checked          = cnf->mux.disable_mp4ext == 0;
		fcgCBMP4MuxApple->Checked          = cnf->mux.apple_mode != 0;
		SetCXIndex(fcgCXMP4CmdEx,            cnf->mux.mp4_mode);
		SetCXIndex(fcgCXMP4BoxTempDir,       cnf->mux.mp4_temp_dir);
		fcgCBMKVMuxerExt->Checked          = cnf->mux.disable_mkvext == 0;
		SetCXIndex(fcgCXMKVCmdEx,            cnf->mux.mkv_mode);
		fcgCBMPGMuxerExt->Checked          = cnf->mux.disable_mpgext == 0;
		SetCXIndex(fcgCXMPGCmdEx,            cnf->mux.mpg_mode);
		SetCXIndex(fcgCXMuxPriority,         cnf->mux.priority);

		fcgCBRunBatBefore->Checked         =(cnf->oth.run_bat & RUN_BAT_BEFORE) != 0;
		fcgCBRunBatAfter->Checked          =(cnf->oth.run_bat & RUN_BAT_AFTER) != 0;
		fcgCBWaitForBatBefore->Checked     =(cnf->oth.dont_wait_bat_fin & RUN_BAT_BEFORE) == 0;
		fcgCBWaitForBatAfter->Checked      =(cnf->oth.dont_wait_bat_fin & RUN_BAT_AFTER) == 0;
		fcgTXBatBeforePath->Text           = String(cnf->oth.batfile_before).ToString();
		fcgTXBatAfterPath->Text            = String(cnf->oth.batfile_after).ToString();

		SetfcgTSLSettingsNotes(cnf->oth.notes);

		//cli mode
		fcgTSBCMDOnly->Checked             = cnf->oth.disable_guicmd != 0;
	}

	this->ResumeLayout();
	this->PerformLayout();
}

System::Void frmConfig::FrmToConf(CONF_GUIEX *cnf) {
	//Ђ珑B߂ǂ
	//x264
	cnf->x264.use_highbit_depth    = fcgCBUsehighbit->Checked;
	cnf->x264.rc_mode              = cnf_fcgTemp->rc_mode;
	cnf->x264.bitrate              = cnf_fcgTemp->bitrate;
	cnf->x264.qp                   = cnf_fcgTemp->qp;
	cnf->x264.crf                  = cnf_fcgTemp->crf;
	cnf->x264.nul_out              = fcgCBNulOut->Checked;
	cnf->x264.pass                 = cnf_fcgTemp->pass;
	cnf->x264.slow_first_pass      = cnf_fcgTemp->slow_first_pass;
	cnf->x264.use_auto_npass       = cnf_fcgTemp->use_auto_npass;
	cnf->x264.auto_npass           = (int)fcgNUAutoNPass->Value;
	cnf->vid.amp_check             = NULL;
	cnf->vid.amp_check            |= fcgCBAMPLimitBitrate->Checked ? AMPLIMIT_BITRATE : NULL;
	cnf->vid.amp_check            |= fcgCBAMPLimitFileSize->Checked ? AMPLIMIT_FILE_SIZE : NULL;
	cnf->vid.amp_limit_bitrate     = (double)fcgNUAMPLimitBitrate->Value;
	cnf->vid.amp_limit_file_size   = (double)fcgNUAMPLimitFileSize->Value;
	cnf->x264.preset               = fcgCXPreset->SelectedIndex;
	cnf->x264.tune                 = fcgCXTune->SelectedIndex;
	cnf->x264.profile              = fcgCXProfile->SelectedIndex;
	cnf->x264.h264_level           = fcgCXLevel->SelectedIndex;
	cnf->x264.videoformat          = fcgCXVideoFormat->SelectedIndex;
	cnf->x264.aud                  = fcgCBAud->Checked;
	cnf->x264.pic_struct           = fcgCBPicStruct->Checked;
	cnf->x264.nal_hrd              = fcgCXNalHrd->SelectedIndex;
	cnf->x264.output_csp           = fcgCXOutputCsp->SelectedIndex;
	cnf->x264.bluray_compat        = fcgCBBlurayCompat->Checked;
	cnf->x264.colormatrix          = fcgCXColorMatrix->SelectedIndex;
	cnf->x264.colorprim            = fcgCXColorPrim->SelectedIndex;
	cnf->x264.transfer             = fcgCXTransfer->SelectedIndex;
	cnf->x264.input_range          = fcgCXInputRange->SelectedIndex;
	cnf->x264.sar.x                = (int)fcgNUAspectRatioX->Value * ((fcgCXAspectRatio->SelectedIndex != 1) ? 1 : -1);
	cnf->x264.sar.y                = (int)fcgNUAspectRatioY->Value * ((fcgCXAspectRatio->SelectedIndex != 1) ? 1 : -1);
	cnf->x264.threads              = (int)fcgNUThreads->Value;
	cnf->x264.lookahead_threads    = (int)fcgNULookaheadThreads->Value;
	cnf->x264.sliced_threading     = fcgCBSlicedThreads->Checked;
	cnf->x264.log_mode             = fcgCXLogLevel->SelectedIndex;
	cnf->x264.psnr                 = fcgCBPSNR->Checked;
	cnf->x264.ssim                 = fcgCBSSIM->Checked;

	cnf->x264.ip_ratio             = (float)((int)fcgNUIPRatio->Value + 100) / 100.0f;
	cnf->x264.pb_ratio             = (float)((int)fcgNUPBRatio->Value + 100) / 100.0f;
	cnf->x264.qp_compress          = (float)((int)fcgNUQcomp->Value / 100.0f);
	cnf->x264.qp_min               = (int)fcgNUQpmin->Value;
	cnf->x264.qp_max               = (int)fcgNUQpmax->Value;
	cnf->x264.qp_step              = (int)fcgNUQpstep->Value;
	cnf->x264.chroma_qp_offset     = (int)fcgNUChromaQp->Value;
	cnf->x264.aq_mode              = fcgCXAQMode->SelectedIndex;
	cnf->x264.aq_strength          = (float)fcgNUAQStrength->Value;
	cnf->x264.psy_rd.x             = (float)fcgNUPsyRDO->Value;
	cnf->x264.psy_rd.y             = (float)fcgNUPsyTrellis->Value;
	cnf->x264.vbv_maxrate          = (int)fcgNUVBVmax->Value;
	cnf->x264.vbv_bufsize          = (int)fcgNUVBVbuf->Value;
	cnf->x264.mbtree               = fcgCBMBTree->Checked;
	cnf->x264.rc_lookahead         = (int)fcgNURCLookahead->Value;

	cnf->x264.scenecut             = (int)fcgNUScenecut->Value;
	cnf->x264.keyint_min           = (int)fcgNUMinKeyint->Value;
	cnf->x264.keyint_max           = (int)fcgNUKeyint->Value;
	cnf->x264.open_gop             = fcgCBOpenGOP->Checked;
	cnf->x264.use_deblock          = fcgCBDeblock->Checked;
	cnf->x264.deblock.x            = (int)fcgNUDeblockStrength->Value;
	cnf->x264.deblock.y            = (int)fcgNUDeblockThreshold->Value;
	cnf->x264.cabac                = fcgCBCABAC->Checked;
	cnf->x264.slice_n              = (int)fcgNUSlices->Value;
	cnf->x264.weight_p             = fcgCXWeightP->SelectedIndex;
	cnf->x264.interlaced           = fcgCXInterlaced->SelectedIndex != 0;
	cnf->x264.tff                  = fcgCXInterlaced->SelectedIndex != 2;
	cnf->x264.bframes              = (int)fcgNUBframes->Value;
	cnf->x264.b_adapt              = fcgCXBAdpapt->SelectedIndex;
	cnf->x264.b_bias               = (int)fcgNUBBias->Value;
	cnf->x264.b_pyramid            = fcgCXBpyramid->SelectedIndex;
	cnf->x264.weight_b             = fcgCBWeightB->Checked;

	cnf->x264.dct8x8               = fcgCB8x8dct->Checked;
	cnf->x264.mb_partition         = MB_PARTITION_NONE;
	cnf->x264.mb_partition        |= (fcgCBb8x8->Checked) ? MB_PARTITION_B8x8 : MB_PARTITION_NONE;
	cnf->x264.mb_partition        |= (fcgCBp8x8->Checked) ? MB_PARTITION_P8x8 : MB_PARTITION_NONE;
	cnf->x264.mb_partition        |= (fcgCBp4x4->Checked) ? MB_PARTITION_P4x4 : MB_PARTITION_NONE;
	cnf->x264.mb_partition        |= (fcgCBi8x8->Checked) ? MB_PARTITION_I8x8 : MB_PARTITION_NONE;
	cnf->x264.mb_partition        |= (fcgCBi4x4->Checked) ? MB_PARTITION_I4x4 : MB_PARTITION_NONE;

	cnf->x264.no_fast_pskip        = !fcgCBfastpskip->Checked;
	cnf->x264.no_dct_decimate      = !fcgCBDctDecimate->Checked;
	cnf->x264.trellis              = fcgCXTrellis->SelectedIndex;
	cnf->x264.cqm                  = GetCQMIndex(cnf->vid.cqmfile, sizeof(cnf->vid.cqmfile));

	cnf->x264.me                   = fcgCXME->SelectedIndex;
	cnf->x264.subme                = fcgCXSubME->SelectedIndex;
	cnf->x264.me_range             = (int)fcgNUMERange->Value;
	cnf->x264.chroma_me            = fcgCBChromaME->Checked;
	cnf->x264.direct_mv            = fcgCXDirectME->SelectedIndex;
	cnf->x264.ref_frames           = (int)fcgNURef->Value;
	cnf->x264.mixed_ref            = fcgCBMixedRef->Checked;

	cnf->x264.use_tcfilein         = fcgCBTCIN->Checked;
	cnf->x264.use_timebase         = fcgCBTimeBase->Checked;
	cnf->x264.timebase.x           = (int)fcgNUTimebaseNum->Value;
	cnf->x264.timebase.y           = (int)fcgNUTimebaseDen->Value;

	GetCHARfromString(cnf->vid.stats,     sizeof(cnf->vid.stats),     fcgTXStatusFile->Text);
	GetCHARfromString(cnf->vid.tcfile_in, sizeof(cnf->vid.tcfile_in), fcgTXTCIN->Text);

	//g
	cnf->vid.afs                    = fcgCBAFS->Checked;
	cnf->vid.afs_bitrate_correction = fcgCBAFSBitrateCorrection->Checked;
	cnf->vid.auo_tcfile_out         = fcgCBAuoTcfileout->Checked;
	cnf->vid.check_keyframe         = CHECK_KEYFRAME_NONE;
	cnf->vid.check_keyframe        |= (fcgCBCheckKeyframes->Checked)       ? CHECK_KEYFRAME_AVIUTL  : CHECK_KEYFRAME_NONE;
	cnf->vid.check_keyframe        |= (fcgCBSetKeyframeAtChapter->Checked) ? CHECK_KEYFRAME_CHAPTER : CHECK_KEYFRAME_NONE;
	cnf->vid.priority               = fcgCXX264Priority->SelectedIndex;
	cnf->vid.input_as_lw48          = fcgCBInputAsLW48->Checked;
	cnf->oth.temp_dir               = fcgCXTempDir->SelectedIndex;
	GetCHARfromString(cnf->vid.cmdex, sizeof(cnf->vid.cmdex), fcgTXCmdEx->Text);

	//
	cnf->aud.encoder                = fcgCXAudioEncoder->SelectedIndex;
	cnf->oth.out_audio_only         = fcgCBAudioOnly->Checked;
	cnf->aud.faw_check              = fcgCBFAWCheck->Checked;
	cnf->aud.enc_mode               = fcgCXAudioEncMode->SelectedIndex;
	cnf->aud.bitrate                = (int)fcgNUAudioBitrate->Value;
	cnf->aud.use_2pass              = fcgCBAudio2pass->Checked;
	cnf->aud.use_wav                = !fcgCBAudioUsePipe->Checked;
	cnf->aud.priority               = fcgCXAudioPriority->SelectedIndex;
	cnf->aud.audio_encode_timing    = fcgCXAudioEncTiming->SelectedIndex;
	cnf->aud.aud_temp_dir           = fcgCXAudioTempDir->SelectedIndex;

	//mux
	cnf->mux.disable_mp4ext         = !fcgCBMP4MuxerExt->Checked;
	cnf->mux.apple_mode             = fcgCBMP4MuxApple->Checked;
	cnf->mux.mp4_mode               = fcgCXMP4CmdEx->SelectedIndex;
	cnf->mux.mp4_temp_dir           = fcgCXMP4BoxTempDir->SelectedIndex;
	cnf->mux.disable_mkvext         = !fcgCBMKVMuxerExt->Checked;
	cnf->mux.mkv_mode               = fcgCXMKVCmdEx->SelectedIndex;
	cnf->mux.disable_mpgext         = !fcgCBMPGMuxerExt->Checked;
	cnf->mux.mpg_mode               = fcgCXMPGCmdEx->SelectedIndex;
	cnf->mux.priority               = fcgCXMuxPriority->SelectedIndex;

	cnf->oth.run_bat                = RUN_BAT_NONE;
	cnf->oth.run_bat               |= (fcgCBRunBatBefore->Checked) ? RUN_BAT_BEFORE : NULL;
	cnf->oth.run_bat               |= (fcgCBRunBatAfter->Checked) ? RUN_BAT_AFTER : NULL;
	cnf->oth.dont_wait_bat_fin      = RUN_BAT_NONE;
	cnf->oth.dont_wait_bat_fin     |= (!fcgCBWaitForBatBefore->Checked) ? RUN_BAT_BEFORE : NULL;
	cnf->oth.dont_wait_bat_fin     |= (!fcgCBWaitForBatAfter->Checked) ? RUN_BAT_AFTER : NULL;
	GetCHARfromString(cnf->oth.batfile_before, sizeof(cnf->oth.batfile_before), fcgTXBatBeforePath->Text);
	GetCHARfromString(cnf->oth.batfile_after,  sizeof(cnf->oth.batfile_after),  fcgTXBatAfterPath->Text);

	GetfcgTSLSettingsNotes(cnf->oth.notes, sizeof(cnf->oth.notes));

	//cli mode
	cnf->oth.disable_guicmd         = fcgTSBCMDOnly->Checked;
	if (cnf->oth.disable_guicmd)
		cnf->x264.nul_out           = fcgCBNulOutCLI->Checked;

	//ƂēKp
	set_profile_to_conf(&cnf->x264, cnf->x264.profile);
}

System::Void frmConfig::GetfcgTSLSettingsNotes(char *notes, int nSize) {
	ZeroMemory(notes, nSize);
	if (fcgTSLSettingsNotes->ForeColor == Color::FromArgb(StgNotesColor[0][0], StgNotesColor[0][1], StgNotesColor[0][2]))
		GetCHARfromString(notes, nSize, fcgTSLSettingsNotes->Text);
}

System::Void frmConfig::SetfcgTSLSettingsNotes(const char *notes) {
	if (str_has_char(notes)) {
		fcgTSLSettingsNotes->ForeColor = Color::FromArgb(StgNotesColor[0][0], StgNotesColor[0][1], StgNotesColor[0][2]);
		fcgTSLSettingsNotes->Text = String(notes).ToString();
	} else {
		fcgTSLSettingsNotes->ForeColor = Color::FromArgb(StgNotesColor[1][0], StgNotesColor[1][1], StgNotesColor[1][2]);
		fcgTSLSettingsNotes->Text = String(DefaultStgNotes).ToString();
	}
}

System::Void frmConfig::SetfcgTSLSettingsNotes(String^ notes) {
	if (notes->Length && String::Compare(notes, String(DefaultStgNotes).ToString()) != 0) {
		fcgTSLSettingsNotes->ForeColor = Color::FromArgb(StgNotesColor[0][0], StgNotesColor[0][1], StgNotesColor[0][2]);
		fcgTSLSettingsNotes->Text = notes;
	} else {
		fcgTSLSettingsNotes->ForeColor = Color::FromArgb(StgNotesColor[1][0], StgNotesColor[1][1], StgNotesColor[1][2]);
		fcgTSLSettingsNotes->Text = String(DefaultStgNotes).ToString();
	}
}

System::Void frmConfig::SetChangedEvent(Control^ control, System::EventHandler^ _event) {
	System::Type^ ControlType = control->GetType();
	if (ControlType == NumericUpDown::typeid)
		((NumericUpDown^)control)->ValueChanged += _event;
	else if (ControlType == ComboBox::typeid)
		((ComboBox^)control)->SelectedIndexChanged += _event;
	else if (ControlType == CheckBox::typeid)
		((CheckBox^)control)->CheckedChanged += _event;
	else if (ControlType == TextBox::typeid)
		((TextBox^)control)->TextChanged += _event;
}

System::Void frmConfig::SetToolStripEvents(ToolStrip^ TS, System::Windows::Forms::MouseEventHandler^ _event) {
	for (int i = 0; i < TS->Items->Count; i++) {
		ToolStripButton^ TSB = dynamic_cast<ToolStripButton^>(TS->Items[i]);
		if (TSB != nullptr) TSB->MouseDown += _event;
	}
}

System::Void frmConfig::SetAllCheckChangedEvents(Control ^top) {
	//ċAgpĂׂẴRg[tag𒲂ׁACxgZbg
	for (int i = 0; i < top->Controls->Count; i++) {
		System::Type^ type = top->Controls[i]->GetType();
		if (type == NumericUpDown::typeid)
			top->Controls[i]->Enter += gcnew System::EventHandler(this, &frmConfig::NUSelectAll);

		if (type == Label::typeid || type == Button::typeid)
			;
		else if (type == ToolStrip::typeid)
			SetToolStripEvents((ToolStrip^)(top->Controls[i]), gcnew System::Windows::Forms::MouseEventHandler(this, &frmConfig::fcgTSItem_MouseDown));
		else if (top->Controls[i]->Tag == nullptr)
			SetAllCheckChangedEvents(top->Controls[i]);
		else if (String::Equals(top->Controls[i]->Tag->ToString(), L"reCmd"))
			SetChangedEvent(top->Controls[i], gcnew System::EventHandler(this, &frmConfig::fcgRebuildCmd));
		else if (String::Equals(top->Controls[i]->Tag->ToString(), L"chValue"))
			SetChangedEvent(top->Controls[i], gcnew System::EventHandler(this, &frmConfig::CheckOtherChanges));
		else
			SetAllCheckChangedEvents(top->Controls[i]);
	}
}

System::Void frmConfig::SetHelpToolTipsColorMatrix(Control^ control, const char *type) {
	const X264_OPTION_STR *list = get_option_list(type);
	fcgTTX264->SetToolTip(control,      L"--" + String(type).ToString() + L"\n"
		+ L"auto ƂAviutl̐Fԁuvɍ킹\n"
		+ L"ȉ̂悤ɐݒ肵܂B\n"
		+ L"c𑜓x" + COLOR_MATRIX_THRESHOLD + L"ȏ c " + String(list[COLOR_MATRIX_HD].desc).ToString() + L"\n"
		+ L"c𑜓x" + COLOR_MATRIX_THRESHOLD + L" c " + String(list[COLOR_MATRIX_SD].desc).ToString() + L"\n"
		+ L"悭킩Ȃꍇ wȂ łB"
		);
}

System::Void frmConfig::SetHelpToolTips() {
	//x264{
	fcgTTX264->SetToolTip(fcgCBUsehighbit, L"" 
		+ L"--input-depth 16\n"
		+ L"\n"
		+ L"high bit-depthŃGR[hs܂B\n"
		+ L"x26410bitłȂǁAhigh bit deptĥ̂gpĂB\n"
		+ L"ʏ̃v[[ł͍ĐłȂƂ邽߁A\n"
		+ L"high bit depthGR[hȂɂ𗝉Ăꍇɂ̂݁A\n"
		+ L"gpĂB\n"
		+ L"\n"
		+ L"8bitpx264.exehigh bit depthpx264.exe͕ʁXɐݒłA\n"
		+ L"̃`FbN{bNXɂĐ؂ւ܂B"
		);
	fcgTTX264->SetToolTip(fcgBTX264Path, L""
		+ L"x264.exȅꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTX264->SetToolTip(fcgBTX264PathSub, L""
		+ L"x264.exȅꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTX264->SetToolTip(fcgBTX264PathSubhighbit, L""
		+ L"x264.exe(high bit depthp)̏ꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTX264->SetToolTip(fcgCXX264Mode, L""
		+ L"yVOpXz\n"
		+ L"   " + String(x264_encodemode_desc[2]).ToString()->Replace(L"VOpX - ", L"") + L"\t c --crf\n"
		+ L"   " + String(x264_encodemode_desc[1]).ToString()->Replace(L"VOpX - ", L"") + L"\t\t c --qp\n"
		+ L"   " + String(x264_encodemode_desc[0]).ToString()->Replace(L"VOpX - ", L"") + L"\t c --bitrate\n"
		+ L"\n"
		+ L"y}`pXz\n"
		+ L"   " + String(x264_encodemode_desc[3]).ToString()->Replace(L"}`pX - ", L"") + L"\t c --pass 1 --bitrate\n"
		+ L"   " + String(x264_encodemode_desc[4]).ToString()->Replace(L"}`pX - ", L"") + L"\t c --pass 3 --bitrate\n"
		+ L"\n"
		+ L"y" + String(x264_encodemode_desc[5]).ToString() + L"z\n"
		+ L"    }`pXo(1pass  npass)ōs܂B\n"
		+ L"    --pass 1/3 --bitrate\n"
		+ L"\n"
		+ L"y" + String(x264_encodemode_desc[6]).ToString() + L"z\n"
		+ L"    iVBR (crf)ł̃GR[hAt@CTCYErbg[gmF܂B\n"
		+ L"    --crf"
		);
	fcgTTX264->SetToolTip(fcgCBNulOut,            L"-o nul");
	fcgTTX264->SetToolTip(fcgCBFastFirstPass,     L"--slow-firstpass (`FbNIt)");
	fcgTTX264->SetToolTip(fcgTXQuality,           L"--crf / --bitrate / --qp");
	fcgTTX264->SetToolTip(fcgTXStatusFile,        L"--stats");
	fcgTTX264->SetToolTip(fcgCXProfile,           L"--profile\n"
		+ L"\n"
		+ L"ŏIIɂ̐ݒɂ鐧񂪉ۂ܂B"
		);

	//}`pX ݒ
	String^ AMP_LimitBitrate = L""
		+ L"o͂铮t@C(f{)̃rbg[gA\n"
		+ L"Őݒ肵rbg[g𒴂Ȃ悤GR[hs܂B\n"
		+ L"\n"
		+ L"GR[hIɂmFsAt@Crbg[gݒ\n"
		+ L"Ă܂ꍇɂ́AăGR[hs܂B\n"
		+ L"\n"
		+ L"ݒ̓`FbN{bNXɂI/Itł܂B";
	fcgTTEx->SetToolTip(fcgCBAMPLimitBitrate,     AMP_LimitBitrate);
	fcgTTEx->SetToolTip(fcgNUAMPLimitBitrate,     AMP_LimitBitrate);
	String^ AMP_LimitFileSize = L""
		+ L"o͂铮t@C(f{)̃TCYA\n"
		+ L"Őݒ肵t@CTCY𒴂Ȃ悤GR[hs܂B\n"
		+ L"\n"
		+ L"GR[hIɂmFsAt@CTCYݒ\n"
		+ L"Ă܂ꍇɂ́AăGR[hs܂B\n"
		+ L"\n"
		+ L"ݒ̓`FbN{bNXɂI/Itł܂B";
	fcgTTEx->SetToolTip(fcgCBAMPLimitFileSize,     AMP_LimitFileSize);
	fcgTTEx->SetToolTip(fcgNUAMPLimitFileSize,     AMP_LimitFileSize);

	//vt@CƂ
	fcgTTX264->SetToolTip(fcgCXTune,              L"--tune");
	fcgTTX264->SetToolTip(fcgCXPreset,            L"--preset");
	fcgTTEx->SetToolTip(fcgBTApplyPreset,         L""
		+ L"{bNXŎw肵\n"
		+ L"\n"
		+ L"Ex (Preset)\n"
		+ L"E`[jO (tune)\n"
		+ L"Evt@C (Profile)\n"
		+ L"\n"
		+ L"GUIɓKp܂B"
		);

	//óEtH[}bg
	fcgTTX264->SetToolTip(fcgCXLevel,            L"--level");
	fcgTTX264->SetToolTip(fcgCXVideoFormat,      L"--videoformat");
	fcgTTX264->SetToolTip(fcgCBAud,              L"--aud");
	fcgTTX264->SetToolTip(fcgCBPicStruct,        L"--pic-struct");
	fcgTTX264->SetToolTip(fcgCXNalHrd,           L"--nal-hrd\n"
		+ L" vbr  rfIobt@(VBV)̐ݒsKv܂B"
		);
	fcgTTX264->SetToolTip(fcgCBBlurayCompat,     L"--bluray-compat");
	fcgTTX264->SetToolTip(fcgCXOutputCsp,        L"--output-csp\n"
		+ L"ʏ i420 gp܂B"
		);

	//F
	SetHelpToolTipsColorMatrix(fcgCXColorMatrix, "colormatrix");
	SetHelpToolTipsColorMatrix(fcgCXColorPrim,   "colorprim");
	SetHelpToolTipsColorMatrix(fcgCXTransfer,    "transfer");
	fcgTTX264->SetToolTip(fcgCXInputRange,      L"--input-range\n"
		+ L"\n"
		+ L"\"" + String(list_input_range[0].desc).ToString() + L"\"  [ftHg]\n"
		+ L"  output-csp yuvn c tvF (kW)\n"
		+ L"  output-csp rgbn c pcF\n"
		+ L"\n"
		+ L"\"" + String(list_input_range[1].desc).ToString() + L"\"\n"
		+ L"  pcF (tW)"
		);

	fcgTTX264->SetToolTip(fcgCXAspectRatio,      L""
		+ String(aspect_desc[0]).ToString() + L"\n"
		+ L"   --sar 𒼐ڎw肵܂B\n"
		+ L"\n"
		+ String(aspect_desc[1]).ToString() + L"\n"
		+ L"   GR[h 𑜓x --sarvZ܂B"
		);
	fcgTTX264->SetToolTip(fcgNUAspectRatioX,     L"AXyNg  ()");
	fcgTTX264->SetToolTip(fcgNUAspectRatioY,     L"AXyNg c ()");
	fcgTTX264->SetToolTip(fcgNUThreads,          L"--threads\n"
		+ L"\"0\" ŎłB"
		);
	fcgTTX264->SetToolTip(fcgNULookaheadThreads, L"--lookahead-threads\n"
		+ L"\"0\" ŎłB"
		);
	fcgTTX264->SetToolTip(fcgCBSlicedThreads,    L"--sliced-threads");
	fcgTTX264->SetToolTip(fcgCXLogLevel,         L"--log-level");
	fcgTTX264->SetToolTip(fcgCBPSNR,             L"--psnr");
	fcgTTX264->SetToolTip(fcgCBSSIM,             L"--ssim");

	//ʎq
	fcgTTX264->SetToolTip(fcgNUIPRatio,          L"--ipratio 1.00 + (ݒl)%");
	fcgTTX264->SetToolTip(fcgNUPBRatio,          L"--pbratio 1.00 + (ݒl)%");
	fcgTTX264->SetToolTip(fcgNUQcomp,            L"--qcomp (ݒl)%");
	fcgTTX264->SetToolTip(fcgNUQpmin,            L"--qpmin");
	fcgTTX264->SetToolTip(fcgNUQpmax,            L"--qpmax");
	fcgTTX264->SetToolTip(fcgNUQpstep,           L"--qpstep");
	fcgTTX264->SetToolTip(fcgNUChromaQp,         L"--chroma-qp-offset");

	//AQ
	fcgTTX264->SetToolTip(fcgCXAQMode,           L"--aq-mode");
	fcgTTX264->SetToolTip(fcgNUAQStrength,       L"--aq-strength");

	//PsyRD
	fcgTTX264->SetToolTip(fcgNUPsyRDO,           L"--psy-rd <RDO>:<trellis>");
	fcgTTX264->SetToolTip(fcgNUPsyTrellis,       L"--psy-rd <RDO>:<trellis>");
	fcgTTX264->SetToolTip(fcgCBMBTree,           L""
		+ L"--mbtree\n"
		+ L"`FbNIt --no-mbtree"
		);
	fcgTTX264->SetToolTip(fcgNURCLookahead,      L"--rc-lookahead");
	fcgTTX264->SetToolTip(fcgNUVBVmax,           L""
		+ L"--vbv-maxrate\n"
		+ L"\"-1\" ƂƃGR[hɎŐݒ肵܂B"
		);
	fcgTTX264->SetToolTip(fcgNUVBVbuf,           L""
		+ L"--vbv-bufsize\n"
		+ L"\"-1\" ƂƃGR[hɎŐݒ肵܂B"
		);
	fcgTTX264->SetToolTip(fcgNUScenecut,         L"--scenecut");
	fcgTTX264->SetToolTip(fcgNUKeyint,           L""
		+ L"--keyint\n"
		+ L"\"0\"  inifinite() w肵܂B\n"
		+ L"\"-1\" GRɎIfps~10ݒ肵܂B");
	fcgTTX264->SetToolTip(fcgNUMinKeyint,        L""
		 + L"--min-keyint\n"
		 + L"\"0\"  ƂȂ܂B"
		 );
	fcgTTX264->SetToolTip(fcgCBOpenGOP,          L"--open-gop");
	fcgTTX264->SetToolTip(fcgCBCABAC,            L""
		+ L"--cabac\n"
		+ L"`FbNIt --no-cabac");
	fcgTTX264->SetToolTip(fcgNUSlices,           L"--slices");
	fcgTTX264->SetToolTip(fcgCXWeightP,          L"--weightp");

	//C^
	String^ InterlacedEncodingToolTip = L"   C^[[XێGR[hs܂B";
	fcgTTX264->SetToolTip(fcgCXInterlaced,       L""
		+ L"[" + String(interlaced_desc[0]).ToString() + L"]\n"
		+ L"   vObVu(C^)ƂăGR[h܂B\n"
		+ L"\n"
		+ L"[" + String(interlaced_desc[1]).ToString() + L"] c --tff\n"
		+ L"   TFF(gbvtB[h -> {gtB[h) \n" + InterlacedEncodingToolTip + L"\n"
		+ L"\n"
		+ L"[" + String(interlaced_desc[2]).ToString() + L"] c --bff\n"
		+ L"   BFF({gtB[h -> gbvtB[h) \n" + InterlacedEncodingToolTip
		);

	fcgTTX264->SetToolTip(fcgCBDeblock,          L"--deblock <Strength>:<Threshold>\n"
		+ L"`FbNIt --no-deblock"
		);
	fcgTTX264->SetToolTip(fcgNUDeblockStrength,  L"--deblock <Strength>:<Threshold>"
		);
	fcgTTX264->SetToolTip(fcgNUDeblockThreshold, L"--deblock <Strength>:<Threshold>"
		);

	//Bt[
	fcgTTX264->SetToolTip(fcgNUBframes,          L"--bframes");
	fcgTTX264->SetToolTip(fcgCXBAdpapt,          L"--b-adapt");
	fcgTTX264->SetToolTip(fcgNUBBias,            L"--b-bias");
	fcgTTX264->SetToolTip(fcgCXBpyramid,         L"--b-pyramid");
	fcgTTX264->SetToolTip(fcgCBWeightB,          L"--weightb");

	//}NubN^Cv
	fcgTTX264->SetToolTip(fcgCB8x8dct,           L"--8x8dct");
	fcgTTX264->SetToolTip(fcgCBp8x8,             L"--partitions p8x8");
	fcgTTX264->SetToolTip(fcgCBb8x8,             L"--partitions b8x8");
	fcgTTX264->SetToolTip(fcgCBp4x4,             L"--partitions p4x4");
	fcgTTX264->SetToolTip(fcgCBi8x8,             L"--partitions i8x8");
	fcgTTX264->SetToolTip(fcgCBi4x4,             L"--partitions i4x4");

	//̑
	fcgTTX264->SetToolTip(fcgCBfastpskip,        L"`FbNIt --no-fast-pskip");
	fcgTTX264->SetToolTip(fcgCBDctDecimate,      L"`FbNIt --no-dct-decimate");
	fcgTTX264->SetToolTip(fcgCXTrellis,          L"--trellis");
	fcgTTX264->SetToolTip(fcgTXCQM,              L"--cqm / --cqmfile");
	fcgTTX264->SetToolTip(fcgBTMatrix,           L"--cqm / --cqmfile");

	//\
	fcgTTX264->SetToolTip(fcgCXME,               L"--me");
	fcgTTX264->SetToolTip(fcgCXSubME,            L"--subme");
	fcgTTX264->SetToolTip(fcgNUMERange,          L"--merange");
	fcgTTX264->SetToolTip(fcgCBChromaME,         L""
		+ L"--chroma-me\n"
		+ L"`FbNIt --no-chroma-me"
		);
	fcgTTX264->SetToolTip(fcgCXDirectME,         L"--direct");
	fcgTTX264->SetToolTip(fcgNURef,              L"--ref");
	fcgTTX264->SetToolTip(fcgCBMixedRef,         L"--mixed-ref");

	//
	String^ TCINToolTip = L""
		+ L"--tcfile-in\n"
		+ L"x264guiExɂ --fps̎tɂȂA\n"
		+ L"͂^CR[ht@CɊÂăt[x肳܂B\n"
		+ L"\n"
		+ L"--tcfile-in w莞͓ɎԐxw肷\n"
		+ L"(--timebasegp)Ƃ߂܂B";
	fcgTTX264->SetToolTip(fcgCBTCIN,             TCINToolTip);
	fcgTTX264->SetToolTip(fcgTXTCIN,             TCINToolTip);
	fcgTTX264->SetToolTip(fcgCBTimeBase,         L"--timebase");
	fcgTTX264->SetToolTip(fcgNUTimebaseDen,      L"--timebase");
	fcgTTX264->SetToolTip(fcgNUTimebaseNum,      L"--timebase");

	//g
	fcgTTEx->SetToolTip(fcgCBAFS,                L""
		+ L"tB[hVtg(afs)gpVFRs܂B\n"
		+ L"GR[hɃ^CR[h쐬Amuxɖߍ\n"
		+ L"t[[gύX܂B\n"
		+ L"\n"
		+ L"Omuxer̎gpK{ƂȂAmp4o͎\n"
		+ L"mp4boxƂƂtc2mp4modKvɂȂ܂̂ŁA\n"
		+ L"YꂸɎw肵ĂB\n"
		+ L"\n"
		+ L"܂AƂt[[gύX邽߁A\n"
		+ L"x264VBVݒ肪mɔfȂȂ_ɒӂĂB"
		);
	fcgTTEx->SetToolTip(fcgCBAFSBitrateCorrection, L""
		+ L"tB[hVtg(afs)gpɂmux̃t[[gύXɂ\n"
		+ L"[gw肵rbg[g炸Ă܂܂B\n"
		+ L"\n"
		+ L"ŁA1passڂdropvZ\n"
		+ L"rbg[gwl̕␳s܂B\n"
		+ L"ɂŏIIȎ[gݒʂ̓쐬ł܂B"
		);
	fcgTTEx->SetToolTip(fcgCBAuoTcfileout, L""
		+ L"^CR[ho͂܂B̃^CR[h\n"
		+ L"tB[hVtg(afs)𔽉f̂ɂȂ܂B"
		);
	fcgTTEx->SetToolTip(fcgCBCheckKeyframes, L""
		+ L"Aviutl̃L[t[ݒx264ɓ`邽߁A\n"
		+ L"L[t[os܂B\n"
		+ L"\n"
		+ L"L[t[óAtB[hVtgƓɎgpł܂B\n"
		+ L"tB[hVtggp͖ƂȂ܂B"
		);
	fcgTTEx->SetToolTip(fcgCBSetKeyframeAtChapter, L""
		+ L"`v^[̈ʒuɃL[t[ݒ肵܂B\n"
		+ L"\n"
		+ L"L[t[óAtB[hVtgƓɎgpł܂B\n"
		+ L"tB[hVtggp͖ƂȂ܂B"
		);
	fcgTTEx->SetToolTip(fcgCBInputAsLW48, L""
		+ L"L-SMASH WorksLW48@\gp܂B\n"
		+ L"lwinput.auilwcolor.aucƑgݍ킹Ďgp܂B\n"
		+ L"`FbN邱ƂŁAʏYC48ł͂ȂA\n"
		+ L"LW48Ƃď悤ɂȂ܂B"
		);
	fcgTTEx->SetToolTip(fcgCXTempDir,      L""
		+ L"ꎞt@CQ\n"
		+ L"Eꎞt@C(wav / GR[h㉹)\n"
		+ L"Eꎞt@C\n"
		+ L"E^CR[ht@C\n"
		+ L"Eqpt@C\n"
		+ L"Emuxt@C\n"
		+ L"̍쐬ꏊw肵܂B"
		);
	fcgTTEx->SetToolTip(fcgBTCustomTempDir, L""
		+ L"ꎞt@C̏ꏊuJX^vɐݒ肵ۂ\n"
		+ L"gpꎞt@C̏ꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTEx->SetToolTip(fcgBTCmdEx,       L""
		+ L"͂R}h(IvV)GUIɔf܂B"
		);

	//
	fcgTTEx->SetToolTip(fcgCXAudioEncoder, L""
		+ L"gp鉹GR[_w肵܂B\n"
		+ L"̐ݒx264guiEx.iniɋLqĂ܂B"
		);
	fcgTTEx->SetToolTip(fcgCBAudioOnly,    L""
		+ L"̏o͂s킸AGR[ĥݍs܂B\n"
		+ L"GR[hɎsꍇȂǂɎgpĂB"
		);
	fcgTTEx->SetToolTip(fcgCBFAWCheck,     L""
		+ L"GR[hɉFakeAACWav(FAW)ǂ̔sA\n"
		+ L"FAWƔ肳ꂽꍇAݒ𖳎āA\n"
		+ L"IFAWgp悤؂ւ܂B\n"
		+ L"\n"
		+ L"xGR[_FAW(fawcl)IA\n"
		+ L"st@C̏ꏊw肵ĂKv܂B"
		);
	fcgTTEx->SetToolTip(fcgBTAudioEncoderPath, L""
		+ L"GR[_̏ꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTEx->SetToolTip(fcgCXAudioEncMode, L""
		+ L"GR[_̃GR[h[h؂ւ܂B\n"
		+ L"̐ݒx264guiEx.iniɋLqĂ܂B"
		);
	fcgTTEx->SetToolTip(fcgCBAudio2pass,   L""
		+ L"GR[h2passōs܂B\n"
		+ L"2pass̓pCv͍s܂B"
		);
	fcgTTEx->SetToolTip(fcgCBAudioUsePipe, L""
		+ L"pCvʂāAf[^GR[_ɓn܂B\n"
		+ L"pCv2pass͓Ɏwł܂B"
		);
	fcgTTEx->SetToolTip(fcgNUAudioBitrate, L""
		+ L"rbg[gw肵܂B"
		);
	fcgTTEx->SetToolTip(fcgCXAudioPriority, L""
		+ L"GR[_CPUDxݒ肵܂B\n"
		+ L"AviutlSync  Aviutl̗DxƓɂȂ܂B"
		);
	fcgTTEx->SetToolTip(fcgCXAudioEncTiming, L""
		+ L"^C~Oݒ肵܂B\n"
		+ L" @ c f̏ŏ܂B\n"
		+ L" O@ c f̏ŏ܂B\n"
		+ L"  c fƉ𓯎ɏ܂B"
		);
	fcgTTEx->SetToolTip(fcgCXAudioTempDir, L""
		+ L"ꎞt@C(GR[h̃t@C)\n"
		+ L"̏o͐ύX܂B"
		);
	fcgTTEx->SetToolTip(fcgBTCustomAudioTempDir, L""
		+ L"ꎞt@C̏ꏊuJX^vɂ\n"
		+ L"gp鉹ꎞt@C̏ꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);

	//muxer
	fcgTTEx->SetToolTip(fcgCBMP4MuxerExt, L""
		+ L"w肵muxermuxs܂B\n"
		+ L"`FbNOmuxs܂B"
		);
	fcgTTEx->SetToolTip(fcgCXMP4CmdEx,    L""
		+ L"muxerɓnǉIvVI܂B\n"
		+ L"̐ݒx264guiEx.iniɋLqĂ܂B"
		);
	fcgTTEx->SetToolTip(fcgBTMP4MuxerPath, L""
		+ L"mp4pmuxeȑꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTEx->SetToolTip(fcgBTTC2MP4Path, L""
		+ L"tc2mp4mod̏ꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTEx->SetToolTip(fcgBTMP4RawPath, L""
		+ L"rawpmp4muxeȑꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTEx->SetToolTip(fcgCXMP4BoxTempDir, L""
		+ L"mp4boxp̈ꎞtH_̏ꏊw肵܂B"
		);
	fcgTTEx->SetToolTip(fcgBTMP4BoxTempDir, L""
		+ L"mp4boxpꎞtH_̏ꏊuJX^vɐݒ肵ۂ\n"
		+ L"gpꎞtH_̏ꏊłB\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTEx->SetToolTip(fcgCBMKVMuxerExt, L""
		+ L"w肵muxermuxs܂B\n"
		+ L"`FbNOmuxs܂B"
		);
	fcgTTEx->SetToolTip(fcgCXMKVCmdEx,    L""
		+ L"muxerɓnǉIvVI܂B\n"
		+ L"̐ݒx264guiEx.iniɋLqĂ܂B"
		);
	fcgTTEx->SetToolTip(fcgBTMKVMuxerPath, L""
		+ L"mkvpmuxeȑꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTEx->SetToolTip(fcgCBMPGMuxerExt, L""
		+ L"w肵muxermuxs܂B\n"
		+ L"`FbNOmuxs܂B"
		);
	fcgTTEx->SetToolTip(fcgCXMPGCmdEx,    L""
		+ L"muxerɓnǉIvVI܂B\n"
		+ L"̐ݒx264guiEx.iniɋLqĂ܂B"
		);
	fcgTTEx->SetToolTip(fcgBTMPGMuxerPath, L""
		+ L"mpgpmuxeȑꏊw肵܂B\n"
		+ L"\n"
		+ L"̐ݒx264guiEx.confɕۑA\n"
		+ L"ob`Ƃ̕ύX͂ł܂B"
		);
	fcgTTEx->SetToolTip(fcgCXMuxPriority, L""
		+ L"muxerCPUDxw肵܂B\n"
		+ L"AviutlSync  Aviutl̗DxƓɂȂ܂B"
		);
	//ob`t@Cs
	fcgTTEx->SetToolTip(fcgCBRunBatBefore, L""
		+ L"GR[hJnOɃob`t@Cs܂B"
		);
	fcgTTEx->SetToolTip(fcgCBRunBatAfter, L""
		+ L"GR[hIAob`t@Cs܂B"
		);
	fcgTTEx->SetToolTip(fcgCBWaitForBatBefore, L""
		+ L"ob`JnAob`I܂őҋ@܂B"
		);
	fcgTTEx->SetToolTip(fcgCBWaitForBatAfter, L""
		+ L"ob`JnAob`I܂őҋ@܂B"
		);
	fcgTTEx->SetToolTip(fcgBTBatBeforePath, L""
		+ L"GR[hIsob`t@Cw肵܂B\n"
		+ L"ۂ̃ob`sɂ͐V\"<ob`t@C>_tmp.bat\"쐬A\n"
		+ L"w肵ob`t@C̓eRs[A\n"
		+ L"ɓ蕶uĎs܂B\n"
		+ L"gpłureadmeB"
		);
	fcgTTEx->SetToolTip(fcgBTBatAfterPath, L""
		+ L"GR[hIsob`t@Cw肵܂B\n"
		+ L"ۂ̃ob`sɂ͐V\"<ob`t@C>_tmp.bat\"쐬A\n"
		+ L"w肵ob`t@C̓eRs[A\n"
		+ L"ɓ蕶uĎs܂B\n"
		+ L"gpłureadmeB"
		);
	//㕔c[Xgbv
	fcgTSBCMDOnly->ToolTipText = L""
		+ L"GUI[h  CLI[h؂ւ܂B\n"
		+ L"CLI[h̓R}hC݂͂̂\n"
		+ L"IvV̎ws܂B";

	fcgTSBDelete->ToolTipText = L""
		+ L"ݑI𒆂̃vt@C폜܂B";

	fcgTSBOtherSettings->ToolTipText = L""
		+ L"vt@C̕ۑtH_ύX܂B";

	fcgTSBSave->ToolTipText = L""
		+ L"݂̐ݒvt@Cɏ㏑ۑ܂B";

	fcgTSBSaveNew->ToolTipText = L""
		+ L"݂̐ݒVȃvt@Cɕۑ܂B";

	//
	fcgTTEx->SetToolTip(fcgTXCmd,         L""
		+ L"x264ɓn\̃R}hCłB\n"
		+ L"GR[hɂ͍X\n"
		+ L"EuǉR}hv̕t\n"
		+ L"E\"auto\"Ȑݒ荀ڂ̔f\n"
		+ L"EKvȏ̕t(--fps/-o/--input-res/--input-csp/--frames)\n"
		+ L"s܂B\n"
		+ L"\n"
		+ L"̃EBhE̓_uNbNŊgkł܂B"
		);
	fcgTTEx->SetToolTip(fcgBTDefault,     L""
		+ L"ftHgݒ[h܂B"
		);
}
System::Void frmConfig::SetX264VersionToolTip(String^ x264Path, bool ashighbit) {
	String^ mes;
	if (File::Exists(x264Path)) {
		char mes_buf[2560];
		char exe_path[MAX_PATH_LEN];
		GetCHARfromString(exe_path, sizeof(exe_path), x264Path);
		if (get_exe_message(exe_path, "--version", mes_buf, _countof(mes_buf), AUO_PIPE_MUXED) == RP_SUCCESS)
			mes = String(mes_buf).ToString();
		else
			mes = L"o[W̎擾Ɏs܂B";
	} else {
		mes = L"w肳ꂽx264݂܂B";
	}
	if (ashighbit == fcgCBUsehighbit->Checked)
		fcgTTX264Version->SetToolTip(fcgTXX264Path, mes);

	fcgTTX264Version->SetToolTip((ashighbit) ? fcgTXX264PathSubhighbit : fcgTXX264PathSub, mes);
}
System::Void frmConfig::ShowExehelp(String^ ExePath, String^ args) {
	if (!File::Exists(ExePath)) {
		MessageBox::Show(L"w肳ꂽst@C݂܂B", L"G[", MessageBoxButtons::OK, MessageBoxIcon::Error);
	} else {
		char exe_path[MAX_PATH_LEN];
		char file_path[MAX_PATH_LEN];
		char cmd[MAX_CMD_LEN];
		GetCHARfromString(exe_path, sizeof(exe_path), ExePath);
		apply_appendix(file_path, _countof(file_path), exe_path, "_fullhelp.txt");
		File::Delete(String(file_path).ToString());
		array<String^>^ arg_list = args->Split(L';');
		for (int i = 0; i < arg_list->Length; i++) {
			if (i) {
				StreamWriter^ sw;
				try {
					sw = gcnew StreamWriter(String(file_path).ToString(), true, System::Text::Encoding::GetEncoding("shift_jis"));
					sw->WriteLine();
					sw->WriteLine();
				} finally {
					if (sw != nullptr) { sw->Close(); }
				}
			}
			GetCHARfromString(cmd, sizeof(cmd), arg_list[i]);
			if (get_exe_message_to_file(exe_path, cmd, file_path, AUO_PIPE_MUXED, 5) != RP_SUCCESS) {
				File::Delete(String(file_path).ToString());
				MessageBox::Show(L"help̎擾Ɏs܂B", L"G[", MessageBoxButtons::OK, MessageBoxIcon::Error);
				return;
			}
		}
		try {
			System::Diagnostics::Process::Start(String(file_path).ToString());
		} catch (...) {
			MessageBox::Show(L"helpJۂɕsȃG[܂B", L"G[", MessageBoxButtons::OK, MessageBoxIcon::Error);
		}
	}
}

#pragma warning( pop )
