//  -----------------------------------------------------------------------------------------
//    g x264 o(GUI) Ex  v1.xx/2.xx by rigaya
//  -----------------------------------------------------------------------------------------
//   \[XR[hɂ
//   Eۏ؂łB
//   E{\[XR[hgpƂɂ邢Ȃ鑹QEguɂrigaya͐ӔC𕉂܂B
//   ȏɗĒꍇA{\[XR[h̎gpAAρAĔЕzsĒč\܂B
//  -----------------------------------------------------------------------------------------

#include <Windows.h>
#pragma comment(lib, "user32.lib") //WaitforInputIdle
#include <stdlib.h>
#include <stdio.h>
#include <float.h>
#include <Process.h>
#include <mmsystem.h>
#pragma comment(lib, "winmm.lib") 
#include <limits.h>
#include <shlwapi.h>
#pragma comment(lib, "shlwapi.lib")
#include <vector>
#include <set>

#include "output.h"
#include "vphelp_client.h"

#pragma warning( push )
#pragma warning( disable: 4127 )
#include "afs_client.h"
#pragma warning( pop )

#include "auo.h"
#include "auo_frm.h"
#include "auo_pipe.h"
#include "auo_error.h"
#include "auo_conf.h"
#include "auo_util.h"
#include "auo_convert.h"
#include "auo_system.h"
#include "auo_version.h"
#include "auo_chapter.h"

#include "auo_encode.h"
#include "auo_video.h"
#include "auo_audio_parallel.h"

const int DROP_FRAME_FLAG = INT_MAX;

static const char * specify_input_csp(int output_csp) {
	return specify_csp[output_csp];
}

int get_aviutl_color_format(int use_highbit, int output_csp, int input_as_lw48) {
	//Aviutl̓͂ɎgptH[}bg

	const int cf_aviutl_pixel48 = (input_as_lw48) ? CF_LW48 : CF_YC48;
	switch (output_csp) {
		case OUT_CSP_YUV444:
			return cf_aviutl_pixel48;
		case OUT_CSP_RGB:
			return CF_RGB;
		case OUT_CSP_NV12:
		case OUT_CSP_NV16:
		case OUT_CSP_YUY2:
		default:
			return (use_highbit) ? cf_aviutl_pixel48 : CF_YUY2;
	}
}

static int calc_input_frame_size(int width, int height, int color_format) {
	width = (color_format == CF_RGB) ? (width+3) & ~3 : (width+1) & ~1;
	return width * height * COLORFORMATS[color_format].size;
}

BOOL setup_afsvideo(const OUTPUT_INFO *oip, CONF_GUIEX *conf, PRM_ENC *pe, BOOL auto_afs_disable) {
	//łɏĂ ܂ KvȂ
	if (pe->afs_init || pe->video_out_type == VIDEO_OUTPUT_DISABLED || !conf->vid.afs)
		return TRUE;

	const int color_format = get_aviutl_color_format(conf->x264.use_highbit_depth, conf->x264.output_csp, conf->vid.input_as_lw48);
	const int frame_size = calc_input_frame_size(oip->w, oip->h, color_format);
	//Aviutl(tB[hVtg)̉f
	if (afs_vbuf_setup((OUTPUT_INFO *)oip, conf->vid.afs, frame_size, COLORFORMATS[color_format].FOURCC)) {
		pe->afs_init = TRUE;
		return TRUE;
	} else if (conf->vid.afs && auto_afs_disable) {
		afs_vbuf_release(); //x
		warning_auto_afs_disable();
		conf->vid.afs = FALSE;
		//ēxgpmuxer`FbN
		pe->muxer_to_be_used = check_muxer_to_be_used(conf, pe->video_out_type, (oip->flag & OUTPUT_INFO_FLAG_AUDIO) != 0);
		return TRUE;
	}
	//G[
	error_afs_setup(conf->vid.afs, auto_afs_disable);
	return FALSE;
}

void close_afsvideo(PRM_ENC *pe) {
	if (!pe->afs_init || pe->video_out_type == VIDEO_OUTPUT_DISABLED)
		return;

	afs_vbuf_release();

	pe->afs_init = FALSE;
}

static AUO_RESULT check_cmdex(CONF_GUIEX *conf, const OUTPUT_INFO *oip, PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	DWORD ret = AUO_RESULT_SUCCESS;
	const int color_format = get_aviutl_color_format(conf->x264.use_highbit_depth, conf->x264.output_csp, conf->vid.input_as_lw48); //݂̐F`ۑ
	if (conf->oth.disable_guicmd) 
		get_default_conf_x264(&conf->x264, FALSE); //CLI[h͂Ƃ肠AftHgĂł
	//cmdexKp
	set_cmd_to_conf(conf->vid.cmdex, &conf->x264);

	if (color_format != get_aviutl_color_format(conf->x264.use_highbit_depth, conf->x264.output_csp, conf->vid.input_as_lw48)) {
		//cmdexœ͐F`ύXɂȂꍇAď
		close_afsvideo(pe);
		if (!setup_afsvideo(oip, conf, pe, sys_dat->exstg->s_local.auto_afs_disable)) {
			ret |= AUO_RESULT_ERROR; //Aviutl(afs)̃t[ǂݍ݂Ɏs
		}
	}
	return ret;
}

static AUO_RESULT tcfile_out(int *jitter, int frame_n, double fps, BOOL afs, const PRM_ENC *pe) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	char auotcfile[MAX_PATH_LEN];
	FILE *tcfile = NULL;

	if (afs)
		fps *= 4; //afsȂ4{x
	const double tm_multi = 1000.0 / fps;

	//t@C쐬
	apply_appendix(auotcfile, _countof(auotcfile), pe->temp_filename, pe->append.tc);

	if (NULL != fopen_s(&tcfile, auotcfile, "wb")) {
		ret |= AUO_RESULT_ERROR; warning_auo_tcfile_failed();
	} else {
		fprintf(tcfile, "# timecode format v2\r\n");
		if (afs) {
			for (int i = 0; i < frame_n; i++)
				if (jitter[i] != DROP_FRAME_FLAG)
					fprintf(tcfile, "%.6lf\r\n", (i * 4 + jitter[i]) * tm_multi);
		} else {
			for (int i = 0; i < frame_n; i++)
				fprintf(tcfile, "%.6lf\r\n", i * tm_multi);
		}
		fclose(tcfile);
	}
	return ret;
}

static AUO_RESULT set_keyframe_from_aviutl(std::vector<int> *keyframe_list, const OUTPUT_INFO *oip) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	const int prev_chap_count = keyframe_list->size();
	const char * const MES_SEARCH_KEYFRAME = "Aviutl L[t[oc";
	DWORD tm = 0, tm_prev = 0;
	set_window_title(MES_SEARCH_KEYFRAME, PROGRESSBAR_CONTINUOUS);

	//o[v
	for (int i = 0; i < oip->n; i++) {
		//f
		if (oip->func_is_abort()) {
			ret |= AUO_RESULT_ABORT; write_log_auo_line(LOG_INFO, "Aviutl L[t[o𒆒f܂B");
			break;
		}
		//tOo
		if (oip->func_get_flag(i) & OUTPUT_INFO_FRAME_FLAG_KEYFRAME)
			keyframe_list->push_back(i);
		//i\ (24fpsȂǂĂƎԂ)
		if ((tm = timeGetTime()) - tm_prev > LOG_UPDATE_INTERVAL * 5) {
			set_log_progress(i / (double)oip->n);
			tm_prev = tm;
		}
	}
	set_window_title(MES_SEARCH_KEYFRAME, PROGRESSBAR_DISABLED);
	write_log_auo_line_fmt(LOG_INFO, "Aviutl %dӏ L[t[ݒo܂B", keyframe_list->size() - prev_chap_count);
	return ret;
}

static AUO_RESULT set_keyframe_from_chapter(std::vector<int> *keyframe_list, const CONF_GUIEX *conf, const OUTPUT_INFO *oip, const PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	//muxݒ肪Ȃ΃XLbv
	if (pe->muxer_to_be_used == MUXER_DISABLED) {
		//XLbv
		write_log_auo_line(LOG_INFO, "gpmuxerݒ肳ĂȂ߁A`v^[̃L[t[o͍s܂B");
	} else {
		//`v^[t@C쐬
		char chap_file[MAX_PATH_LEN] = { 0 };
		const MUXER_SETTINGS *mux_stg = &sys_dat->exstg->s_mux[(pe->muxer_to_be_used == MUXER_TC2MP4) ? MUXER_MP4 : pe->muxer_to_be_used];
		const MUXER_CMD_EX *muxer_mode = &mux_stg->ex_cmd[get_mux_excmd_mode(conf, pe)];
		strcpy_s(chap_file, _countof(chap_file), muxer_mode->chap_file);
		cmd_replace(chap_file, _countof(chap_file), pe, sys_dat, conf, oip);

		chapter_list_t chap_list = { 0 };
		if (!str_has_char(chap_file) || !PathFileExists(chap_file)) {
			write_log_auo_line(LOG_INFO, "`v^[t@C݂܂B");
		//`v^[Xg擾
		} else if (AUO_CHAP_ERR_NONE != get_chapter_list(&chap_list, chap_file, CODE_PAGE_UNSET)) {
			ret |= AUO_RESULT_ERROR; write_log_auo_line(LOG_WARNING, "`v^[t@C`v^[ݒǂݎ܂łB");
		//`v^[Ȃꍇ
		} else if (0 == chap_list.count) {
			write_log_auo_line(LOG_WARNING, "`v^[t@C`v^[ݒǂݎ܂łB");
		} else {
			const double fps = oip->rate / (double)oip->scale;
			//QPt@Co
			for (int i_chap = 0; i_chap < chap_list.count; i_chap++) {
				double chap_time_s = get_chap_second(&chap_list.data[i_chap]);
				int i_frame = (int)(chap_time_s * fps + 0.5);
				keyframe_list->push_back(i_frame);
			}
			write_log_auo_line_fmt(LOG_INFO, "`v^[t@C %dӏ L[t[ݒs܂B", chap_list.count);
		}
		free_chapter_list(&chap_list);
	}
	return ret;
}

//tB[hVtgAołȂł͐ݒłȂƂ
static AUO_RESULT adjust_keyframe_as_afs_24fps(std::vector<int> *keyframe_list, const std::set<int> *keyframe_set, const OUTPUT_INFO *oip) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
#if 0 //fobOp
	{
		const char * const MES_AFS_DEBUG = "Aviutl afsoc";
		set_window_title(MES_AFS_DEBUG, PROGRESSBAR_CONTINUOUS);
		DWORD tm = 0, tm_prev = 0;
		char afs_csv_file[MAX_PATH_LEN] = { 0 };
		strcpy_s(afs_csv_file, _countof(afs_csv_file), oip->savefile);
		change_ext(afs_csv_file, _countof(afs_csv_file), "x264guiEx_afs_log.csv");
		FILE *fp_log = NULL;
		if (fopen_s(&fp_log, afs_csv_file, "wb") || fp_log == NULL) {
			write_log_auo_line(LOG_WARNING, "x264guiEx_afsOt@CJ܂łB");
		} else {
			int drop = FALSE, next_jitter = 0;
			for (int i = 0; i < oip->n; i++) {
				afs_get_video((OUTPUT_INFO *)oip, i, &drop, &next_jitter);
				fprintf(fp_log, "%d\r\n%d,%d,", drop, next_jitter, 4*(i+1) + next_jitter);
				//i\ (24fpsȂǂĂƎԂ)
				if ((tm = timeGetTime()) - tm_prev > LOG_UPDATE_INTERVAL * 5) {
					set_log_progress(i / (double)oip->n);
					log_process_events();
					tm_prev = tm;
				}
			}
			fclose(fp_log);
		}
		set_window_title(MES_AFS_DEBUG, PROGRESSBAR_DISABLED);
	}
#endif
	//24fps肵Đݒ肵
	keyframe_list->clear();
	const char * const MES_CHAPTER_AFS_ADJUST = "`v^[ ␳vZ(afs 24fps)...";
	set_window_title(MES_CHAPTER_AFS_ADJUST, PROGRESSBAR_CONTINUOUS);

	int last_chapter = 0;
	const_foreach(std::set<int>, it_keyframe, keyframe_set) {
		DWORD tm = 0, tm_prev = 0;
		const int check_start = (std::max)(0, ((*it_keyframe - 300) / 5) * 5);
		int drop_count = 0;
		for (int i_frame = check_start, drop = FALSE, next_jitter = 0; i_frame < (std::min)(*it_keyframe, oip->n); i_frame++) {
			afs_get_video((OUTPUT_INFO *)oip, i_frame, &drop, &next_jitter);
			drop_count += !!drop;
			//f
			if (oip->func_is_abort()) {
				ret |= AUO_RESULT_ABORT; write_log_auo_line(LOG_INFO, "Aviutl L[t[o𒆒f܂B");
				break;
			}
			//i\
			if ((tm = timeGetTime()) - tm_prev > LOG_UPDATE_INTERVAL * 5) {
				double progress_current_chapter = (i_frame - check_start) / (double)(*it_keyframe - check_start);
				set_log_progress((last_chapter + progress_current_chapter * (*it_keyframe - last_chapter)) / (double)oip->n);
				log_process_events();
				tm_prev = tm;
			}
		}
		last_chapter = *it_keyframe;

		keyframe_list->push_back(4*check_start/5 + (*it_keyframe - check_start) - drop_count);
	}
	set_window_title(MES_CHAPTER_AFS_ADJUST, PROGRESSBAR_DISABLED);
	write_log_auo_line(LOG_INFO, "`v^[ ␳vZ(afs 24fps)܂B");
	return ret;
}

static AUO_RESULT set_keyframe(const CONF_GUIEX *conf, const OUTPUT_INFO *oip, const PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	std::vector<int> keyframe_list;

	//tB[hVtgȂXLbv
	BOOL disable_keyframe_afs = conf->vid.afs && !sys_dat->exstg->s_local.set_keyframe_as_afs_24fps;
	if (disable_keyframe_afs)
		return ret;

	//t@C쐬
	char auoqpfile[MAX_PATH_LEN] = { 0 };
	apply_appendix(auoqpfile, _countof(auoqpfile), pe->temp_filename, pe->append.qp);
	if (PathFileExists(auoqpfile))
		remove(auoqpfile);

	//Aviutl̃L[t[oL[t[ݒ
	if (!ret && conf->vid.check_keyframe & CHECK_KEYFRAME_AVIUTL)
		ret |= set_keyframe_from_aviutl(&keyframe_list, oip);

	//`v^[L[t[ݒ
	if (!ret && conf->vid.check_keyframe & CHECK_KEYFRAME_CHAPTER)
		ret |= set_keyframe_from_chapter(&keyframe_list, conf, oip, pe, sys_dat);

	if (ret) {
		//G[Ȃf
	} else if (!keyframe_list.size()) {
		write_log_auo_line(LOG_INFO, "L[t[Ts܂AL[t[ݒoł܂łB");
	} else {
		//dvf폜 + \[głĂ
		std::set<int> keyframe_set(keyframe_list.begin(), keyframe_list.end());

		if (!conf->vid.afs) {
			keyframe_list.assign(keyframe_set.begin(), keyframe_set.end());
		} else {
			ret |= adjust_keyframe_as_afs_24fps(&keyframe_list, &keyframe_set, oip);
		}

		if (!ret) {
			FILE *qpfile = NULL;
			if (NULL != fopen_s(&qpfile, auoqpfile, "wb")) {
				ret |= AUO_RESULT_ERROR; warning_auto_qpfile_failed();
			} else {
				//o
				foreach(std::vector<int>, it_keyframe, &keyframe_list)
					fprintf(qpfile, "%d I\r\n", *it_keyframe);
				fclose(qpfile);
			}
		}
	}
	return ret;
}

static AUO_RESULT write_log_x264_version(const char *x264fullpath) {
	AUO_RESULT ret = AUO_RESULT_WARNING;
	static const int REQUIRED_X264_CORE = 104;
	static const int REQUIRED_X264_REV = 1673;
	char buffer[2048] = { 0 };
	if (get_exe_message(x264fullpath, "--version", buffer, _countof(buffer), AUO_PIPE_MUXED) == RP_SUCCESS) {
		char print_line[512] = { 0 };
		const char *LINE_HEADER = "x264 version: ";
		const char *LINE_CONFIGURATION = "configuration:";
		BOOL line_configuration = FALSE;
		sprintf_s(print_line, _countof(print_line), LINE_HEADER);
		int a = -1, b = -1, c = -1;
		for (char *ptr = buffer, *qtr = NULL; NULL != (ptr = strtok_s(ptr, "\r\n", &qtr)); ) {
			if (ptr == buffer) {
				strcat_s(print_line, _countof(print_line), ptr + strlen("x264 ") * (NULL == strncmp(ptr, "x264 ", strlen("x264 "))));
				if (3 != sscanf_s(ptr, "x264 %d.%d.%d", &a, &b, &c))
					a = b = c = -1;
			} else if (strstr(ptr, LINE_CONFIGURATION)) {
				strcat_s(print_line, _countof(print_line), ptr + strlen(LINE_CONFIGURATION));
				line_configuration = TRUE;
			} else if (line_configuration) {
				const char *rtr = ptr;
				while (*rtr == ' ') rtr++;
				if ((size_t)(rtr - ptr) == strlen(LINE_CONFIGURATION) + 1) {
					strcat_s(print_line, _countof(print_line), ptr + strlen(LINE_CONFIGURATION));
				} else {
					line_configuration = FALSE;
				}
			} else {
				line_configuration = FALSE;
			}
			ptr = NULL;
		}
		if (strlen(print_line) > strlen(LINE_HEADER)) {
			write_log_auo_line(LOG_INFO, print_line);
		}
		if (a >= 0 && b >= 0 && c >= 0) {
			ret = (b >= REQUIRED_X264_CORE || c >= REQUIRED_X264_REV) ? AUO_RESULT_SUCCESS : AUO_RESULT_ERROR;
		}
	}
	return ret;
}

//auo_pipe.cppread_from_pipe̓ʔ
static int ReadLogEnc(PIPE_SET *pipes, int total_drop, int current_frames) {
	DWORD pipe_read = 0;
	if (!PeekNamedPipe(pipes->stdErr.h_read, NULL, 0, NULL, &pipe_read, NULL))
		return -1;
	if (pipe_read) {
		ReadFile(pipes->stdErr.h_read, pipes->read_buf + pipes->buf_len, sizeof(pipes->read_buf) - pipes->buf_len - 1, &pipe_read, NULL);
		pipes->buf_len += pipe_read;
		write_log_enc_mes(pipes->read_buf, &pipes->buf_len, total_drop, current_frames);
	} else {
		log_process_events();
	}
	return pipe_read;
}

//cmdex̂Agui甭sIvVƂ̏Փ˂`FbNāAǂݎȂR}hǉ
static void append_cmdex(char *cmd, size_t nSize, const char *cmdex, BOOL disble_guicmd, const CONF_GUIEX *conf) {
	const size_t cmd_len = strlen(cmd);
	const size_t cmdex_len = strlen(cmdex);

	//CLI[hȂɃ`FbNXLbv
	BOOL skip_check_if_imported = disble_guicmd;
	//--presetȂǂ̓ȃIvV`FbNXLbv
	const char * const IRREGULAR_OPTIONS[] = { "--preset", "--tune", "--profile", NULL };
	for (int i = 0; IRREGULAR_OPTIONS[i] && !skip_check_if_imported; i++)
		skip_check_if_imported = (NULL != strstr(cmdex, IRREGULAR_OPTIONS[i]));

	sprintf_s(cmd + cmd_len, nSize - cmd_len, " %s", cmdex);

	if (skip_check_if_imported) {
		//s̃`FbN̂ݍs
		replace_cmd_CRLF_to_Space(cmd + cmd_len + 1, nSize - cmd_len - 1);
	} else {
		CONF_GUIEX cnf = *conf;
		//confɓǂݍ܂AǂݎȂ݂̂𓾂
		set_cmd_to_conf(cmd + cmd_len + 1, &cnf.x264, cmdex_len, TRUE);
	}
}

static void build_full_cmd(char *cmd, size_t nSize, const CONF_GUIEX *conf, const OUTPUT_INFO *oip, const PRM_ENC *pe, const SYSTEM_DATA *sys_dat, const char *input) {
	CONF_GUIEX prm;
	//p[^Rs[
	memcpy(&prm, conf, sizeof(CONF_GUIEX));
	//ʒus
	cmd_replace(prm.vid.cmdex,     sizeof(prm.vid.cmdex),     pe, sys_dat, conf, oip);
	cmd_replace(prm.vid.stats,     sizeof(prm.vid.stats),     pe, sys_dat, conf, oip);
	cmd_replace(prm.vid.tcfile_in, sizeof(prm.vid.tcfile_in), pe, sys_dat, conf, oip);
	cmd_replace(prm.vid.cqmfile,   sizeof(prm.vid.cqmfile),   pe, sys_dat, conf, oip);
	if (!prm.oth.disable_guicmd) {
		//cli[hłȂ
		//ݒ̓Kp
		apply_guiEx_auto_settings(&prm.x264, oip->w, oip->h, oip->rate, oip->scale);
		//GUĨR}hC
		build_cmd_from_conf(cmd, nSize, &prm.x264, &prm.vid, FALSE);
	}
	//cmdex̂AǂݎȂR}hǉ
	if (str_has_char(prm.vid.cmdex))
		append_cmdex(cmd, nSize, prm.vid.cmdex, prm.oth.disable_guicmd, conf);
	//bZ[W̔s
	if ((conf->x264.vbv_bufsize != 0 || conf->x264.vbv_maxrate != 0) && prm.vid.afs)
		write_log_auo_line(LOG_INFO, "tB[hVtggpvbvݒ͐mɔf܂B");
	//L[t[osAQPt@C݂A--qpfile̎w肪Ȃ΁Aqpfileœǂݍ
	char auoqpfile[MAX_PATH_LEN];
	apply_appendix(auoqpfile, _countof(auoqpfile), pe->temp_filename, pe->append.qp);
	BOOL disable_keyframe_afs = conf->vid.afs && !sys_dat->exstg->s_local.set_keyframe_as_afs_24fps;
	if (prm.vid.check_keyframe && !disable_keyframe_afs && PathFileExists(auoqpfile) && strstr(cmd, "--qpfile") == NULL)
		sprintf_s(cmd + strlen(cmd), nSize - strlen(cmd), " --qpfile \"%s\"", auoqpfile);
	//1passڂafsłȂA--framesȂ--framesw
	if ((!prm.vid.afs || pe->current_x264_pass > 1) && strstr(cmd, "--frames") == NULL)
		sprintf_s(cmd + strlen(cmd), nSize - strlen(cmd), " --frames %d", oip->n - pe->drop_count);
	//𑜓xǉ(--input-res)
	if (strcmp(input, PIPE_FN) == NULL)
		sprintf_s(cmd + strlen(cmd), nSize - strlen(cmd), " --input-res %dx%d", oip->w, oip->h);
	//raw̌`ǉ
	sprintf_s(cmd + strlen(cmd), nSize - strlen(cmd), " --input-csp %s", specify_input_csp(prm.x264.output_csp));
	//fps//tcfile-inw肳ĂꍇAfps̎t~]
	if (!prm.x264.use_tcfilein && strstr(cmd, "--tcfile-in") == NULL) {
		int gcd = get_gcd(oip->rate, oip->scale);
		sprintf_s(cmd + strlen(cmd), nSize - strlen(cmd), " --fps %d/%d", oip->rate / gcd, oip->scale / gcd);
	}
	//o̓t@C
	const char * const outfile = (prm.x264.nul_out) ? "nul" : pe->temp_filename;
	sprintf_s(cmd + strlen(cmd), nSize - strlen(cmd), " -o \"%s\"", outfile);
	//
	sprintf_s(cmd + strlen(cmd), nSize - strlen(cmd), " \"%s\"", input);
}

static void set_pixel_data(CONVERT_CF_DATA *pixel_data, const CONF_GUIEX *conf, int w, int h) {
	const int byte_per_pixel = (conf->x264.use_highbit_depth) ? sizeof(short) : sizeof(BYTE);
	ZeroMemory(pixel_data, sizeof(CONVERT_CF_DATA));
	switch (conf->x264.output_csp) {
		case OUT_CSP_NV16: //nv16 (YUV422)
			pixel_data->count = 2;
			pixel_data->size[0] = w * h * byte_per_pixel;
			pixel_data->size[1] = pixel_data->size[0];
			break;
		case OUT_CSP_YUY2: //yuy2 (YUV422)
			pixel_data->count = 1;
			pixel_data->size[0] = w * h * byte_per_pixel * 2;
			break;
		case OUT_CSP_YUV444: //i444 (YUV444 planar)
			pixel_data->count = 3;
			pixel_data->size[0] = w * h * byte_per_pixel;
			pixel_data->size[1] = pixel_data->size[0];
			pixel_data->size[2] = pixel_data->size[0];
			break;
		case OUT_CSP_RGB: //RGB packed
			pixel_data->count = 1;
			pixel_data->size[0] = w * h * 3 * sizeof(BYTE); //8bit only
			break;
		case OUT_CSP_NV12: //nv12 (YUV420)
		default:
			pixel_data->count = 2;
			pixel_data->size[0] = w * h * byte_per_pixel;
			pixel_data->size[1] = pixel_data->size[0] / 2;
			break;
	}
	//TCY̑avZ
	for (int i = 0; i < pixel_data->count; i++)
		pixel_data->total_size += pixel_data->size[i];
}

static inline void check_enc_priority(HANDLE h_aviutl, HANDLE h_x264, DWORD priority) {
	if (priority == AVIUTLSYNC_PRIORITY_CLASS)
		priority = GetPriorityClass(h_aviutl);
	SetPriorityClass(h_x264, priority);
}

//񏈗ɉf[^擾
static AUO_RESULT aud_parallel_task(const OUTPUT_INFO *oip, PRM_ENC *pe) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	AUD_PARALLEL_ENC *aud_p = &pe->aud_parallel; //ŏȗ
	if (aud_p->th_aud) {
		//---   rubN Jn  ---> Xbh~܂ĂȂ΂ȂȂ
		if_valid_wait_for_single_object(aud_p->he_vid_start, INFINITE);
		if (aud_p->he_vid_start && aud_p->get_length) {
			DWORD required_buf_size = aud_p->get_length * (DWORD)oip->audio_size;
			if (aud_p->buf_max_size < required_buf_size) {
				//sȂĊm
				if (aud_p->buffer) free(aud_p->buffer);
				aud_p->buf_max_size = required_buf_size;
				if (NULL == (aud_p->buffer = malloc(aud_p->buf_max_size)))
					aud_p->buf_max_size = 0; //mallocG[͎̕AUO_RESULT_ERRORɐݒ
			}
			void *data_ptr = NULL;
			if (NULL == aud_p->buffer || 
				NULL == (data_ptr = oip->func_get_audio(aud_p->start, aud_p->get_length, &aud_p->get_length))) {
				ret = AUO_RESULT_ERROR; //mallocG[get_audiõG[
			} else {
				//Õobt@ɃRs[data_ptrjĂǂ悤ɂ
				memcpy(aud_p->buffer, data_ptr, aud_p->get_length * oip->audio_size);
			}
			//łTRUEȂύXȂ悤ɂ
			aud_p->abort |= oip->func_is_abort();
		}
		flush_audio_log();
		if_valid_set_event(aud_p->he_aud_start);
		//---   rubN I  ---> XbhJn
	}
	return ret;
}

//ǂǂ񂵂ďI
static AUO_RESULT finish_aud_parallel_task(const OUTPUT_INFO *oip, PRM_ENC *pe, AUO_RESULT vid_ret) {
	//G[Ă特o̓[vƂ߂
	pe->aud_parallel.abort |= (vid_ret != AUO_RESULT_SUCCESS);
	if (pe->aud_parallel.th_aud) {
		for (int wait_for_audio_count = 0; pe->aud_parallel.he_vid_start; wait_for_audio_count++) {
			vid_ret |= aud_parallel_task(oip, pe);
			if (wait_for_audio_count == 5)
				write_log_auo_line(LOG_INFO, "̏Iҋ@Ă܂...");
		}
	}
	return vid_ret;
}

//񏈗Xbh̏I҂AIR[h
static AUO_RESULT exit_audio_parallel_control(const OUTPUT_INFO *oip, PRM_ENC *pe, AUO_RESULT vid_ret) {
	vid_ret |= finish_aud_parallel_task(oip, pe, vid_ret); //wavo͂
	release_audio_parallel_events(pe);
	if (pe->aud_parallel.buffer) free(pe->aud_parallel.buffer);
	if (pe->aud_parallel.th_aud) {
		//GR[h
		//2passGR[hƂƉGR[_̏Iҋ@Kv
		int wait_for_audio_count = 0;
		while (WaitForSingleObject(pe->aud_parallel.th_aud, LOG_UPDATE_INTERVAL) == WAIT_TIMEOUT) {
			if (wait_for_audio_count == 10)
				set_window_title("̏Iҋ@Ă܂...", PROGRESSBAR_MARQUEE);
			pe->aud_parallel.abort |= oip->func_is_abort();
			log_process_events();
			wait_for_audio_count++;
		}
		flush_audio_log();
		if (wait_for_audio_count > 10)
			set_window_title(AUO_FULL_NAME, PROGRESSBAR_DISABLED);

		DWORD exit_code = 0;
		//GetExitCodeThread̕ԂlNULLȂG[
		vid_ret |= (NULL == GetExitCodeThread(pe->aud_parallel.th_aud, &exit_code)) ? AUO_RESULT_ERROR : exit_code;
		CloseHandle(pe->aud_parallel.th_aud);
	}
	// (dv!!!)
	ZeroMemory(&pe->aud_parallel, sizeof(pe->aud_parallel));
	return vid_ret;
}

static AUO_RESULT x264_out(CONF_GUIEX *conf, const OUTPUT_INFO *oip, PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	PIPE_SET pipes = { 0 };
	PROCESS_INFORMATION pi_enc = { 0 };

	char x264cmd[MAX_CMD_LEN]  = { 0 };
	char x264args[MAX_CMD_LEN] = { 0 };
	char x264dir[MAX_PATH_LEN] = { 0 };
	char *x264fullpath = (conf->x264.use_highbit_depth) ? sys_dat->exstg->s_x264.fullpath_highbit : sys_dat->exstg->s_x264.fullpath;
	
	const BOOL afs = conf->vid.afs != 0;
	CONVERT_CF_DATA pixel_data = { 0 };
	set_pixel_data(&pixel_data, conf, oip->w, oip->h);
	
	int *jitter = NULL;
	int rp_ret = 0;

	//x264Dx֘Ȁ
	DWORD set_priority = (pe->h_p_aviutl || conf->vid.priority != AVIUTLSYNC_PRIORITY_CLASS) ? priority_table[conf->vid.priority].value : NORMAL_PRIORITY_CLASS;

	//vZXp񏀔
	if (!PathFileExists(x264fullpath)) {
		ret |= AUO_RESULT_ERROR; error_no_exe_file("x264", x264fullpath);
		return ret;
	}
	PathGetDirectory(x264dir, _countof(x264dir), x264fullpath);

    //YUY2/YC48->NV12/YUV444, RGBRs[p֐
	const int input_csp_idx = get_aviutl_color_format(conf->x264.use_highbit_depth, conf->x264.output_csp, conf->vid.input_as_lw48);
	const func_convert_frame convert_frame = get_convert_func(oip->w, input_csp_idx, conf->x264.use_highbit_depth, conf->x264.interlaced, conf->x264.output_csp);
	if (convert_frame == NULL) {
		ret |= AUO_RESULT_ERROR; error_select_convert_func(oip->w, oip->h, conf->x264.use_highbit_depth, conf->x264.interlaced, conf->x264.output_csp);
		return ret;
	}
	//fobt@pm
	if (!malloc_pixel_data(&pixel_data, oip->w, oip->h, conf->x264.output_csp, conf->x264.use_highbit_depth)) {
		ret |= AUO_RESULT_ERROR; error_malloc_pixel_data();
		return ret;
	}

	//pCv̐ݒ
	pipes.stdIn.mode = AUO_PIPE_ENABLE;
	pipes.stdErr.mode = AUO_PIPE_ENABLE;
	pipes.stdIn.bufferSize = pixel_data.total_size * 2;

	//x264o[W\E`FbN
	if (AUO_RESULT_ERROR == write_log_x264_version(x264fullpath)) {
		ret |= AUO_RESULT_ERROR; error_x264_version();
		return ret;
	}

	//R}hC
	build_full_cmd(x264cmd, _countof(x264cmd), conf, oip, pe, sys_dat, PIPE_FN);
	write_log_auo_line(LOG_INFO, "x264 options...");
	write_args(x264cmd);
	sprintf_s(x264args, _countof(x264args), "\"%s\" %s", x264fullpath, x264cmd);
	
	if (conf->vid.afs && conf->x264.interlaced) {
		ret |= AUO_RESULT_ERROR; error_afs_interlace_stg();
	//jitterp̈m
	} else if ((jitter = (int *)calloc(oip->n + 1, sizeof(int))) == NULL) {
		ret |= AUO_RESULT_ERROR; error_malloc_tc();
	//Aviutl(afs)̃t[ǂݍ
	} else if (!setup_afsvideo(oip, conf, pe, sys_dat->exstg->s_local.auto_afs_disable)) {
		ret |= AUO_RESULT_ERROR; //Aviutl(afs)̃t[ǂݍ݂Ɏs
	//x264vZXJn
	} else if ((rp_ret = RunProcess(x264args, x264dir, &pi_enc, &pipes, (set_priority == AVIUTLSYNC_PRIORITY_CLASS) ? GetPriorityClass(pe->h_p_aviutl) : set_priority, TRUE, FALSE)) != RP_SUCCESS) {
		ret |= AUO_RESULT_ERROR; error_run_process("x264", rp_ret);
	} else {
		//SĐ
		int i = 0;
		void *frame = NULL;
		int *next_jitter = NULL;
		BOOL enc_pause = FALSE, copy_frame = FALSE, drop = FALSE;
		const DWORD aviutl_color_fmt = COLORFORMATS[get_aviutl_color_format(conf->x264.use_highbit_depth, conf->x264.output_csp, conf->vid.input_as_lw48)].FOURCC;

		//x264ҋ@ɓ܂łҋ@
		while (WaitForInputIdle(pi_enc.hProcess, LOG_UPDATE_INTERVAL) == WAIT_TIMEOUT)
			log_process_events();

		//OEBhE琧\
		DWORD tm_vid_enc_start = timeGetTime();
		enable_x264_control(&set_priority, &enc_pause, afs, afs && pe->current_x264_pass == 1, tm_vid_enc_start, oip->n);

		//------------C[v------------
		for (i = 0, next_jitter = jitter + 1, pe->drop_count = 0; i < oip->n; i++, next_jitter++) {
			//fmF
			if (FALSE != oip->func_is_abort()) {
				ret |= AUO_RESULT_ABORT;
				break;
			}
			//x264sȂAbZ[W擾EOEBhEɕ\
			if (ReadLogEnc(&pipes, pe->drop_count, i) < 0) {
				//Ɏ...
				ret |= AUO_RESULT_ERROR; error_x264_dead();
				break;
			}

			//ꎞ~
			while (enc_pause) {
				Sleep(LOG_UPDATE_INTERVAL);
				log_process_events();
			}

			if (!(i & 7)) {
				//Aviutl̐i\XV
				oip->func_rest_time_disp(i + oip->n * (pe->current_x264_pass - 1), oip->n * pe->total_x264_pass);

				//x264Dx
				check_enc_priority(pe->h_p_aviutl, pi_enc.hProcess, set_priority);

				//
				ret |= aud_parallel_task(oip, pe);
			}
			//Aviutl(afs)t[炤
			if (NULL == (frame = ((afs) ? afs_get_video((OUTPUT_INFO *)oip, i, &drop, next_jitter) : oip->func_get_video_ex(i, aviutl_color_fmt)))) {
				ret |= AUO_RESULT_ERROR; error_afs_get_frame();
				break;
			}

			//Rs[t[tO
			copy_frame = (i && (oip->func_get_flag(i) & OUTPUT_INFO_FRAME_FLAG_COPYFRAME));
			drop |= (afs & copy_frame);

			if (!drop) {
				//Rs[t[̏ꍇ́Afobt@̒gXVÂ܂܃pCvɗ
				if (!copy_frame)
					convert_frame(frame, &pixel_data, oip->w, oip->h);  /// YUY2/YC48->NV12/YUV444ϊ, RGBRs[
				//ff[^pCv
				for (int j = 0; j < pixel_data.count; j++)
					_fwrite_nolock((void *)pixel_data.data[j], 1, pixel_data.size[j], pipes.f_stdin);
			} else {
				*(next_jitter - 1) = DROP_FRAME_FLAG;
				pe->drop_count++;
			}

			// u\ -> Z[uvr[\v`FbNĂ
			// func_update_preview() ̌Ăяoɂ func_get_video_ex() 
			// 擾obt@Ă܂̂ŁAĂяoʒuړ (gAVIo plus )
			oip->func_update_preview();
		}
		//------------C[v܂--------------

		//OEBhEx264𖳌
		disable_x264_control();

		//pCv
		CloseStdIn(&pipes);

		if (!ret) oip->func_rest_time_disp(oip->n * pe->current_x264_pass, oip->n * pe->total_x264_pass);

		//̓I
		ret |= finish_aud_parallel_task(oip, pe, ret);
		//Ƃ̓I
		release_audio_parallel_events(pe);

		//^CR[ho
		if (!ret && (afs || conf->vid.auo_tcfile_out))
			tcfile_out(jitter, oip->n, (double)oip->rate / (double)oip->scale, afs, pe);

		//GR[_Iҋ@
		while (WaitForSingleObject(pi_enc.hProcess, LOG_UPDATE_INTERVAL) == WAIT_TIMEOUT)
			ReadLogEnc(&pipes, pe->drop_count, i);

		DWORD tm_vid_enc_fin = timeGetTime();

		//ŌɃbZ[W擾
		while (ReadLogEnc(&pipes, pe->drop_count, i) > 0);

		if (!(ret & AUO_RESULT_ERROR) && afs)
			write_log_auo_line_fmt(LOG_INFO, "drop %d / %d frames", pe->drop_count, i);

		write_log_auo_enc_time("x264GR[h", tm_vid_enc_fin - tm_vid_enc_start);
	}

	//
	if (pipes.stdErr.mode)
		CloseHandle(pipes.stdErr.h_read);
	CloseHandle(pi_enc.hProcess);
	CloseHandle(pi_enc.hThread);

	free_pixel_data(&pixel_data);
	if (jitter) free(jitter);

	ret |= exit_audio_parallel_control(oip, pe, ret);

	return ret;
}

static void set_window_title_x264(const PRM_ENC *pe) {
	char mes[256] = { 0 };
	strcpy_s(mes, _countof(mes), "x264GR[h");
	if (pe->total_x264_pass > 1)
		sprintf_s(mes + strlen(mes), _countof(mes) - strlen(mes), "   %d / %d pass", pe->current_x264_pass, pe->total_x264_pass);
	if (pe->aud_parallel.th_aud)
		strcat_s(mes, _countof(mes), " + GR[h");
	set_window_title(mes, PROGRESSBAR_CONTINUOUS);
}

static AUO_RESULT check_amp(CONF_GUIEX *conf, const OUTPUT_INFO *oip, PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	if (!(conf->x264.use_auto_npass && conf->x264.rc_mode == X264_RC_BITRATE) || !conf->vid.amp_check)
		return AUO_RESULT_SUCCESS;
	//t@CTCY擾
	double aud_bitrate = 0.0;
	const double duration = get_duration(conf, sys_dat, pe, oip);
	UINT64 aud_filesize = 0;
	if (oip->flag & OUTPUT_INFO_FLAG_AUDIO) {
		if (!str_has_char(pe->append.aud[0])) { //GR܂IĂȂ
			info_amp_do_aud_enc_first(conf->vid.amp_check);
			return AUO_RESULT_ABORT; //GRɂׂAGRI
		}
		for (int i_aud = 0; i_aud < pe->aud_count; i_aud++) {
			char aud_file[MAX_PATH_LEN];
			apply_appendix(aud_file, _countof(aud_file), pe->temp_filename, pe->append.aud[i_aud]);
			if (!PathFileExists(aud_file)) {
				error_no_aud_file();
				return AUO_RESULT_ERROR;
			}
			UINT64 filesize_tmp = 0;
			if (!GetFileSizeUInt64(aud_file, &filesize_tmp)) {
				warning_failed_get_aud_size(); warning_amp_failed();
				return AUO_RESULT_ERROR;
			}
			aud_filesize += filesize_tmp;
		}
		if ((conf->vid.amp_check & AMPLIMIT_FILE_SIZE) && 
			aud_filesize >= conf->vid.amp_limit_file_size * 1024 * 1024) {
			error_amp_aud_too_big(AMPLIMIT_FILE_SIZE);
			return AUO_RESULT_ERROR;
		}
		aud_bitrate = aud_filesize * 8.0 / 1000.0 / duration;
		if ((conf->vid.amp_check & AMPLIMIT_BITRATE) &&
			aud_bitrate >= conf->vid.amp_limit_bitrate) {
			error_amp_aud_too_big(AMPLIMIT_BITRATE);
			return AUO_RESULT_ERROR;
		}
	}
	//ڕWrbg[ǧvZ
	DWORD target_limit = NULL; //t@CTCYƏrbg[gǂɂ鐧
	double required_file_bitrate = DBL_MAX;
	//t@CTCỸ`FbN
	if (conf->vid.amp_check & AMPLIMIT_FILE_SIZE) {
		required_file_bitrate = conf->vid.amp_limit_file_size*1024*1024 * 8.0/1000.0 / duration; //ɊU邱Ƃ̂łőrbg[g
		target_limit = AMPLIMIT_FILE_SIZE;
	}
	//rbg[g̃`FbN
	if ((conf->vid.amp_check & AMPLIMIT_BITRATE) &&
		required_file_bitrate > conf->vid.amp_limit_bitrate) {
		required_file_bitrate = conf->vid.amp_limit_bitrate;
		target_limit = AMPLIMIT_BITRATE;
	}
	double required_vid_bitrate = get_amp_margin_bitrate(required_file_bitrate - aud_bitrate, sys_dat->exstg->s_local.amp_bitrate_margin_multi);
	//܂ɂvZrbg[gG[o
	if (required_vid_bitrate <= 1.0) {
		error_amp_target_bitrate_too_small(target_limit);
		return AUO_RESULT_ERROR;
	}
	//vZꂽrbg[gڕWrbg[gĂAڕWrbg[gύX
	//conf->x264.bitrate = -1͎ł邪A
	//DWORDƂĈƂUINT_MAXƂAIɔf
	if (required_vid_bitrate < (double)((DWORD)conf->x264.bitrate)) {
		warning_amp_change_bitrate(conf->x264.bitrate, (int)(required_vid_bitrate + 0.5), target_limit);
		conf->x264.bitrate = (int)(required_vid_bitrate + 0.5);
	}
	return AUO_RESULT_SUCCESS;
}

static AUO_RESULT video_output_inside(CONF_GUIEX *conf, const OUTPUT_INFO *oip, PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	//GR[h̕KvȂΏI
	if (pe->video_out_type == VIDEO_OUTPUT_DISABLED)
		return ret;

	//ŏ̂ݎs镔
	if (pe->current_x264_pass <= 1) {
		//}`pXp`FbN
		if ((ret |= check_amp(conf, oip, pe, sys_dat)) != AUO_RESULT_SUCCESS) {
			return (ret & ~AUO_RESULT_ABORT); //AUO_RESULT_ABORTȂAɃGR[h邽߁AGR[hꎞIɃXLbv
		}
		//ǉR}hp[^ɓKp
		ret |= check_cmdex(conf, oip, pe, sys_dat);

		//L[t[o (cmdex̂ق--qpfile̎w肪΂D悷)
		if (!ret && conf->vid.check_keyframe && strstr(conf->vid.cmdex, "--qpfile") == NULL)
			set_keyframe(conf, oip, pe, sys_dat);
	}

	for (; !ret && pe->current_x264_pass <= pe->total_x264_pass; pe->current_x264_pass++) {
		if (conf->x264.use_auto_npass) {
			//npasso
			switch (pe->current_x264_pass) {
				case 1:
					conf->x264.pass = 1;
					break;
				case 2:
					if (conf->vid.afs && conf->vid.afs_bitrate_correction)
						conf->x264.bitrate = (conf->x264.bitrate * oip->n) / (oip->n - pe->drop_count);
					//փtH[X[
				default:
					open_log_window(oip->savefile, pe->current_x264_pass, pe->total_x264_pass);
					if (pe->current_x264_pass == pe->total_x264_pass)
						conf->x264.nul_out = FALSE;
					conf->x264.pass = 3;
					break;
			}
		}
		set_window_title_x264(pe);
		ret |= x264_out(conf, oip, pe, sys_dat);
	}

	set_window_title(AUO_FULL_NAME, PROGRESSBAR_DISABLED);
	return ret;
}

AUO_RESULT video_output(CONF_GUIEX *conf, const OUTPUT_INFO *oip, PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	return exit_audio_parallel_control(oip, pe, video_output_inside(conf, oip, pe, sys_dat));
}
