//  -----------------------------------------------------------------------------------------
//    g x264 o(GUI) Ex  v1.xx/2.xx by rigaya
//  -----------------------------------------------------------------------------------------
//   \[XR[hɂ
//   Eۏ؂łB
//   E{\[XR[hgpƂɂ邢Ȃ鑹QEguɂrigaya͐ӔC𕉂܂B
//   ȏɗĒꍇA{\[XR[h̎gpAAρAĔЕzsĒč\܂B
//  -----------------------------------------------------------------------------------------

#include <Windows.h>
#include <Math.h>
#include <stdlib.h>
#include <shlwapi.h>
#pragma comment(lib, "shlwapi.lib")

#include "output.h"
#include "auo.h"
#include "auo_version.h"
#include "auo_frm.h"
#include "auo_pipe.h"
#include "auo_encode.h"
#include "auo_error.h"
#include "auo_conf.h"
#include "auo_util.h"
#include "auo_chapter.h"
#include "auo_system.h"
#include "auo_mux.h"
#include "auo_encode.h"

static void show_mux_info(const char *mux_stg_name, BOOL vidmux, BOOL audmux, BOOL tcmux, const char *muxer_mode_name) {
	char mes[1024];
	static const char * const ON_OFF_INFO[] = { "off", " on" };

	sprintf_s(mes, _countof(mes), "%s muxs܂Bf:%s, :%s, tc:%s, g[h:%s", 
		mux_stg_name,
		ON_OFF_INFO[vidmux != 0],
		ON_OFF_INFO[audmux != 0],
		ON_OFF_INFO[tcmux != 0],
		muxer_mode_name);
	write_log_auo_line_fmt(LOG_INFO, mes);

	sprintf_s(mes, _countof(mes), "%s  mux...", mux_stg_name);
	set_window_title(mes, PROGRESSBAR_MARQUEE);
}

//mux̋󂫗eʂȂǂvZAs邩mF
static AUO_RESULT check_mux_disk_space(const MUXER_SETTINGS *mux_stg, const char *mux_tmpdir, const CONF_GUIEX *conf, const PRM_ENC *pe, UINT64 expected_filesize) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	UINT64 required_space = (UINT64)(expected_filesize * 1.01); //傢
	//o͐hCu
	char vid_root[MAX_PATH_LEN];
	strcpy_s(vid_root, _countof(vid_root), pe->temp_filename);
	PathStripToRoot(vid_root);
	//ꎞtH_wp̃R}h΁AꎞtH_̎wɂČ
	if (str_has_char(mux_stg->tmp_cmd) && conf->mux.mp4_temp_dir) {
		ULARGE_INTEGER temp_drive_avail_space = { 0 };
		BOOL tmp_same_drive_as_out = FALSE;
		//w肳ꂽhCu݂邩ǂ
		char temp_root[MAX_PATH_LEN];
		if (!PathGetRoot(mux_tmpdir, temp_root, _countof(temp_root)) ||
			!PathIsDirectory(temp_root) ||
			!DirectoryExistsOrCreate(mux_tmpdir)) {
			ret = AUO_RESULT_WARNING; warning_no_mux_tmp_root(temp_root);
		//󂫗eʂ擾łĂȂ΁A`FbNI
		} else if (expected_filesize <= 0) {
			return AUO_RESULT_SUCCESS;
		//hCű󂫗eʎ擾
		} else if (!GetDiskFreeSpaceEx(temp_root, &temp_drive_avail_space, NULL, NULL)) {
			ret = AUO_RESULT_WARNING; warning_failed_mux_tmp_drive_space();
		//ꎞtH_Əo͐悪tH_ǂŁAꎞtH_̕KvƂ󂫗̈悪ς
		} else {
			tmp_same_drive_as_out = (_stricmp(vid_root, temp_root) == NULL);
			if ((UINT64)temp_drive_avail_space.QuadPart < required_space * (1 + tmp_same_drive_as_out)) {
				ret = AUO_RESULT_WARNING; warning_mux_tmp_not_enough_space();
			}
		}
		//ꎞtH_Əo͐悪tH_Ȃ炳Ȃ錟؂̕Kv͂Ȃ
		if (tmp_same_drive_as_out && ret == AUO_RESULT_SUCCESS)
			return ret;
	}
	//󂫗eʂ擾łĂȂ΁A`FbNI
	if (expected_filesize <= 0)
		return AUO_RESULT_SUCCESS;
	//ꎞt@Cw肳ĂȂƂɂ̓JgfBNĝhCu(muxer̂hCu)Ɉꎞt@C
	//̈ꎞtH_̃hCuɂČ
	if (!conf->mux.mp4_temp_dir || ret == AUO_RESULT_WARNING) {
		char muxer_root[MAX_PATH_LEN];
		//hCű󂫗eʎ擾
		ULARGE_INTEGER muxer_drive_avail_space = { 0 };
		if (!PathGetRoot(mux_stg->fullpath, muxer_root, _countof(muxer_root)) ||
			!GetDiskFreeSpaceEx(muxer_root, &muxer_drive_avail_space, NULL, NULL)) {
			warning_failed_muxer_drive_space(); return AUO_RESULT_WARNING;
		}
		//ꎞtH_Əo͐悪tH_ǂŁAꎞtH_̕KvƂ󂫗̈悪ς
		BOOL muxer_same_drive_as_out = (_stricmp(vid_root, muxer_root) == NULL);
		if ((UINT64)muxer_drive_avail_space.QuadPart < required_space * (1 + muxer_same_drive_as_out)) {
			error_muxer_drive_not_enough_space(); return AUO_RESULT_ERROR;
		}
		//ꎞtH_Əo͐悪tH_Ȃ炳Ȃ錟؂̕Kv͂Ȃ
		if (muxer_same_drive_as_out && ret == AUO_RESULT_SUCCESS)
			return ret;
	}
	//o͐̃hCű󂫗e
	//hCű󂫗eʎ擾
	ULARGE_INTEGER out_drive_avail_space = { 0 };
	if (!GetDiskFreeSpaceEx(vid_root, &out_drive_avail_space, NULL, NULL)) {
		warning_failed_out_drive_space(); return AUO_RESULT_WARNING;
	}
	if ((UINT64)out_drive_avail_space.QuadPart < required_space) {
		error_out_drive_not_enough_space(); return AUO_RESULT_ERROR;
	}
	return ret;
}

//mux铮t@CƉt@Cmuxt@C̐TCY擾
static AUO_RESULT get_expected_filesize(const PRM_ENC *pe, BOOL enable_vid_mux, DWORD enable_aud_mux, UINT64 *_expected_filesize) {
	*_expected_filesize = 0;
	//t@C̃TCY
	if (enable_vid_mux) {
		UINT64 vid_size = 0;
		if (!PathFileExists(pe->temp_filename)) {
			error_no_vid_file(); return AUO_RESULT_ERROR;
		}
		if (!GetFileSizeUInt64(pe->temp_filename, &vid_size)) {
			warning_failed_get_vid_size(); return AUO_RESULT_WARNING;
		}
		if (vid_size == 0) {
			error_vid_file_zero_byte(); return AUO_RESULT_ERROR;
		}
		*_expected_filesize += vid_size;
	}
	//t@C̃TCY
	if (enable_aud_mux) {
		UINT64 aud_size = 0;
		for (int i_aud = 0; i_aud < pe->aud_count; i_aud++) {
			if (enable_aud_mux & (0x01<<i_aud)) {
				char audfile[MAX_PATH_LEN] = { 0 };
				get_aud_filename(audfile, _countof(audfile), pe, i_aud);
				if (!PathFileExists(audfile)) {
					error_no_aud_file(); return AUO_RESULT_ERROR;
				}
				if (!GetFileSizeUInt64(audfile, &aud_size)) {
					warning_failed_get_aud_size(); return AUO_RESULT_WARNING;
				}
				if (aud_size == 0) {
					error_aud_file_zero_byte(); return AUO_RESULT_ERROR;
				}
				*_expected_filesize += aud_size;
			}
		}
	}
	return AUO_RESULT_SUCCESS;
}

//muxt@C݂鑼ƃt@CTCY`FbN
//vȂTRUEԂ
static AUO_RESULT check_muxout_filesize(const char *muxout, UINT64 expected_filesize) {
	const double FILE_SIZE_THRESHOLD_MULTI = 0.95;
	UINT64 muxout_filesize = 0;
	if (!PathFileExists(muxout)) {
		error_check_muxout_exist();
		return AUO_RESULT_ERROR;
	}
	//t@CTCY̎擾ɎsĂI
	if (expected_filesize <= 0)
		return AUO_RESULT_WARNING;
	if (GetFileSizeUInt64(muxout, &muxout_filesize)) {
		//t@CTCY̎擾ɐA\zTCYƂ̔rs
		if (((double)muxout_filesize) <= ((double)expected_filesize * FILE_SIZE_THRESHOLD_MULTI * (1.0 - exp(-1.0 * (double)expected_filesize / (128.0 * 1024.0))))) {
			error_check_muxout_too_small((int)(expected_filesize / 1024), (int)(muxout_filesize / 1024));
			return AUO_RESULT_ERROR;
		}
		return AUO_RESULT_SUCCESS;
	}
	warning_failed_check_muxout_filesize();
	return AUO_RESULT_WARNING;
}

//sKvȃ`v^[R}h폜
static void del_chap_cmd(char *cmd, BOOL apple_type_only) {
	if (!apple_type_only)
		del_arg(cmd, "%{chap_apple}", -1);
	del_arg(cmd, "%{chapter}", -1);
}

static void build_aud_mux_cmd(char *audstr, size_t nSize, const char *aud_cmd, DWORD enable_aud_mux, const PRM_ENC *pe) {
	*audstr = '\0';
	if (enable_aud_mux == 0x00)
		return;

	for (int i_aud = 0; i_aud < pe->aud_count; i_aud++) {
		if (enable_aud_mux & (0x01 << i_aud)) {
			char audcmd_tmp[1024];
			strcpy_s(audcmd_tmp, _countof(audcmd_tmp), aud_cmd);
			if (i_aud) {
				char audkey[128] = "%{audpath}";
				insert_num_to_replace_key(audkey, _countof(audkey), i_aud);
				replace(audcmd_tmp, _countof(audcmd_tmp), "%{audpath}", audkey);
			}
			strcat_s(audstr, nSize, audcmd_tmp);
			strcat_s(audstr, nSize, " ");
		}
	}
}

static AUO_RESULT build_mux_cmd(char *cmd, size_t nSize, const CONF_GUIEX *conf, const OUTPUT_INFO *oip, const PRM_ENC *pe, 
						  const SYSTEM_DATA *sys_dat, const MUXER_SETTINGS *mux_stg, UINT64 expected_filesize,
						  BOOL enable_vid_mux, DWORD enable_aud_mux, BOOL enable_chap_mux) {
	strcpy_s(cmd, nSize, mux_stg->base_cmd);
	const BOOL enable_tc_mux = ((conf->vid.afs) != 0) && str_has_char(mux_stg->tc_cmd);
	const MUXER_CMD_EX *muxer_mode = &mux_stg->ex_cmd[get_mux_excmd_mode(conf, pe)];
	const char *vidstr = (enable_vid_mux) ? mux_stg->vid_cmd : "";
	const char *tcstr  = (enable_tc_mux) ? mux_stg->tc_cmd : "";
	const char *exstr  = (conf->mux.apple_mode && str_has_char(muxer_mode->cmd_apple)) ? muxer_mode->cmd_apple : muxer_mode->cmd;
	char audstr[MAX_CMD_LEN];
	build_aud_mux_cmd(audstr, _countof(audstr), mux_stg->aud_cmd, enable_aud_mux, pe);
	//fpR}h
	replace(cmd, nSize, "%{vd_cmd}",  vidstr);
	//pR}h
	replace(cmd, nSize, "%{au_cmd}",  audstr);
	//^CR[hp
	replace(cmd, nSize, "%{tc_cmd}",  tcstr);
	//ꎞt@C(󂫗eʓ)̃`FbNs
	AUO_RESULT mux_check = check_mux_disk_space(mux_stg, sys_dat->exstg->s_local.custom_mp4box_tmp_dir, conf, pe, expected_filesize);
	switch (mux_check) {
		case AUO_RESULT_SUCCESS:
			if (conf->mux.mp4_temp_dir) {
				//ꎞtH_ws
				replace(cmd, nSize, "%{tmp_cmd}", mux_stg->tmp_cmd);
				char m_tmp_dir[MAX_PATH_LEN];
				strcpy_s(m_tmp_dir, _countof(m_tmp_dir), sys_dat->exstg->s_local.custom_mp4box_tmp_dir);
				PathForceRemoveBackSlash(m_tmp_dir);
				replace(cmd, nSize, "%{m_tmpdir}", m_tmp_dir);
				break;
			}
			//փtH[X[(ꎞtH_wsȂ)
		case AUO_RESULT_WARNING: //ꎞtH_wsȂ
			replace(cmd, nSize, "%{tmp_cmd}", "");
			break;
		case AUO_RESULT_ERROR://ꎞt@C֘Ã`FbNŃG[
		default:
			return AUO_RESULT_ERROR;
	}
	//gIvVƃ`v^[
	//Ƃ肠KvȂĂ`v^[t@C
	char chap_file[MAX_PATH_LEN];
	char chap_apple[MAX_PATH_LEN];
	set_chap_filename(chap_file, _countof(chap_file), chap_apple, _countof(chap_apple), 
		muxer_mode->chap_file, pe, sys_dat, conf, oip);
	replace(cmd, nSize, "%{ex_cmd}", exstr);
	if (!enable_chap_mux) {
		del_chap_cmd(cmd, FALSE); //`v^[pR}hƃp[^폜
	} else {
		//A`v^[t@Cւ̒uȂA`v^[t@C݂̑`FbN
		if ((strstr(cmd, "%{chapter}") || strstr(cmd, "%{chap_apple}")) && !PathFileExists(chap_file)) {
			//`v^[t@C݂Ȃ
			warning_mux_no_chapter_file();
			del_chap_cmd(cmd, FALSE);
		} else {
			replace(cmd, nSize, "%{chapter}", chap_file);
			//mp4nȂapple``v^[ǉl
			if (pe->muxer_to_be_used == MUXER_MP4 || 
				pe->muxer_to_be_used == MUXER_TC2MP4 || 
				pe->muxer_to_be_used == MUXER_MP4_RAW) {
				//apple``v^[t@Cւ̒usꂽAapple``v^[t@C쐬
				if (strstr(cmd, "%{chap_apple}")) {
					int sts = convert_chapter(chap_apple, chap_file, CODE_PAGE_UNSET, get_duration(conf, sys_dat, pe, oip));
					if (sts != AUO_CHAP_ERR_NONE) {
						warning_mux_chapter(sts);
						del_chap_cmd(cmd, TRUE);
					} else {
						replace(cmd, nSize, "%{chap_apple}", chap_apple);
					}
				}
			}
		}
	}
	//̑̒us
	cmd_replace(cmd, nSize, pe, sys_dat, conf, oip);
	//\
	show_mux_info(mux_stg->dispname, enable_vid_mux, enable_aud_mux, enable_tc_mux, muxer_mode->name);
	return AUO_RESULT_SUCCESS;
}

static void change_mux_vid_filename(const char *muxout, const PRM_ENC *pe) {
	char vidfile_append[MAX_APPENDIX_LEN];
	strcpy_s(vidfile_append, _countof(vidfile_append), "_video");
	strcat_s(vidfile_append, _countof(vidfile_append), PathFindExtension(pe->temp_filename));
	char vidfile_newname[MAX_PATH_LEN];
	apply_appendix(vidfile_newname, _countof(vidfile_newname), pe->temp_filename, vidfile_append);
	rename(pe->temp_filename, vidfile_newname);
	rename(muxout, pe->temp_filename);
}

//rawȂ̂mp4Ȃ̂ (gqɂ锻)
static inline BOOL video_to_mux_is_raw(const PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	return !check_ext(pe->temp_filename, sys_dat->exstg->s_mux[pe->muxer_to_be_used].out_ext);
}

//audio_to_mux_is_raw̃[hp
enum {
	MODE_ONE = 0,                
	MODE_ALL = 0x80000000,
	MASK_ALL = ~MODE_ALL,
	ONE = MODE_ONE | MASK_ALL,  //ЂƂłrawȂTRUEԂ
	ALL = MODE_ALL | MASK_ALL,  //ׂrawȂTRUEԂ
};

//rawȂ̂mp4Ȃ̂ (gqɂ锻)
static inline BOOL audio_to_mux_is_raw(const PRM_ENC *pe, const SYSTEM_DATA *sys_dat, int target) {
	const DWORD mask = (DWORD)target & MASK_ALL;
	BOOL result = !!((DWORD)target & MODE_ALL);
	for (int i_aud = 0; i_aud < pe->aud_count; i_aud++) {
		if (mask & (0x01 << i_aud)) {
			BOOL is_raw = (!check_ext(pe->append.aud[i_aud], ".m4a")
				        && !check_ext(pe->append.aud[i_aud], sys_dat->exstg->s_mux[pe->muxer_to_be_used].out_ext));
			(((DWORD)target & MODE_ALL)) ? result &= is_raw : result |= is_raw;
		}
	}
	return result;
}

//mp4mmuxpmuxerǂ
static inline BOOL muxer_is_remux_only(const PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	//mp4łAMUXER_MP4_RAW݂
	return (pe->muxer_to_be_used == MUXER_MP4
		&& str_has_char(sys_dat->exstg->s_mux[MUXER_MP4_RAW].base_cmd));
}

//rawmmuxpmuxerǂ
static inline BOOL muxer_is_for_raw_only(const PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	//MUXER_MP4_RAWł邱ƂƁȂ݂̊mF
	return (pe->muxer_to_be_used == MUXER_MP4_RAW
		&& str_has_char(sys_dat->exstg->s_mux[MUXER_MP4_RAW].base_cmd));
}

//قȂmuxer쓮AŌpe->muxer_to_be_used߂
//PRM_ENCRs[ĎgpȂ̂́APRM_ENC̃t@C(gq)
//muxɂĕύX邱Ƃ邽(̏pāAmp4raw肵ĂāAdvȏ)
static AUO_RESULT run_mux_as(const CONF_GUIEX *conf, const OUTPUT_INFO *oip, PRM_ENC *pe, const SYSTEM_DATA *sys_dat, int run_as) {
	const int last_muxer = pe->muxer_to_be_used;
	pe->muxer_to_be_used = run_as;
	AUO_RESULT ret = mux(conf, oip, pe, sys_dat);
	pe->muxer_to_be_used = last_muxer;
	return ret;
}

static DWORD check_for_aud_mux(int oip_flag, const char *aud_cmd, const PRM_ENC *pe) {
	BOOL check = ((oip_flag != 0) && str_has_char(aud_cmd));
	DWORD flag = 0x00;
	for (int i = 0; i < pe->aud_count; i++)
		flag |= check << i;
	return flag;
}

AUO_RESULT mux(const CONF_GUIEX *conf, const OUTPUT_INFO *oip, PRM_ENC *pe, const SYSTEM_DATA *sys_dat) {
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	//mux̕KvȂΏI
	if (pe->muxer_to_be_used == MUXER_DISABLED)
		return ret;

	//fEmux
	BOOL  enable_vid_mux = TRUE;
	DWORD enable_aud_mux = check_for_aud_mux(oip->flag, sys_dat->exstg->s_mux[pe->muxer_to_be_used].aud_cmd, pe);
	BOOL  enable_chap_mux = TRUE;
	//OmuxKvȂs (L-SMASH remuxeȓOmuxer)
	if (pe->muxer_to_be_used == MUXER_TC2MP4 && video_to_mux_is_raw(pe, sys_dat)) {
		//mp4Ɋi[ꂽ悪Kv
		if (AUO_RESULT_SUCCESS != (ret |= run_mux_as(conf, oip, pe, sys_dat, MUXER_MP4_RAW)))
			return ret;
	} else if (muxer_is_for_raw_only(pe, sys_dat)) {
		//rawpmuxerɐ؂ւĂAReiւ̊i[KvȂ̂
		//KЂƂЂƂi[悤ɂ
		//`v^[(remuxerɖ߂Ă)ŏ̂ŁAł͖Ă
		enable_chap_mux = FALSE;
		enable_vid_mux = (enable_vid_mux && video_to_mux_is_raw(pe, sys_dat));
		//rawpmuxerɐ؂ւĂAmuxerł͉Ɖf͓muxȂ
		//ɁAafsmuxerłmuxȂ)
		enable_aud_mux = 0x00;
		if (!enable_vid_mux)
			for (int i_aud = 0; i_aud < pe->aud_count; i_aud++)
				if (0 != (enable_aud_mux = audio_to_mux_is_raw(pe, sys_dat, MODE_ONE | (0x01 << i_aud)) << i_aud))
					break;
	} else if (muxer_is_remux_only(pe, sys_dat)) {
		//mp4pmuxer()ŁAEƂrawȂArawpmuxerɊSɐ؂ւ
		if ((enable_vid_mux && video_to_mux_is_raw(pe, sys_dat)) && 
			(enable_aud_mux && audio_to_mux_is_raw(pe, sys_dat, ALL))) {
			pe->muxer_to_be_used = MUXER_MP4_RAW;
		} else {
			//mp4pmuxer()ŁAÊǂ炩rawȂAraŵ̂Omuxermp4Ɋi[B
			if (enable_vid_mux && video_to_mux_is_raw(pe, sys_dat))
				if (AUO_RESULT_SUCCESS != (ret |= run_mux_as(conf, oip, pe, sys_dat, MUXER_MP4_RAW)))
					return ret;
			for (int i_aud = 0; i_aud < pe->aud_count; i_aud++)
				if ((enable_aud_mux & (0x01 << i_aud)) && audio_to_mux_is_raw(pe, sys_dat, MODE_ONE | (0x01 << i_aud)))
					if (AUO_RESULT_SUCCESS != (ret |= run_mux_as(conf, oip, pe, sys_dat, MUXER_MP4_RAW)))
						return ret;
		}
	}

	//mux̊Jn
	const MUXER_SETTINGS *mux_stg = &sys_dat->exstg->s_mux[pe->muxer_to_be_used];

	if (!PathFileExists(mux_stg->fullpath)) {
		ret |= AUO_RESULT_ERROR; error_no_exe_file(mux_stg->dispname, mux_stg->fullpath);
		return ret;
	}
	if (pe->muxer_to_be_used == MUXER_TC2MP4 && !PathFileExists(sys_dat->exstg->s_mux[MUXER_MP4].fullpath)) {		
		ret |= AUO_RESULT_ERROR; error_no_exe_file(sys_dat->exstg->s_mux[MUXER_MP4].dispname, sys_dat->exstg->s_mux[MUXER_MP4].fullpath);
		return ret;
	}
	UINT64 expected_filesize = 0;
	char muxcmd[MAX_CMD_LEN]  = { 0 };
	char muxargs[MAX_CMD_LEN] = { 0 };
	char muxdir[MAX_PATH_LEN] = { 0 };
	char muxout[MAX_PATH_LEN] = { 0 };
	DWORD mux_priority = GetExePriority(conf->mux.priority, pe->h_p_aviutl);
	get_muxout_filename(muxout, _countof(muxout), sys_dat, pe);

	PIPE_SET pipes = { 0 };
	LOG_CACHE log_line_cache = { 0 };
	PROCESS_INFORMATION pi_mux = { 0 };
	int rp_ret;

	//OLbV̏
	if (init_log_cache(&log_line_cache)) {
		error_log_line_cache();
		return AUO_RESULT_ERROR;
	}

	PathGetDirectory(muxdir, _countof(muxdir), mux_stg->fullpath);

	//muxI̗\zTCY擾
	ret |= get_expected_filesize(pe, enable_vid_mux, enable_aud_mux, &expected_filesize);
	if (ret & AUO_RESULT_ERROR)
		return AUO_RESULT_ERROR;

	//R}hCE\
	ret |= build_mux_cmd(muxcmd, _countof(muxcmd), conf, oip, pe, sys_dat, mux_stg, expected_filesize, enable_vid_mux, enable_aud_mux, enable_chap_mux);
	if (ret & AUO_RESULT_ERROR)
		return AUO_RESULT_ERROR; //G[bZ[Wbuild_mux_cmd֐œf
	sprintf_s(muxargs, _countof(muxargs), "\"%s\" %s", mux_stg->fullpath, muxcmd);
	//pCv̐ݒ
	pipes.stdOut.mode = AUO_PIPE_ENABLE;
	pipes.stdErr.mode = AUO_PIPE_MUXED;

	if ((rp_ret = RunProcess(muxargs, muxdir, &pi_mux, &pipes, mux_priority, TRUE, conf->mux.minimized)) != RP_SUCCESS) {
		//G[
		ret |= AUO_RESULT_ERROR; error_run_process(mux_stg->dispname, rp_ret);
	} else {
		while (WaitForSingleObject(pi_mux.hProcess, LOG_UPDATE_INTERVAL) == WAIT_TIMEOUT) {
			if (0 == ReadLogExe(&pipes, mux_stg->dispname, &log_line_cache))
				log_process_events();
		}
		//Ō̃bZ[W
		while (ReadLogExe(&pipes, mux_stg->dispname, &log_line_cache) > 0);

		ret |= check_muxout_filesize(muxout, expected_filesize);
		if (ret == AUO_RESULT_SUCCESS) {
			if (enable_vid_mux) {
				apply_appendix(pe->muxed_vid_filename, _countof(pe->muxed_vid_filename), pe->temp_filename, VID_FILE_APPENDIX);
				strcat_s(pe->muxed_vid_filename, _countof(pe->muxed_vid_filename), PathFindExtension(pe->temp_filename));
				if (PathFileExists(pe->muxed_vid_filename)) remove(pe->muxed_vid_filename);
				rename(pe->temp_filename, pe->muxed_vid_filename);
				change_ext(pe->temp_filename, _countof(pe->temp_filename), mux_stg->out_ext); //gqύX
				if (PathFileExists(pe->temp_filename)) remove(pe->temp_filename);
				rename(muxout, pe->temp_filename);
			} else {
				//̂muxȂAꎞt@C̏ύX
				char aud_file[MAX_PATH_LEN] = { 0 };
				for (int i_aud = 0; i_aud < pe->aud_count; i_aud++) {
					if (enable_aud_mux & (0x01 << i_aud)) {
						get_aud_filename(aud_file, _countof(aud_file), pe, i_aud);
						remove(aud_file);
						change_ext(pe->append.aud[i_aud], _countof(pe->append.aud[i_aud]), mux_stg->out_ext); //gqύX
						get_aud_filename(aud_file, _countof(aud_file), pe, i_aud);
						if (PathFileExists(aud_file)) remove(aud_file);
						rename(muxout, aud_file);
					}
				}
			}
		} else if (ret & AUO_RESULT_ERROR) {
			error_mux_failed(mux_stg->dispname, muxargs);
			if (PathFileExists(muxout))
				remove(muxout);
			write_cached_lines(LOG_ERROR, mux_stg->dispname, &log_line_cache);
		} else {
			//AUO_RESULT_WARNING
			change_mux_vid_filename(muxout, pe);
		}
		CloseHandle(pi_mux.hProcess);
		CloseHandle(pi_mux.hThread);
	}

	release_log_cache(&log_line_cache);
	set_window_title(AUO_FULL_NAME, PROGRESSBAR_DISABLED);

	//mux̕Kv΁As(L-SMASHn timelineeditor ̂Ƃ remuxer z)
	if (!ret && mux_stg->post_mux >= MUXER_MP4) {
		if (AUO_RESULT_SUCCESS != (ret |= run_mux_as(conf, oip, pe, sys_dat, mux_stg->post_mux)))
			return ret;
	}

	return ret;
}
