/*
 * Decompiled with CFR 0.152.
 */
package threadedevent;

import threadedevent.Event;

public class EventQueue {
    private final int BUFFER_SIZE = 1024;
    private Event[] buffer = new Event[1024];
    private int bufferOffset = 0;
    private int bufferLength = 0;

    public synchronized boolean post(Event event) {
        if (this.bufferLength >= 1024) {
            return false;
        }
        int offset = (this.bufferOffset + this.bufferLength) % 1024;
        this.buffer[offset] = event;
        ++this.bufferLength;
        this.notify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event poll() {
        Event event;
        while ((event = this.unshift()) == null) {
            try {
                EventQueue eventQueue = this;
                synchronized (eventQueue) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Event polling thread interrupted.", e);
            }
        }
        return event;
    }

    private synchronized Event unshift() {
        if (this.bufferLength == 0) {
            return null;
        }
        Event event = this.buffer[this.bufferOffset];
        this.bufferOffset = (this.bufferOffset + 1) % 1024;
        --this.bufferLength;
        return event;
    }
}

