/*
 * Decompiled with CFR 0.152.
 */
package threadedevent;

import java.util.Vector;
import threadedevent.Event;
import threadedevent.EventListener;
import threadedevent.EventQueue;

public class EventDispatcher
implements Runnable {
    private boolean runs;
    private EventQueue eventQueue;
    private Vector<EventListener> listeners = new Vector();

    public EventDispatcher(EventQueue eventQueue) {
        this.eventQueue = eventQueue;
    }

    public void addListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    public int countListeners() {
        return this.listeners.size();
    }

    public void start() {
        this.runs = true;
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (this.runs) {
            Event event = this.eventQueue.poll();
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    this.listeners.get(i).handleEvent(event);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.listeners.remove(i);
                    System.out.println("Exception wile processing event. Affected listener removed.");
                }
            }
        }
    }

    public boolean runs() {
        return this.runs;
    }

    public void stop() {
        this.runs = true;
    }
}

