/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.util.stream;

import java.io.InputStream;
import org.czentral.util.stream.StreamBuffer;
import org.czentral.util.stream.StreamProcessor;

public class StreamProcessorFeeder {
    StreamBuffer buffer;
    InputStream input;

    public StreamProcessorFeeder(StreamBuffer buffer, InputStream input) {
        this.buffer = buffer;
        this.input = input;
    }

    public void feedTo(StreamProcessor processor) {
        byte[] data = this.buffer.getData();
        int bytesProcessed = processor.process(data, this.buffer.getOffset(), this.buffer.getLength());
        this.buffer.markProcessed(bytesProcessed);
        while (!processor.finished()) {
            this.buffer.compact();
            try {
                int length = this.buffer.getLength();
                int bytes = this.input.read(data, length, data.length - length);
                if (bytes == -1) {
                    return;
                }
                this.buffer.markAppended(bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            bytesProcessed = processor.process(data, 0, this.buffer.getLength());
            this.buffer.markProcessed(bytesProcessed);
        }
    }
}

