/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.util.stream;

public class StreamBuffer {
    private byte[] data;
    private int offset;
    private int length;

    public StreamBuffer(int size) {
        this.data = new byte[size];
    }

    public void compact() {
        System.arraycopy(this.data, this.offset, this.data, 0, this.length);
        this.offset = 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public void markProcessed(int numOfBytes) {
        if (numOfBytes < 0) {
            throw new RuntimeException("Negative number of bytes is unsupported: " + numOfBytes);
        }
        if (numOfBytes > this.length) {
            throw new RuntimeException("Region too big: " + numOfBytes + " (length is: " + this.length + ").");
        }
        this.length -= numOfBytes;
        this.offset += numOfBytes;
    }

    public void markAppended(int numOfBytes) {
        if (numOfBytes < 0) {
            throw new RuntimeException("Negative number of bytes is unsupported: " + numOfBytes);
        }
        if (numOfBytes > this.data.length - (this.offset + this.length)) {
            throw new RuntimeException("Region too big: " + numOfBytes + " (empty space is: " + (this.data.length - (this.offset + this.length)) + ").");
        }
        this.length += numOfBytes;
    }

    public int getLength() {
        return this.length;
    }
}

