/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.minihttp;

import java.io.IOException;
import java.io.InputStream;

public class PrependedInputStream
extends InputStream {
    private InputStream input;
    private byte[] buffer;
    private int bufferOffset;

    public PrependedInputStream(byte[] data, int offset, int length, InputStream is) {
        this.buffer = new byte[length];
        System.arraycopy(data, offset, this.buffer, 0, length);
        this.bufferOffset = 0;
        this.input = is;
    }

    @Override
    public int read() throws IOException {
        byte[] shortBuffer = new byte[1];
        this.read(shortBuffer, 0, 1);
        return shortBuffer[0];
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        int numBytes = -1;
        if (this.bufferOffset < this.buffer.length) {
            numBytes = Math.min(this.buffer.length - this.bufferOffset, length);
            System.arraycopy(this.buffer, this.bufferOffset, data, offset, numBytes);
            this.bufferOffset += numBytes;
        } else {
            numBytes = this.input.read(data, offset, length);
        }
        return numBytes;
    }
}

