/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.minihttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.czentral.minihttp.HTTPException;
import org.czentral.minihttp.HTTPRequestLoader;
import org.czentral.minihttp.HTTPResource;
import org.czentral.minihttp.HTTPResponse;
import org.czentral.util.stream.StreamBuffer;

public class MiniHTTP
extends Thread {
    protected int port;
    protected Map<String, HTTPResource> resources = new HashMap<String, HTTPResource>();

    public MiniHTTP(int port) {
        this.port = port;
    }

    @Override
    public void run() {
        ServerSocket sock = null;
        try {
            sock = new ServerSocket(this.port);
        }
        catch (IOException e) {
            throw new RuntimeException("MiniHTTP can not listen on given port: " + this.port);
        }
        try {
            while (true) {
                Socket clientSock = sock.accept();
                new Worker(clientSock).start();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error accepting connection on port: " + this.port);
        }
    }

    public void registerResource(String path, HTTPResource resource) {
        if (path.length() > 1 && path.endsWith("/")) {
            throw new RuntimeException("Resource identifiers can not end with / character.");
        }
        this.resources.put(path, resource);
    }

    public void unregisterResource(String path) {
        this.resources.remove(path);
    }

    class Worker
    extends Thread {
        private Socket sock;

        public Worker(Socket sock) {
            this.sock = sock;
        }

        @Override
        public void run() {
            int pos;
            OutputStream os;
            InputStream is;
            try {
                is = this.sock.getInputStream();
                os = this.sock.getOutputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Error opening streams");
            }
            HTTPResponse response = new HTTPResponse(os);
            HTTPRequestLoader request = null;
            request = new HTTPRequestLoader(new StreamBuffer(32768), is);
            request.setRemoteAddress(this.sock.getInetAddress());
            request.setSocket(this.sock);
            HTTPResource resource = null;
            String pathName = request.getPathName();
            while ((resource = MiniHTTP.this.resources.get(pathName)) == null && (pos = pathName.lastIndexOf("/")) != -1) {
                pathName = pathName.substring(0, pos);
            }
            request.setResourcePath(pathName);
            if (resource == null) {
                response.reportException(new HTTPException(404, "Not Found"));
                return;
            }
            request.loadFully();
            try {
                resource.serve(request, response);
            }
            catch (HTTPException e) {
                response.reportException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                response.reportException(new HTTPException(500, "Internal Server Error"));
            }
            try {
                is.close();
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing streams.");
            }
        }
    }
}

