/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.minihttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.czentral.minihttp.HTTPException;
import org.czentral.minihttp.HTTPRequest;
import org.czentral.minihttp.HTTPResource;
import org.czentral.minihttp.HTTPResponse;

public class HTTPZipResource
implements HTTPResource {
    protected ZipFile zip;

    public HTTPZipResource(String fileName) throws ZipException, IOException {
        this.zip = new ZipFile(fileName);
    }

    @Override
    public void serve(HTTPRequest request, HTTPResponse response) throws HTTPException {
        int BUFFER_LENGTH = 16384;
        if (!request.getMethod().equals("GET")) {
            throw new HTTPException(400, "Bad Request");
        }
        String entryName = request.getPathName().substring(request.getResourcePath().length() + 1);
        ZipEntry entry = this.zip.getEntry(entryName);
        if (entry == null) {
            throw new HTTPException(404, "Not Found");
        }
        try {
            int red;
            InputStream is = this.zip.getInputStream(entry);
            byte[] buffer = new byte[16384];
            response.setParameter("X-Powered-By", "HTTPZipResource");
            response.setParameter("Content-length", Long.toString(entry.getSize()));
            OutputStream os = response.getOutputStream();
            while ((red = is.read(buffer)) != -1) {
                os.write(buffer, 0, red);
            }
            is.close();
            os.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

