/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.minihttp;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.czentral.minihttp.HTTPException;

public class HTTPResponse {
    protected OutputStream outputStream;
    protected Map<String, String> parameters = new HashMap<String, String>(10);
    protected int responseCode = 200;
    protected String responseMessage = "OK";
    protected boolean open = true;

    public HTTPResponse(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.parameters.put("Server", "MiniHTTP");
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public OutputStream getOutputStream() {
        this.flushHeaders();
        return this.outputStream;
    }

    protected synchronized void flushHeaders() {
        if (!this.open) {
            return;
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.outputStream));
        writer.println("HTTP/1.1 " + this.responseCode + " " + this.responseMessage);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            writer.println(entry.getKey() + ": " + entry.getValue());
        }
        writer.println();
        writer.flush();
        this.open = false;
    }

    public void reportException(HTTPException e) {
        this.setResponseCode(e.getCode());
        this.setResponseMessage(e.getMessage());
        this.setParameter("Content-type", "text/html");
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.getOutputStream()));
        writer.println("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">");
        writer.println("<http><head><title>" + e.getMessage() + "</title></head><body><h1>" + e.getMessage() + "</h1></body></http>");
        writer.close();
    }
}

