/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.minihttp;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import org.czentral.minihttp.ChunkedInputStream;
import org.czentral.minihttp.HTTPRequest;
import org.czentral.minihttp.MultimapBuilder;
import org.czentral.minihttp.PrependedInputStream;
import org.czentral.util.stream.StreamBuffer;
import org.czentral.util.stream.StreamProcessor;
import org.czentral.util.stream.StreamProcessorFeeder;

class HTTPRequestLoader
implements HTTPRequest {
    private static final int STATE_NOTHING_LOADED = 0;
    private static final int STATE_REQUEST_LINE_LOADED = 1;
    private static final int STATE_REQUEST_HEADERS_LOADED = 2;
    private static final int STATE_GET_VARS_LOADED = 3;
    private static final int STATE_FULLY_LOADED = 1000000;
    private static final String TRANSFER_ENCODING = "Transfer-encoding";
    private static final String TRANSFER_ENCODING_CHUNKED = "chunked";
    private int state = 0;
    private StreamBuffer buffer;
    private InputStream input;
    private InputStream bodyStream;
    private Socket socket;
    private StreamProcessorFeeder feeder;
    private String requestMethod;
    private String requestURI;
    private String requestPath;
    private String queryString;
    private String requestVersion;
    private InetAddress remoteAddress;
    private String resourcePath;
    private Map<String, String[]> requestHeaders;
    private Map<String, String[]> getParams;

    public HTTPRequestLoader(StreamBuffer buffer, InputStream input) {
        this.buffer = buffer;
        this.input = input;
        this.feeder = new StreamProcessorFeeder(buffer, input);
    }

    public void loadFully() {
        this.loadGetVars();
        this.state = 1000000;
    }

    @Override
    public String getMethod() {
        this.loadRequestLine();
        return this.requestMethod;
    }

    @Override
    public String getRequestURI() {
        this.loadRequestLine();
        return this.requestURI;
    }

    @Override
    public String getPathName() {
        this.loadRequestLine();
        return this.requestPath;
    }

    @Override
    public String getQueryString() {
        this.loadRequestLine();
        return this.requestMethod;
    }

    @Override
    public String getVersion() {
        this.loadRequestLine();
        return this.requestMethod;
    }

    @Override
    public String[] getHeaders(String key) {
        this.loadRequestHeaders();
        return this.requestHeaders.get(key.toUpperCase());
    }

    @Override
    public String getHeader(String key) {
        this.loadRequestHeaders();
        String[] values = this.requestHeaders.get(key.toUpperCase());
        if (values == null) {
            return null;
        }
        return values[values.length - 1];
    }

    @Override
    public String[] getParameters(String key) {
        this.loadGetVars();
        return this.getParams.get(key);
    }

    @Override
    public String getParameter(String key) {
        this.loadGetVars();
        String[] values = this.getParams.get(key);
        if (values == null) {
            return null;
        }
        return values[values.length - 1];
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetAddress addr) {
        this.remoteAddress = addr;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public InputStream getInputStream() {
        if (this.bodyStream == null) {
            this.loadFully();
            String transferEncoding = this.getHeader(TRANSFER_ENCODING);
            this.bodyStream = transferEncoding != null && transferEncoding.equals(TRANSFER_ENCODING_CHUNKED) ? new ChunkedInputStream(this.buffer.getData(), this.buffer.getOffset(), this.buffer.getLength(), this.input) : new PrependedInputStream(this.buffer.getData(), this.buffer.getOffset(), this.buffer.getLength(), this.input);
        }
        return this.bodyStream;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String addr) {
        this.resourcePath = addr;
    }

    private void loadRequestLine() {
        if (this.state >= 1) {
            return;
        }
        this.feeder.feedTo(new RequestLineLoader());
        this.state = 1;
    }

    private void loadRequestHeaders() {
        if (this.state >= 2) {
            return;
        }
        this.loadRequestLine();
        RequestHeaderLoader loader = new RequestHeaderLoader();
        this.feeder.feedTo(loader);
        this.requestHeaders = loader.getCompactMap();
        this.state = 2;
    }

    private void loadGetVars() {
        int pos;
        if (this.state >= 3) {
            return;
        }
        this.loadRequestHeaders();
        MultimapBuilder builder = new MultimapBuilder();
        int sPos = 0;
        while ((pos = this.queryString.indexOf(61, sPos)) != -1) {
            String key = this.queryString.substring(sPos, pos);
            sPos = this.queryString.indexOf(38, pos + 1);
            if (sPos == -1) {
                sPos = this.queryString.length();
            }
            String value = this.queryString.substring(pos + 1, sPos);
            ++sPos;
            builder.add(key, value);
        }
        this.getParams = builder.getCompactMap();
        this.state = 3;
    }

    private int arrayIndexOf(byte[] array, int offset, int length, byte value) {
        int endOffset = offset + length;
        while (offset < endOffset) {
            if (array[offset] == value) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    class RequestLineLoader
    extends StreamProcessor {
        boolean finished = false;

        RequestLineLoader() {
        }

        @Override
        public boolean finished() {
            return this.finished;
        }

        @Override
        public int process(byte[] buffer, int offset, int length) {
            int startOffset = offset;
            int pos = HTTPRequestLoader.this.arrayIndexOf(buffer, offset, length, (byte)32);
            if (pos == -1) {
                return 0;
            }
            HTTPRequestLoader.this.requestMethod = new String(buffer, offset, pos - offset);
            length -= pos - offset + 1;
            offset = pos + 1;
            pos = HTTPRequestLoader.this.arrayIndexOf(buffer, offset, length, (byte)32);
            if (pos == -1) {
                return 0;
            }
            HTTPRequestLoader.this.requestURI = new String(buffer, offset, pos - offset);
            int qsPos = HTTPRequestLoader.this.requestURI.indexOf(63);
            if (qsPos != -1) {
                HTTPRequestLoader.this.requestPath = HTTPRequestLoader.this.requestURI.substring(0, qsPos);
                HTTPRequestLoader.this.queryString = HTTPRequestLoader.this.requestURI.substring(qsPos + 1);
            } else {
                HTTPRequestLoader.this.requestPath = HTTPRequestLoader.this.requestURI;
                HTTPRequestLoader.this.queryString = "";
            }
            length -= pos - offset + 1;
            offset = pos + 1;
            pos = HTTPRequestLoader.this.arrayIndexOf(buffer, offset, length, (byte)13);
            if (pos == -1 || pos >= offset + length - 1 || buffer[pos + 1] != 10) {
                return startOffset;
            }
            HTTPRequestLoader.this.requestVersion = new String(buffer, offset, pos - offset);
            this.finished = true;
            return pos + 2 - startOffset;
        }
    }

    class RequestHeaderLoader
    extends StreamProcessor {
        private MultimapBuilder requestHeaders = new MultimapBuilder();
        boolean finished = false;

        RequestHeaderLoader() {
        }

        @Override
        public boolean finished() {
            return this.finished;
        }

        @Override
        public int process(byte[] buffer, int offset, int length) {
            int startOffset = offset;
            int pos = offset;
            do {
                int lineEnd = pos = HTTPRequestLoader.this.arrayIndexOf(buffer, pos, length - (pos - offset), (byte)13);
                if (pos == offset) {
                    this.finished = true;
                } else {
                    if (pos == -1 || pos > offset + length - 3) break;
                    if (buffer[pos + 1] != 10 || buffer[pos + 2] == 32 || buffer[pos + 2] == 9) {
                        ++pos;
                        continue;
                    }
                    pos = HTTPRequestLoader.this.arrayIndexOf(buffer, offset, lineEnd - offset, (byte)58);
                    if (pos != -1) {
                        String key = new String(buffer, offset, pos - offset);
                        String value = new String(buffer, ++pos, lineEnd - pos);
                        this.requestHeaders.add(key.trim().toUpperCase(), value.trim());
                    }
                }
                length -= lineEnd - offset + 2;
                pos = offset = lineEnd + 2;
            } while (!this.finished);
            return offset - startOffset;
        }

        public Map<String, String[]> getCompactMap() {
            return this.requestHeaders.getCompactMap();
        }
    }
}

