/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.minihttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.czentral.minihttp.HTTPException;
import org.czentral.minihttp.HTTPRequest;

public class GeneralHTTPRequest
implements HTTPRequest {
    protected String method;
    protected String version;
    protected String URI;
    protected String queryString;
    protected String pathName;
    protected Map<String, String> parameters = new HashMap<String, String>(20);
    protected Map<String, String> headerFields = new HashMap<String, String>(20);
    protected String resourcePath;
    protected InetAddress remoteAddress;

    protected GeneralHTTPRequest() {
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getPathName() {
        return this.pathName;
    }

    @Override
    public String getRequestURI() {
        return this.URI;
    }

    @Override
    public String[] getHeaders(String key) {
        throw new Error("Unsupported");
    }

    @Override
    public String getHeader(String key) {
        return this.headerFields.get(key);
    }

    @Override
    public String[] getParameters(String key) {
        throw new Error("Unsupported");
    }

    @Override
    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setRemoteAddress(InetAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InputStream getInputStream() {
        throw new Error("Unsupported");
    }

    @Override
    public Socket getSocket() {
        throw new Error("Unsupported");
    }

    public static HTTPRequest load(InputStream is) throws HTTPException {
        GeneralHTTPRequest request = new GeneralHTTPRequest();
        try {
            String line;
            String version;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
            String requestLine = reader.readLine();
            Pattern requestPattern = Pattern.compile("([^ ]+) ([^ ]+) ([^ ]+)");
            Matcher matcher = requestPattern.matcher(requestLine);
            matcher.find();
            if (matcher.groupCount() != 3) {
                throw new HTTPException(400, "Bad Request");
            }
            String method = matcher.group(1);
            String url = matcher.group(2);
            request.version = version = matcher.group(3);
            request.URI = url;
            request.method = method;
            if (!url.startsWith("/")) {
                throw new HTTPException(400, "Bad Request");
            }
            Pattern paramPattern = Pattern.compile("([^:]+):[ ]?.+");
            while ((line = reader.readLine()).length() > 0) {
                Matcher m = paramPattern.matcher(line);
                m.find();
                if (m.groupCount() != 2) continue;
                request.headerFields.put(m.group(1), m.group(2));
            }
            int queryPos = url.indexOf("?");
            if (queryPos != -1) {
                request.queryString = url.substring(queryPos + 1);
                request.pathName = url.substring(0, queryPos);
            } else {
                request.pathName = url;
            }
            if (request.queryString != null) {
                Pattern qsPattern = Pattern.compile("([^=]+)=([^&]+)[&]?");
                Matcher qsMatcher = qsPattern.matcher(request.queryString);
                while (qsMatcher.find()) {
                    request.parameters.put(qsMatcher.group(1), qsMatcher.group(2));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return request;
    }
}

