/*
 * Decompiled with CFR 0.152.
 */
package org.czentral.minihttp;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final int BUFFER_SIZE = 32768;
    private final int CHUNK_HEAD_MAX_SIZE = 10;
    private InputStream input;
    private byte[] buffer = new byte[32768];
    private int bufferOffset;
    private int bufferLength;
    private int chunkLength;

    public ChunkedInputStream(byte[] data, int offset, int length, InputStream is) {
        System.arraycopy(data, offset, this.buffer, 0, length);
        this.bufferLength = length;
        this.chunkLength = 0;
        this.input = is;
    }

    @Override
    public int read() throws IOException {
        byte[] shortBuffer = new byte[1];
        this.read(shortBuffer, 0, 1);
        return shortBuffer[0];
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        int segLength;
        int numBytes;
        if (this.chunkLength == 0) {
            int headLength = this.refreshChunkSize(this.buffer, this.bufferOffset, this.bufferLength);
            while (headLength == -1) {
                numBytes = this.input.read(this.buffer, this.bufferOffset + this.bufferLength, 10);
                if (numBytes == -1) {
                    return -1;
                }
                this.bufferLength += numBytes;
                headLength = this.refreshChunkSize(this.buffer, this.bufferOffset, this.bufferLength);
            }
            this.bufferOffset += headLength;
            this.bufferLength -= headLength;
            if (this.bufferLength == 0) {
                this.bufferOffset = 0;
            }
        }
        if (this.bufferLength > 0) {
            segLength = Math.min(Math.min(this.chunkLength, this.bufferLength), length);
            System.arraycopy(this.buffer, this.bufferOffset, data, offset, segLength);
            this.bufferOffset += segLength;
            this.bufferLength -= segLength;
            if (this.bufferLength == 0) {
                this.bufferOffset = 0;
            }
            this.chunkLength -= segLength;
            return segLength;
        }
        segLength = Math.min(this.chunkLength, length);
        numBytes = this.input.read(data, offset, segLength);
        this.chunkLength -= numBytes;
        return numBytes;
    }

    private int refreshChunkSize(byte[] data, int offset, int length) {
        int endOffset = offset + length;
        for (int i = offset; i < endOffset - 1; ++i) {
            int size;
            if (data[i] != 13 || data[i + 1] != 10) continue;
            if (i == offset) {
                return 2;
            }
            this.chunkLength = size = Integer.parseInt(new String(data, offset, i - offset), 16);
            return i - offset + 2;
        }
        return -1;
    }
}

