/*
 * Decompiled with CFR 0.152.
 */
class StreamingState
implements StreamInputState {
    private static final long ID_CLUSTER = 524531317L;
    private static final long ID_SIMPLEBLOCK = 163L;
    private static final long ID_BLOCKGROUP = 160L;
    private static final long ID_TIMECODE = 231L;
    private static final long MINIMAL_FRAGMENT_LENGTH = 102400L;
    private long clusterTimeCode = 0L;
    private StreamInput input;
    private Stream stream;
    private long videoTrackNumber;
    private MovieFragment fragment;

    public StreamingState(StreamInput input, Stream stream, long videoTrackNumber) {
        this.input = input;
        this.stream = stream;
        this.videoTrackNumber = videoTrackNumber;
        this.fragment = new MovieFragment();
    }

    @Override
    public int processData(byte[] buffer, int offset, int length) {
        int endOffset = offset + length;
        while (offset < endOffset - 12) {
            EBMLElement elem = new EBMLElement(buffer, offset, length);
            if (elem.getId() != 524531317L && elem.getEndOffset() > endOffset) {
                return elem.getElementOffset();
            }
            if (elem.getId() == 231L) {
                this.clusterTimeCode = EBMLElement.loadUnsigned(buffer, elem.getDataOffset(), (int)elem.getDataSize());
                this.fragment.openCluster(this.clusterTimeCode);
            } else if (elem.getId() == 163L) {
                int flags;
                int trackNum = buffer[elem.getDataOffset()] & 0xFF;
                if ((trackNum & 0x80) == 0) {
                    throw new RuntimeException("Track numbers > 127 are not implemented.");
                }
                int videoKeyOffset = -1;
                if ((long)(trackNum ^= 0x80) == this.videoTrackNumber && ((flags = buffer[elem.getDataOffset() + 3] & 0xFF) & 0x80) != 0 && (long)this.fragment.length() >= 102400L) {
                    this.fragment.closeCluster();
                    this.stream.pushFragment(this.fragment);
                    this.fragment = new MovieFragment();
                    this.fragment.openCluster(this.clusterTimeCode);
                    this.stream.postEvent(new ServerEvent((Object)this.input, this.stream, 3));
                    if ((flags & 0x60) == 0) {
                        videoKeyOffset = elem.getDataOffset() + 4;
                    } else {
                        throw new RuntimeException("Lacing is not yet supported.");
                    }
                }
                this.fragment.appendKeyBlock(buffer, elem.getElementOffset(), elem.getElementSize(), videoKeyOffset);
            } else if (elem.getId() == 160L) {
                this.fragment.appendBlock(buffer, elem.getElementOffset(), elem.getElementSize());
            }
            if (elem.getId() == 524531317L || elem.getDataSize() >= 0x100000000L) {
                offset = elem.getDataOffset();
                continue;
            }
            offset = elem.getEndOffset();
        }
        return offset;
    }
}

