/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.czentral.minihttp.HTTPException;
import org.czentral.minihttp.HTTPRequest;
import org.czentral.minihttp.HTTPResource;
import org.czentral.minihttp.HTTPResponse;
import org.czentral.minihttp.HTTPZipResource;
import org.czentral.minihttp.MiniHTTP;
import threadedevent.EventDispatcher;

class StreamingServer {
    private static Map<String, String> settings = new HashMap<String, String>(20);
    private static Map<String, ControlledStream> streams = new HashMap<String, ControlledStream>();

    StreamingServer() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: java StreamingServer <configfile>");
            System.exit(1);
        }
        try {
            String line;
            String filename = args[0];
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                int pos = line.indexOf("=");
                if (pos == -1) {
                    throw new RuntimeException("Config lines must vahe a <key> = <value> syntax.");
                }
                settings.put(line.substring(0, pos).trim(), line.substring(pos + 1).trim());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        new StreamingServer().run();
    }

    private static void loadConfig(String filename) {
    }

    public void run() {
        String serverPort = settings.get("server.port");
        System.out.println("Stating server on port: " + serverPort);
        MiniHTTP server = new MiniHTTP(Integer.parseInt(serverPort));
        PublisherResource publish = new PublisherResource();
        server.registerResource("/publish", publish);
        ConsumerResource consume = new ConsumerResource();
        server.registerResource("/consume", consume);
        SnapshotResource snapshot = new SnapshotResource();
        server.registerResource("/snapshot", snapshot);
        InfoResource info = new InfoResource();
        server.registerResource("/info", info);
        try {
            HTTPZipResource console = new HTTPZipResource("console.zip");
            server.registerResource("/console", console);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        server.start();
    }

    class FileResource
    implements HTTPResource {
        private String fileName;

        public FileResource(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public void serve(HTTPRequest request, HTTPResponse response) throws HTTPException {
            try {
                File headFile = new File(this.fileName);
                FileInputStream fis = new FileInputStream(headFile);
                byte[] data = new byte[(int)headFile.length()];
                fis.read(data, 0, data.length);
                fis.close();
                response.getOutputStream().write(data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    class InfoResource
    implements HTTPResource {
        private final String STR_CONTENT_TYPE = "Content-type";

        InfoResource() {
        }

        @Override
        public void serve(HTTPRequest request, HTTPResponse response) throws HTTPException {
            System.out.println(0);
            int resLength = request.getResourcePath().length();
            String requestPath = request.getPathName();
            if (requestPath.length() - resLength <= 1) {
                throw new HTTPException(400, "No Stream ID Specified");
            }
            String streamID = requestPath.substring(resLength + 1);
            if (settings.get("streams." + streamID) == null) {
                throw new HTTPException(404, "Stream Not Registered");
            }
            String requestPassword = request.getParameter("password");
            if (requestPassword == null) {
                throw new HTTPException(403, "Authentication failed: No password");
            }
            if (!requestPassword.equals(settings.get("streams." + streamID + ".password"))) {
                throw new HTTPException(403, "Authentication failed: Wrong password");
            }
            ControlledStream stream = (ControlledStream)streams.get(streamID);
            if (stream == null || !stream.running()) {
                throw new HTTPException(503, "Stream Not Running");
            }
            response.setParameter("Content-type", "text/plain");
            System.out.println(1);
            EventDispatcher dispatcher = stream.getEventDispatcher();
            System.out.println(2);
            EventAnalizer analizer = new EventAnalizer(stream, dispatcher, response.getOutputStream());
            analizer.run();
        }
    }

    class SnapshotResource
    implements HTTPResource {
        private final String STR_CONTENT_TYPE = "Content-type";

        SnapshotResource() {
        }

        @Override
        public void serve(HTTPRequest request, HTTPResponse response) throws HTTPException {
            int num;
            int resLength = request.getResourcePath().length();
            String requestPath = request.getPathName();
            if (requestPath.length() - resLength <= 1) {
                throw new HTTPException(400, "No Stream ID Specified");
            }
            String streamID = requestPath.substring(resLength + 1);
            if (settings.get("streams." + streamID) == null) {
                throw new HTTPException(404, "Stream Not Registered");
            }
            ControlledStream stream = (ControlledStream)streams.get(streamID);
            if (stream == null || !stream.running()) {
                throw new HTTPException(503, "Stream Not Running");
            }
            response.setParameter("Content-type", "image/webp");
            MovieFragment fragment = stream.getFragment();
            if (fragment == null) {
                throw new HTTPException(404, "No Fragment Found");
            }
            if (fragment.getKeyframeLength() < 0) {
                throw new HTTPException(404, "No Keyframe Found");
            }
            byte[] header = new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 69, 66, 80, 86, 80, 56, 32, 0, 0, 0, 0};
            int offset = 7;
            for (num = fragment.getKeyframeLength() + 12; num > 0; num >>= 8) {
                header[offset--] = (byte)num;
            }
            offset = 19;
            for (num = fragment.getKeyframeLength(); num > 0; num >>= 8) {
                header[offset--] = (byte)num;
            }
            try {
                response.getOutputStream().write(header, 0, header.length);
                response.getOutputStream().write(fragment.getData(), fragment.getKeyframeOffset(), fragment.getKeyframeLength());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    class ConsumerResource
    implements HTTPResource {
        private final String STR_CONTENT_TYPE = "Content-type";

        ConsumerResource() {
        }

        @Override
        public void serve(HTTPRequest request, HTTPResponse response) throws HTTPException {
            int resLength = request.getResourcePath().length();
            String requestPath = request.getPathName();
            if (requestPath.length() - resLength <= 1) {
                throw new HTTPException(400, "No Stream ID Specified");
            }
            String streamID = requestPath.substring(resLength + 1);
            if (settings.get("streams." + streamID) == null) {
                throw new HTTPException(404, "Stream Not Registered");
            }
            ControlledStream stream = (ControlledStream)streams.get(streamID);
            if (stream == null || !stream.running()) {
                throw new HTTPException(503, "Stream Not Running");
            }
            if (!stream.subscribe(false)) {
                throw new HTTPException(503, "Resource Busy");
            }
            response.setParameter("Content-type", "video/webm");
            StreamClient client = new StreamClient(stream, response.getOutputStream());
            client.run();
            stream.unsubscribe();
        }
    }

    class PublisherResource
    implements HTTPResource {
        PublisherResource() {
        }

        @Override
        public void serve(HTTPRequest request, HTTPResponse response) throws HTTPException {
            int resLength = request.getResourcePath().length();
            String requestPath = request.getPathName();
            if (requestPath.length() - resLength <= 1) {
                throw new HTTPException(404, "No Stream ID Specified");
            }
            String streamID = requestPath.substring(resLength + 1);
            if (settings.get("streams." + streamID) == null) {
                throw new HTTPException(403, "Stream Not Registered");
            }
            String requestPassword = request.getParameter("password");
            if (requestPassword == null) {
                throw new HTTPException(403, "Authentication failed: No password");
            }
            if (!requestPassword.equals(settings.get("streams." + streamID + ".password"))) {
                throw new HTTPException(403, "Authentication failed: Wrong password");
            }
            ControlledStream stream = (ControlledStream)streams.get(streamID);
            if (stream != null) {
                stream.stop();
            }
            stream = new ControlledStream(Integer.parseInt((String)settings.get("streams." + streamID + ".limit")));
            streams.put(streamID, stream);
            Socket sock = request.getSocket();
            try {
                sock.setSoTimeout(100);
                sock.setReceiveBufferSize(262144);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot set socket parameters", e);
            }
            StreamInput streamInput = new StreamInput(stream, request.getInputStream());
            streamInput.run();
            stream.stop();
        }
    }
}

