/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Date;

class StreamInput {
    private Stream stream;
    private InputStream input;
    private boolean runs;
    private byte[] header;
    private StreamInputState currentState;

    public StreamInput(Stream stream, InputStream input) {
        this.stream = stream;
        this.input = input;
    }

    public void run() {
        this.runs = true;
        this.stream.postEvent(new ServerEvent((Object)this, this.stream, 1));
        this.changeState(new HeaderDetectionState(this, this.stream));
        byte[] buffer = new byte[65535];
        int offset = 0;
        int length = 0;
        while (this.runs && this.stream.running()) {
            try {
                int newOffset;
                long transferStart = new Date().getTime();
                int numBytes = this.input.read(buffer, offset, buffer.length - offset);
                this.stream.postEvent(new TransferEvent(this, this.stream, 1, numBytes, new Date().getTime() - transferStart));
                if (numBytes == -1) {
                    this.runs = false;
                }
                if ((newOffset = this.currentState.processData(buffer, 0, length += numBytes)) < offset + length) {
                    System.arraycopy(buffer, newOffset, buffer, 0, length -= newOffset);
                    offset = length;
                    continue;
                }
                length = 0;
                offset = 0;
            }
            catch (SocketTimeoutException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
                this.runs = false;
            }
        }
        try {
            this.input.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.stream.postEvent(new ServerEvent((Object)this, this.stream, 2));
    }

    public void changeState(StreamInputState newState) {
        this.currentState = newState;
    }
}

