/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import java.util.Date;

class StreamClient {
    private Stream stream;
    private OutputStream output;
    private boolean runs = true;
    private long offset = 0L;
    private int fragmentSequence = 1;

    public StreamClient(Stream stream, OutputStream output) {
        this.stream = stream;
        this.output = output;
    }

    public void run() {
        this.stream.postEvent(new ServerEvent((Object)this, this.stream, 1001));
        byte[] header = this.stream.getHeader();
        while (header == null && this.stream.running()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                // empty catch block
            }
            header = this.stream.getHeader();
        }
        try {
            this.output.write(header);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        int myAge = 0;
        while (this.runs && this.stream.running()) {
            int streamAge;
            while (this.runs && this.stream.running() && myAge < (streamAge = this.stream.getFragmentAge())) {
                if (myAge > 0 && streamAge - myAge > 1) {
                    this.stream.postEvent(new ServerEvent((Object)this, this.stream, 1005));
                }
                myAge = streamAge;
                MovieFragment fragment = this.stream.getFragment();
                try {
                    int length;
                    int PACKET_SIZE = 24576;
                    int fragLength = fragment.length();
                    for (int offset = 0; offset < fragLength; offset += length) {
                        length = fragLength - offset;
                        if ((double)length >= 36864.0) {
                            length = 24576;
                        }
                        long transferStart = new Date().getTime();
                        this.output.write(fragment.getData(), offset, length);
                        this.stream.postEvent(new TransferEvent(this, this.stream, 2, length, new Date().getTime() - transferStart));
                    }
                }
                catch (Exception e) {
                    this.runs = false;
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {}
        }
        this.stream.postEvent(new ServerEvent((Object)this, this.stream, 1002));
        try {
            this.output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

