/*
 * Decompiled with CFR 0.152.
 */
class MovieFragment {
    private final int INITIAL_CLUSTER_LENGTH = 10;
    private final int TIMECODE_LAST_OFFSET = 18;
    private final int CLUSTER_LENGTH_LAST_OFFSET = 8;
    private final byte[] clusterHead = new byte[]{31, 67, -74, 117, 8, 0, 0, 0, 0, -25, -120, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] data = new byte[0x100000];
    private int dataLength = 0;
    private int clusterOffset = -1;
    private int keyframeOffset = -1;
    private int keyframeLength = -1;

    public void openCluster(long timeCode) {
        if (this.clusterOffset != -1) {
            this.closeCluster();
        }
        System.arraycopy(this.clusterHead, 0, this.data, this.dataLength, this.clusterHead.length);
        this.clusterOffset = this.dataLength;
        this.dataLength += this.clusterHead.length;
        int offset = this.clusterOffset + 18;
        for (long num = timeCode; num > 0L; num >>= 8) {
            this.data[offset--] = (byte)num;
        }
    }

    public void closeCluster() {
        if (this.clusterOffset == -1) {
            throw new RuntimeException("No open cluster.");
        }
        int clusterLength = this.dataLength - this.clusterOffset - 10;
        int offset = this.clusterOffset + 8;
        for (int num = clusterLength; num > 0; num >>= 8) {
            this.data[offset--] = (byte)num;
        }
        this.clusterOffset = -1;
    }

    public void appendKeyBlock(byte[] buffer, int offset, int length, int keyframeOffset) {
        if (keyframeOffset > 0) {
            this.keyframeOffset = this.dataLength + (keyframeOffset - offset);
            this.keyframeLength = length - (keyframeOffset - offset);
        }
        this.appendBlock(buffer, offset, length);
    }

    public void appendBlock(byte[] buffer, int offset, int length) {
        if (this.data.length < this.dataLength + length) {
            throw new RuntimeException("Buffer full");
        }
        System.arraycopy(buffer, offset, this.data, this.dataLength, length);
        this.dataLength += length;
    }

    public byte[] getData() {
        return this.data;
    }

    public int length() {
        return this.dataLength;
    }

    public int getKeyframeOffset() {
        return this.keyframeOffset;
    }

    public int getKeyframeLength() {
        return this.keyframeLength;
    }
}

