/*
 * Decompiled with CFR 0.152.
 */
class Log {
    Log() {
    }

    public static void displaySegment(byte[] buffer, int offset, int maxLength) {
        int i;
        int DISPLAY_MAX_LENGTH = 48;
        String s = "(" + maxLength + ")";
        for (i = 0; i < Math.min(48, maxLength); ++i) {
            String digit = new String("0" + Integer.toHexString(buffer[offset + i] & 0xFF));
            s = s + " " + digit.substring(digit.length() - 2);
        }
        s = s + "  ";
        for (i = 0; i < Math.min(48, maxLength); ++i) {
            int num = buffer[offset + i] & 0xFF;
            s = s + (char)(num > 13 ? (int)num : 46);
        }
        if (maxLength > 48) {
            s = s + "  >>";
        }
        System.out.println(s);
    }

    public static void reportChunk(byte[] buffer, int offset, int length) {
        int endOffset = offset + length;
        for (int i = offset; i < endOffset - 4; ++i) {
            if (buffer[i] != 0 || buffer[i + 1] != 1) continue;
            offset = i + 2;
            break;
        }
        while (offset <= endOffset - 4) {
            int startOffset = offset;
            for (int i = offset; i < endOffset - 4; ++i) {
                if (buffer[i + 3] != 1 || buffer[i] != 0 || buffer[i + 1] != 0 || buffer[i + 2] != 0) continue;
                offset = i;
                break;
            }
            if (offset == startOffset) {
                Log.displaySegment(buffer, startOffset, endOffset - startOffset);
                offset = endOffset;
            } else {
                Log.displaySegment(buffer, startOffset, offset - startOffset);
            }
            offset += 4;
        }
    }

    public static void displayTime(long time) {
        float sec = (float)time / 90000.0f;
        String s = "" + sec % 60.0f;
        s = (long)(sec /= 60.0f) % 60L + ":" + s;
        s = (long)(sec /= 60.0f) + ":" + s;
        System.out.println(s);
    }
}

