/*
 * Decompiled with CFR 0.152.
 */
class HeaderDetectionState
implements StreamInputState {
    private static final long ID_EBML = 440786851L;
    private static final long ID_SEGMENT = 408125543L;
    private static final long ID_INFO = 357149030L;
    private static final long ID_TRACKS = 374648427L;
    private static final long ID_TRACKTYPE = 131L;
    private static final long ID_TRACKNUMBER = 215L;
    private static final long TRACK_TYPE_VIDEO = 1L;
    private StreamInput input;
    private Stream stream;
    private static final byte[] infiniteSegment = new byte[]{24, 83, -128, 103, 1, -1, -1, -1, -1, -1, -1, -1};

    public HeaderDetectionState(StreamInput input, Stream stream) {
        this.input = input;
        this.stream = stream;
    }

    @Override
    public int processData(byte[] buffer, int offset, int length) {
        int segmentDataOffset;
        int startOffset = offset;
        int endOffset = offset + length;
        byte[] headerBuffer = new byte[65536];
        int headerLength = 0;
        EBMLElement elem = new EBMLElement(buffer, offset, length);
        if (elem.getId() != 440786851L) {
            throw new RuntimeException("First element is not EBML!");
        }
        System.arraycopy(buffer, elem.getElementOffset(), headerBuffer, headerLength, elem.getElementSize());
        offset = elem.getEndOffset();
        System.arraycopy(infiniteSegment, 0, headerBuffer, headerLength += elem.getElementSize(), infiniteSegment.length);
        headerLength += infiniteSegment.length;
        while ((elem = new EBMLElement(buffer, offset, length)).getId() != 408125543L && (offset = elem.getEndOffset()) < endOffset) {
        }
        if (offset >= endOffset) {
            return startOffset;
        }
        System.out.println("Segment found");
        offset = segmentDataOffset = elem.getDataOffset();
        while ((offset = (elem = new EBMLElement(buffer, offset, length)).getEndOffset()) < endOffset && elem.getId() != 357149030L) {
        }
        if (offset >= endOffset) {
            return startOffset;
        }
        System.out.println("Info found");
        System.arraycopy(buffer, elem.getElementOffset(), headerBuffer, headerLength, elem.getElementSize());
        headerLength += elem.getElementSize();
        offset = segmentDataOffset;
        while ((offset = (elem = new EBMLElement(buffer, offset, length)).getEndOffset()) < endOffset && elem.getId() != 374648427L) {
        }
        if (offset >= endOffset) {
            return startOffset;
        }
        System.out.println("Tracks found");
        System.arraycopy(buffer, elem.getElementOffset(), headerBuffer, headerLength, elem.getElementSize());
        headerLength += elem.getElementSize();
        long videoTrackNumber = 0L;
        int endOfTracks = elem.getEndOffset();
        offset = elem.getDataOffset();
        while (offset < endOfTracks) {
            EBMLElement track = new EBMLElement(buffer, offset, endOfTracks - offset);
            offset = track.getDataOffset();
            int endOfTrack = track.getEndOffset();
            long trackType = 0L;
            long trackNumber = 0L;
            while (offset < endOfTrack) {
                EBMLElement property = new EBMLElement(buffer, offset, endOfTrack - offset);
                if (property.getId() == 131L) {
                    trackType = buffer[property.getDataOffset()] & 0xFF;
                } else if (property.getId() == 215L) {
                    trackNumber = EBMLElement.loadUnsigned(buffer, property.getDataOffset(), (int)property.getDataSize());
                }
                offset = property.getEndOffset();
            }
            System.out.println("track no: " + trackNumber + ", type: " + trackType);
            if (trackType == 1L) {
                videoTrackNumber = trackNumber;
            }
            offset = track.getEndOffset();
        }
        System.out.println("ALL'S WELL");
        byte[] header = new byte[headerLength];
        System.arraycopy(headerBuffer, 0, header, 0, headerLength);
        this.stream.setHeader(header);
        this.input.changeState(new StreamingState(this.input, this.stream, videoTrackNumber));
        return segmentDataOffset;
    }
}

