/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import java.util.Date;
import threadedevent.Event;
import threadedevent.EventDispatcher;
import threadedevent.EventListener;

public class EventAnalizer
implements EventListener {
    private Stream stream;
    private EventDispatcher dispatcher;
    private OutputStream output;
    private boolean runs;
    private TransferAnalizer[] transfers = new TransferAnalizer[10];

    public EventAnalizer(Stream stream, EventDispatcher dispatcher, OutputStream os) {
        this.stream = stream;
        this.dispatcher = dispatcher;
        this.output = os;
    }

    @Override
    public void handleEvent(Event event) {
        if (event instanceof TransferEvent) {
            TransferEvent tEvent = (TransferEvent)event;
            int type = tEvent.getType();
            if (type >= this.transfers.length) {
                return;
            }
            TransferAnalizer analizer = this.transfers[type];
            if (analizer == null) {
                this.transfers[type] = analizer = new TransferAnalizer(type);
            }
            analizer.processTransfer(tEvent);
        } else {
            try {
                this.output.write(event.toString().getBytes());
                this.output.flush();
            }
            catch (Exception e) {
                this.runs = false;
            }
        }
    }

    public void run() {
        this.syncTime();
        this.dispatcher.addListener(this);
        this.runs = true;
        while (this.runs && this.stream.running()) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
        }
        this.dispatcher.removeListener(this);
    }

    private void syncTime() {
        StringBuffer sb = new StringBuffer(30);
        sb.append("{cls:3,time:");
        sb.append(new Date().getTime());
        sb.append("},");
        try {
            this.output.write(sb.toString().getBytes());
            this.output.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class TransferAnalizer {
        private int id;
        private int[] transfer = new int[40];
        private int transferOffset = 0;
        private long transferTime = 0L;

        public TransferAnalizer(int id) {
            this.id = id;
        }

        public void processTransfer(TransferEvent event) {
            long eventTime = event.getDate().getTime() / 100L;
            if (this.transferTime == 0L) {
                this.transferTime = eventTime;
            }
            int flushLength = Math.min((int)(eventTime - this.transferTime), this.transfer.length);
            for (int i = 1; i <= flushLength; ++i) {
                int idx = (this.transferOffset + i) % this.transfer.length;
                this.sendData((this.transferTime - 40L + (long)i) * 100L, this.transfer[idx]);
                this.transfer[idx] = 0;
            }
            this.transferOffset = (this.transferOffset + flushLength) % this.transfer.length;
            this.transferTime = eventTime;
            int eventDuration = Math.max((int)(event.getDuration() / 100L), 1);
            int graphicDuration = Math.min(eventDuration, this.transfer.length);
            int startOffset = (this.transferOffset - (graphicDuration - 1) + this.transfer.length) % this.transfer.length;
            int avgValue = event.getBytes() / graphicDuration;
            for (int i = 0; i < graphicDuration; ++i) {
                int n = (startOffset + i + this.transfer.length) % this.transfer.length;
                this.transfer[n] = this.transfer[n] + avgValue;
            }
        }

        private void sendData(long time, int value) {
            StringBuffer sb = new StringBuffer(30);
            sb.append("{cls:2,type:");
            sb.append(this.id);
            sb.append(",time:");
            sb.append(time);
            sb.append(",bytes:");
            sb.append(value);
            sb.append("},");
            try {
                EventAnalizer.this.output.write(sb.toString().getBytes());
                EventAnalizer.this.output.flush();
            }
            catch (Exception e) {
                EventAnalizer.this.runs = false;
            }
        }
    }
}

