/*
 * Decompiled with CFR 0.152.
 */
class EBMLElement {
    private long id;
    private long size;
    private byte[] buffer;
    private int offset;
    private int dataOffset;

    protected EBMLElement(byte[] buffer, int offset, int length) {
        long sizeFlag;
        this.buffer = buffer;
        this.offset = offset;
        long num = 0L;
        for (sizeFlag = 128L; ((num |= (long)(buffer[offset++] & 0xFF)) & sizeFlag) == 0L && sizeFlag != 0L; sizeFlag <<= 7) {
            num <<= 8;
        }
        this.id = num;
        num = 0L;
        for (sizeFlag = 128L; ((num |= (long)(buffer[offset++] & 0xFF)) & sizeFlag) == 0L && sizeFlag != 0L; sizeFlag <<= 7) {
            num <<= 8;
        }
        this.size = num ^ sizeFlag;
        this.dataOffset = offset;
    }

    public static long loadUnsigned(byte[] buffer, int offset, int length) {
        long num = 0L;
        while (length > 0) {
            --length;
            num <<= 8;
            num |= (long)(buffer[offset++] & 0xFF);
        }
        return num;
    }

    public static long loadEBMLUnsigned(byte[] buffer, int offset, int length) {
        long sizeFlag;
        long num = 0L;
        for (sizeFlag = 128L; ((num |= (long)(buffer[offset++] & 0xFF)) & sizeFlag) == 0L && sizeFlag != 0L; sizeFlag <<= 7) {
            num <<= 8;
        }
        return num ^ sizeFlag;
    }

    public static long loadEBMLSigned(byte[] buffer, int offset, int length) {
        long negBits = -128L;
        long sizeFlag = 128L;
        long num = 0L;
        while (((num |= (long)(buffer[offset++] & 0xFF)) & sizeFlag) == 0L && sizeFlag != 0L) {
            num <<= 8;
            sizeFlag <<= 7;
            negBits <<= 7;
        }
        if ((num & sizeFlag >> 1) != 0L) {
            num |= negBits;
        }
        return num;
    }

    public long getId() {
        return this.id;
    }

    public long getDataSize() {
        return this.size;
    }

    public int getElementSize() {
        if (this.size == 0x1FFFFFFFFFFFFFFL) {
            return -1;
        }
        if (this.size >= 0x100000000L) {
            throw new RuntimeException("Element too long to get array offset.");
        }
        return (int)((long)(this.dataOffset - this.offset) + this.size);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public int getEndOffset() {
        if (this.size == 0x1FFFFFFFFFFFFFFL) {
            return -1;
        }
        if ((long)this.dataOffset + this.size >= 0x100000000L) {
            throw new RuntimeException("Element too long to get array offset.");
        }
        return (int)((long)this.dataOffset + this.size);
    }

    public String toString() {
        return "EBMLElement ID:0x" + Long.toHexString(this.id) + " size: " + this.size;
    }
}

