/*
 * Decompiled with CFR 0.152.
 */
import threadedevent.EventDispatcher;
import threadedevent.EventQueue;

public class ControlledStream
extends Stream {
    private int maxClients;
    private int numClients;
    private EventDispatcher dispatcher;

    public ControlledStream(int maxClients) {
        this.maxClients = maxClients;
    }

    public boolean subscribe(boolean force) {
        if (force || this.numClients < this.maxClients) {
            ++this.numClients;
            this.refresStatus();
            return true;
        }
        return false;
    }

    public void unsubscribe() {
        --this.numClients;
        this.refresStatus();
    }

    protected void refresStatus() {
        ServerStatusEvent event = new ServerStatusEvent(this);
        event.setClientCount(this.numClients);
        this.postEvent(event);
    }

    public EventDispatcher getEventDispatcher() {
        if (this.dispatcher == null) {
            this.bindDispatcher();
        }
        return this.dispatcher;
    }

    private synchronized void bindDispatcher() {
        if (this.dispatcher != null) {
            throw new RuntimeException("Listener already bound.");
        }
        EventQueue queue = new EventQueue();
        this.dispatcher = new EventDispatcher(queue);
        this.setEventQueue(queue);
        this.dispatcher.start();
    }
}

