#!/usr/bin/env python
# -*- coding: cp932 -*-

from __future__ import print_function, unicode_literals
from ctypes import *
from bregonig import *
import sys
import io
import locale

nerror = 0
nsucc = 0
nfail = 0

encoding = "CP932"

class strptr:
    """a helper class to get a pointer to a string"""
    def __init__(self, s):
        if not isinstance(s, bytes):
            raise TypeError
        self._str = s
        try:
            self._ptr = cast(self._str, c_void_p)   # CPython 2.x/3.x
        except TypeError:
            self._ptr = c_void_p(self._str)         # PyPy 1.x

    def getptr(self, offset=0):
        if offset == -1:    # -1 means the end of the string
            offset = len(self._str)
        elif offset > len(self._str):
            raise IndexError
        return self._ptr.value + offset

def cc_to_cb(s, enc, cc):
    """convert char count to byte count
    
    arguments:
      s -- unicode string
      enc -- encoding name
      cc -- char count
    """
    s = s.encode('UTF-32LE')
    clen = cc * 4
    if clen > len(s):
        raise IndexError
    return len(s[:clen].decode('UTF-32LE').encode(enc))

def print_result(result, pattern, file=None):
    if not file:
        file = sys.stdout
    print(result + ": ", end='', file=file)
    try:
        print(pattern, file=file)
    except UnicodeEncodeError as e:
        print('(' + str(e) + ')')

def xx(pattern, target, s_from, s_to, mem, not_match):
    global nerror
    global nsucc
    global nfail
    
    rxp = POINTER(BREGEXP)()
    msg = create_tchar_buffer(BREGEXP_MAX_ERROR_MESSAGE_LEN)
    
    pattern2 = pattern
    if not isinstance(pattern, bytes):
        pattern2 = pattern.encode(encoding)
    pattern3 = "/".encode(encoding) + pattern2 + "/k".encode(encoding)
    
    target2 = target
    if not isinstance(target, bytes):
        s_from = cc_to_cb(target, encoding, s_from)
        s_to = cc_to_cb(target, encoding, s_to)
        target2 = target.encode(encoding)
    tp = strptr(target2)
    
    if encoding == "UTF-8":
        option = "8"
    else:
        option = "k"
    option = option.encode(encoding)
    
    if encoding == "UTF-16LE":
        pattern2 = pattern2.decode(encoding)
        pattern3 = pattern3.decode(encoding)
        option = option.decode(encoding)
    
    try:
        r = BoMatch(pattern2, option, tp.getptr(), tp.getptr(), tp.getptr(-1),
                False, byref(rxp), msg)
    except RuntimeError:
        r = BMatch(pattern3, tp.getptr(), tp.getptr(-1), byref(rxp), msg)
    
    if r < 0:
        nerror += 1
        print_result("ERROR", "%s (/%s/ '%s')" % (msg.value, pattern, target),
                file=sys.stderr)
        return
    
    if r == 0:
        if not_match:
            nsucc += 1
            print_result("OK(N)", "/%s/ '%s'" % (pattern, target))
        else:
            nfail += 1
            print_result("FAIL", "/%s/ '%s'" % (pattern, target))
    else:
        if not_match:
            nfail += 1
            print_result("FAIL(N)", "/%s/ '%s'" % (pattern, target))
        else:
            start = rxp.contents.startp[mem] - tp.getptr()
            end = rxp.contents.endp[mem] - tp.getptr()
            if (start == s_from) and (end == s_to):
                nsucc += 1
                print_result("OK", "/%s/ '%s'" % (pattern, target))
            else:
                nfail += 1
                print_result("FAIL", "/%s/ '%s' %d-%d : %d-%d" % (pattern, target,
                        s_from, s_to, start, end))
    
    if (rxp):
        BRegfree(rxp)

def x2(pattern, target, s_from, s_to):
    xx(pattern, target, s_from, s_to, 0, False)

def x3(pattern, target, s_from, s_to, mem):
    xx(pattern, target, s_from, s_to, mem, False)

def n(pattern, target):
    xx(pattern, target, 0, 0, 0, True)


def is_unicode_encoding(enc):
    return enc in ("UTF-16LE", "UTF-8")

def main():
    global encoding
    
    unicode_func = False
    
    # set encoding of the test target
    if len(sys.argv) > 1:
        encs = {"CP932": False,
                "SJIS": False,
                "UTF-8": False,
                "UTF-16LE": True}
        try:
            unicode_func = encs[sys.argv[1]]
        except KeyError:
            print("test target encoding error")
            print("Usage: python test_match.py [test target encoding] [output encoding]")
            sys.exit()
        encoding = sys.argv[1]
    
    # set encoding of stdout/stderr
    if len(sys.argv) > 2:
        outenc = sys.argv[2]
    else:
        outenc = locale.getpreferredencoding()
    
    def get_text_writer(fileno, **kwargs):
        kw = dict(kwargs)
        kw.setdefault('errors', 'backslashreplace')
        kw.setdefault('closefd', False)
        writer = io.open(fileno, mode='w', **kw)
        
        # work around for Python 2.x
        write = writer.write    # save the original write() function
        enc = locale.getpreferredencoding()
        writer.write = lambda s: write(s.decode(enc)) \
                if isinstance(s, bytes) else write(s)  # convert to unistr
        return writer
    
    sys.stdout = get_text_writer(sys.stdout.fileno(), encoding=outenc)
    sys.stderr = get_text_writer(sys.stderr.fileno(), encoding=outenc)
    
    
    LoadBregonig(unicode_func)
    #LoadBregexp()
    
    print(BRegexpVersion())
    print()
    
    
    # onig-5.9.2/win32/testc.c Rs[
    #   trigraph ΍ ?\?  ?? ɒu
    #   (?m)  (?s) ɒu
    #   \C-x ̓T|[gĂȂ߃RgAEg
    #   ONIG_OPTION_CAPTURE_GROUP LɂĂ邽߁Aobt@ԍύX
    #   }b`ʒu̎woCgPʂ當PʂɕύX
    
    x2("", "", 0, 0);
    x2("^", "", 0, 0);
    x2("$", "", 0, 0);
    x2("\\G", "", 0, 0);
    x2("\\A", "", 0, 0);
    x2("\\Z", "", 0, 0);
    x2("\\z", "", 0, 0);
    x2("^$", "", 0, 0);
    x2("\\ca", "\001", 0, 1);
    #x2("\\C-b", "\002", 0, 1);  #XXX: \C-x is not supported
    x2("\\c\\\\", "\034", 0, 1);
    x2("q[\\c\\\\]", "q\034", 0, 2);
    x2("", "a", 0, 0);
    x2("a", "a", 0, 1);
    if encoding == "UTF-16LE":
        x2("\\x61\\x00", "a", 0, 1);
    else:
        x2("\\x61", "a", 0, 1);
    x2("aa", "aa", 0, 2);
    x2("aaa", "aaa", 0, 3);
    x2("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", 0, 35);
    x2("ab", "ab", 0, 2);
    x2("b", "ab", 1, 2);
    x2("bc", "abc", 1, 3);
    x2("(?i:#RET#)", "#INS##RET#", 5, 10);
    if encoding == "UTF-16LE":
        x2("\\17\\00", "\017", 0, 1);
        x2("\\x1f\\x00", "\x1f", 0, 1);
    else:
        x2("\\17", "\017", 0, 1);
        x2("\\x1f", "\x1f", 0, 1);
    x2("a(?#....\\\\JJJJ)b", "ab", 0, 2);
    x2("(?x)  G (o O(?-x)oO) g L", "GoOoOgLe", 0, 7);
    x2(".", "a", 0, 1);
    n(".", "");
    x2("..", "ab", 0, 2);
    x2("\\w", "e", 0, 1);
    n("\\W", "e");
    x2("\\s", " ", 0, 1);
    x2("\\S", "b", 0, 1);
    x2("\\d", "4", 0, 1);
    n("\\D", "4");
    x2("\\b", "z ", 0, 0);
    x2("\\b", " z", 1, 1);
    x2("\\B", "zz ", 1, 1);
    x2("\\B", "z ", 2, 2);
    x2("\\B", " z", 0, 0);
    x2("[ab]", "b", 0, 1);
    n("[ab]", "c");
    x2("[a-z]", "t", 0, 1);
    n("[^a]", "a");
    x2("[^a]", "\n", 0, 1);
    x2("[]]", "]", 0, 1);
    n("[^]]", "]");
    x2("[\\^]+", "0^^1", 1, 3);
    x2("[b-]", "b", 0, 1);
    x2("[b-]", "-", 0, 1);
    x2("[\\w]", "z", 0, 1);
    n("[\\w]", " ");
    x2("[\\W]", "b$", 1, 2);
    x2("[\\d]", "5", 0, 1);
    n("[\\d]", "e");
    x2("[\\D]", "t", 0, 1);
    n("[\\D]", "3");
    x2("[\\s]", " ", 0, 1);
    n("[\\s]", "a");
    x2("[\\S]", "b", 0, 1);
    n("[\\S]", " ");
    x2("[\\w\\d]", "2", 0, 1);
    n("[\\w\\d]", " ");
    x2("[[:upper:]]", "B", 0, 1);
    x2("[*[:xdigit:]+]", "+", 0, 1);
    x2("[*[:xdigit:]+]", "GHIKK-9+*", 6, 7);
    x2("[*[:xdigit:]+]", "-@^+", 3, 4);
    n("[[:upper]]", "A");
    x2("[[:upper]]", ":", 0, 1);
    if encoding == "UTF-16LE":
        x2("[\\044\\000-\\047\\000]", "\046", 0, 1);
        x2("[\\x5a\\x00-\\x5c\\x00]", "\x5b", 0, 1);
        x2("[\\x6A\\x00-\\x6D\\x00]", "\x6c", 0, 1);
        n("[\\x6A\\x00-\\x6D\\x00]", "\x6E");
    else:
        x2("[\\044-\\047]", "\046", 0, 1);
        x2("[\\x5a-\\x5c]", "\x5b", 0, 1);
        x2("[\\x6A-\\x6D]", "\x6c", 0, 1);
        n("[\\x6A-\\x6D]", "\x6E");
    n("^[0-9A-F]+ 0+ UNDEF ", "75F 00000000 SECT14A notype ()    External    | _rb_apply");
    x2("[\\[]", "[", 0, 1);
    x2("[\\]]", "]", 0, 1);
    x2("[&]", "&", 0, 1);
    x2("[[ab]]", "b", 0, 1);
    x2("[[ab]c]", "c", 0, 1);
    n("[[^a]]", "a");
    n("[^[a]]", "a");
    x2("[[ab]&&bc]", "b", 0, 1);
    n("[[ab]&&bc]", "a");
    n("[[ab]&&bc]", "c");
    x2("[a-z&&b-y&&c-x]", "w", 0, 1);
    n("[^a-z&&b-y&&c-x]", "w");
    x2("[[^a&&a]&&a-z]", "b", 0, 1);
    n("[[^a&&a]&&a-z]", "a");
    x2("[[^a-z&&bcdef]&&[^c-g]]", "h", 0, 1);
    n("[[^a-z&&bcdef]&&[^c-g]]", "c");
    x2("[^[^abc]&&[^cde]]", "c", 0, 1);
    x2("[^[^abc]&&[^cde]]", "e", 0, 1);
    n("[^[^abc]&&[^cde]]", "f");
    x2("[a-&&-a]", "-", 0, 1);
    n("[a\\-&&\\-a]", "&");
    n("\\wabc", " abc");
    x2("a\\Wbc", "a bc", 0, 4);
    x2("a.b.c", "aabbc", 0, 5);
    x2(".\\wb\\W..c", "abb bcc", 0, 7);
    x2("\\s\\wzzz", " zzzz", 0, 5);
    x2("aa.b", "aabb", 0, 4);
    n(".a", "ab");
    x2(".a", "aa", 0, 2);
    x2("^a", "a", 0, 1);
    x2("^a$", "a", 0, 1);
    x2("^\\w$", "a", 0, 1);
    n("^\\w$", " ");
    x2("^\\wab$", "zab", 0, 3);
    x2("^\\wabcdef$", "zabcdef", 0, 7);
    x2("^\\w...def$", "zabcdef", 0, 7);
    x2("\\w\\w\\s\\Waaa\\d", "aa  aaa4", 0, 8);
    x2("\\A\\Z", "", 0, 0);
    x2("\\Axyz", "xyz", 0, 3);
    x2("xyz\\Z", "xyz", 0, 3);
    x2("xyz\\z", "xyz", 0, 3);
    x2("a\\Z", "a", 0, 1);
    x2("\\Gaz", "az", 0, 2);
    n("\\Gz", "bza");
    n("az\\G", "az");
    n("az\\A", "az");
    n("a\\Az", "az");
    x2("\\^\\$", "^$", 0, 2);
    x2("^x?y", "xy", 0, 2);
    x2("^(x?y)", "xy", 0, 2);
    x2("\\w", "_", 0, 1);
    n("\\W", "_");
    x2("(?=z)z", "z", 0, 1);
    n("(?=z).", "a");
    x2("(?!z)a", "a", 0, 1);
    n("(?!z)a", "z");
    x2("(?i:a)", "a", 0, 1);
    x2("(?i:a)", "A", 0, 1);
    x2("(?i:A)", "a", 0, 1);
    n("(?i:A)", "b");
    x2("(?i:[A-Z])", "a", 0, 1);
    x2("(?i:[f-m])", "H", 0, 1);
    x2("(?i:[f-m])", "h", 0, 1);
    n("(?i:[f-m])", "e");
    x2("(?i:[A-c])", "D", 0, 1);
    n("(?i:[^a-z])", "A");
    n("(?i:[^a-z])", "a");
    x2("(?i:[!-k])", "Z", 0, 1);
    x2("(?i:[!-k])", "7", 0, 1);
    x2("(?i:[T-}])", "b", 0, 1);
    x2("(?i:[T-}])", "{", 0, 1);
    x2("(?i:\\?a)", "?A", 0, 2);
    x2("(?i:\\*A)", "*a", 0, 2);
    n(".", "\n");
    x2("(?s:.)", "\n", 0, 1);           #XXX: m -> s
    x2("(?s:a.)", "a\n", 0, 2);         #XXX: m -> s
    x2("(?s:.b)", "a\nb", 1, 3);        #XXX: m -> s
    x2(".*abc", "dddabdd\nddabc", 8, 13);
    x2("(?s:.*abc)", "dddabddabc", 0, 10);  #XXX: m -> s
    n("(?i)(?-i)a", "A");
    n("(?i)(?-i:a)", "A");
    x2("a?", "", 0, 0);
    x2("a?", "b", 0, 0);
    x2("a?", "a", 0, 1);
    x2("a*", "", 0, 0);
    x2("a*", "a", 0, 1);
    x2("a*", "aaa", 0, 3);
    x2("a*", "baaaa", 0, 0);
    n("a+", "");
    x2("a+", "a", 0, 1);
    x2("a+", "aaaa", 0, 4);
    x2("a+", "aabbb", 0, 2);
    x2("a+", "baaaa", 1, 5);
    x2(".?", "", 0, 0);
    x2(".?", "f", 0, 1);
    x2(".?", "\n", 0, 0);
    x2(".*", "", 0, 0);
    x2(".*", "abcde", 0, 5);
    x2(".+", "z", 0, 1);
    x2(".+", "zdswer\n", 0, 6);
    x2("(.*)a\\1f", "babfbac", 0, 4);
    x2("(.*)a\\1f", "bacbabf", 3, 7);
    x2("((.*)a\\2f)", "bacbabf", 3, 7);
    x2("(.*)a\\1f", "baczzzzzz\nbazz\nzzzzbabf", 19, 23);
    x2("a|b", "a", 0, 1);
    x2("a|b", "b", 0, 1);
    x2("|a", "a", 0, 0);
    x2("(|a)", "a", 0, 0);
    x2("ab|bc", "ab", 0, 2);
    x2("ab|bc", "bc", 0, 2);
    x2("z(?:ab|bc)", "zbc", 0, 3);
    x2("a(?:ab|bc)c", "aabc", 0, 4);
    x2("ab|(?:ac|az)", "az", 0, 2);
    x2("a|b|c", "dc", 1, 2);
    x2("a|b|cd|efg|h|ijk|lmn|o|pq|rstuvwx|yz", "pqr", 0, 2);
    n("a|b|cd|efg|h|ijk|lmn|o|pq|rstuvwx|yz", "mn");
    x2("a|^z", "ba", 1, 2);
    x2("a|^z", "za", 0, 1);
    x2("a|\\Gz", "bza", 2, 3);
    x2("a|\\Gz", "za", 0, 1);
    x2("a|\\Az", "bza", 2, 3);
    x2("a|\\Az", "za", 0, 1);
    x2("a|b\\Z", "ba", 1, 2);
    x2("a|b\\Z", "b", 0, 1);
    x2("a|b\\z", "ba", 1, 2);
    x2("a|b\\z", "b", 0, 1);
    x2("\\w|\\s", " ", 0, 1);
    n("\\w|\\w", " ");
    x2("\\w|%", "%", 0, 1);
    x2("\\w|[&$]", "&", 0, 1);
    x2("[b-d]|[^e-z]", "a", 0, 1);
    x2("(?:a|[c-f])|bz", "dz", 0, 1);
    x2("(?:a|[c-f])|bz", "bz", 0, 2);
    x2("abc|(?=zz)..f", "zzf", 0, 3);
    x2("abc|(?!zz)..f", "abf", 0, 3);
    x2("(?=za)..a|(?=zz)..a", "zza", 0, 3);
    n("(?>a|abd)c", "abdc");
    x2("(?>abd|a)c", "abdc", 0, 4);
    x2("a?|b", "a", 0, 1);
    x2("a?|b", "b", 0, 0);
    x2("a?|b", "", 0, 0);
    x2("a*|b", "aa", 0, 2);
    x2("a*|b*", "ba", 0, 0);
    x2("a*|b*", "ab", 0, 1);
    x2("a+|b*", "", 0, 0);
    x2("a+|b*", "bbb", 0, 3);
    x2("a+|b*", "abbb", 0, 1);
    n("a+|b+", "");
    x2("(a|b)?", "b", 0, 1);
    x2("(a|b)*", "ba", 0, 2);
    x2("(a|b)+", "bab", 0, 3);
    x2("(ab|ca)+", "caabbc", 0, 4);
    x2("(ab|ca)+", "aabca", 1, 5);
    x2("(ab|ca)+", "abzca", 0, 2);
    x2("(a|bab)+", "ababa", 0, 5);
    x2("(a|bab)+", "ba", 1, 2);
    x2("(a|bab)+", "baaaba", 1, 4);
    x2("(?:a|b)(?:a|b)", "ab", 0, 2);
    x2("(?:a*|b*)(?:a*|b*)", "aaabbb", 0, 3);
    x2("(?:a*|b*)(?:a+|b+)", "aaabbb", 0, 6);
    x2("(?:a+|b+){2}", "aaabbb", 0, 6);
    x2("h{0,}", "hhhh", 0, 4);
    x2("(?:a+|b+){1,2}", "aaabbb", 0, 6);
    n("ax{2}*a", "0axxxa1");
    n("a.{0,2}a", "0aXXXa0");
    n("a.{0,2}?a", "0aXXXa0");
    n("a.{0,2}?a", "0aXXXXa0");
    x2("^a{2,}?a$", "aaa", 0, 3);
    x2("^[a-z]{2,}?$", "aaa", 0, 3);
    x2("(?:a+|\\Ab*)cc", "cc", 0, 2);
    n("(?:a+|\\Ab*)cc", "abcc");
    x2("(?:^a+|b+)*c", "aabbbabc", 6, 8);
    x2("(?:^a+|b+)*c", "aabbbbc", 0, 7);
    x2("a|(?i)c", "C", 0, 1);
    x2("(?i)c|a", "C", 0, 1);
    x2("(?i)c|a", "A", 0, 1);
    x2("(?i:c)|a", "C", 0, 1);
    n("(?i:c)|a", "A");
    x2("[abc]?", "abc", 0, 1);
    x2("[abc]*", "abc", 0, 3);
    x2("[^abc]*", "abc", 0, 0);
    n("[^abc]+", "abc");
    x2("a??", "aaa", 0, 0);
    x2("ba??b", "bab", 0, 3);
    x2("a*?", "aaa", 0, 0);
    x2("ba*?", "baa", 0, 1);
    x2("ba*?b", "baab", 0, 4);
    x2("a+?", "aaa", 0, 1);
    x2("ba+?", "baa", 0, 2);
    x2("ba+?b", "baab", 0, 4);
    x2("(?:a?)??", "a", 0, 0);
    x2("(?:a??)?", "a", 0, 0);
    x2("(?:a?)+?", "aaa", 0, 1);
    x2("(?:a+)??", "aaa", 0, 0);
    x2("(?:a+)??b", "aaab", 0, 4);
    x2("(?:ab)?{2}", "", 0, 0);
    x2("(?:ab)?{2}", "ababa", 0, 4);
    x2("(?:ab)*{0}", "ababa", 0, 0);
    x2("(?:ab){3,}", "abababab", 0, 8);
    n("(?:ab){3,}", "abab");
    x2("(?:ab){2,4}", "ababab", 0, 6);
    x2("(?:ab){2,4}", "ababababab", 0, 8);
    x2("(?:ab){2,4}?", "ababababab", 0, 4);
    x2("(?:ab){,}", "ab{,}", 0, 5);
    x2("(?:abc)+?{2}", "abcabcabc", 0, 6);
    x2("(?:X*)(?i:xa)", "XXXa", 0, 4);
    x2("(d+)([^abc]z)", "dddz", 0, 4);
    x2("([^abc]*)([^abc]z)", "dddz", 0, 4);
    x2("(\\w+)(\\wz)", "dddz", 0, 4);
    x3("(a)", "a", 0, 1, 1);
    x3("(ab)", "ab", 0, 2, 1);
    x2("((ab))", "ab", 0, 2);
    x3("((ab))", "ab", 0, 2, 1);
    x3("((ab))", "ab", 0, 2, 2);
    x3("((((((((((((((((((((ab))))))))))))))))))))", "ab", 0, 2, 20);
    x3("(ab)(cd)", "abcd", 0, 2, 1);
    x3("(ab)(cd)", "abcd", 2, 4, 2);
    x3("()(a)bc(def)ghijk", "abcdefghijk", 3, 6, 3);
    x3("(()(a)bc(def)ghijk)", "abcdefghijk", 3, 6, 4);
    x2("(^a)", "a", 0, 1);
    x3("(a)|(a)", "ba", 1, 2, 1);
    x3("(^a)|(a)", "ba", 1, 2, 2);
    x3("(a?)", "aaa", 0, 1, 1);
    x3("(a*)", "aaa", 0, 3, 1);
    x3("(a*)", "", 0, 0, 1);
    x3("(a+)", "aaaaaaa", 0, 7, 1);
    x3("(a+|b*)", "bbbaa", 0, 3, 1);
    x3("(a+|b?)", "bbbaa", 0, 1, 1);
    x3("(abc)?", "abc", 0, 3, 1);
    x3("(abc)*", "abc", 0, 3, 1);
    x3("(abc)+", "abc", 0, 3, 1);
    x3("(xyz|abc)+", "abc", 0, 3, 1);
    x3("([xyz][abc]|abc)+", "abc", 0, 3, 1);
    x3("((?i:abc))", "AbC", 0, 3, 1);
    x2("(abc)(?i:\\1)", "abcABC", 0, 6);
    x3("((?s:a.c))", "a\nc", 0, 3, 1);  #XXX m -> s
    x3("((?=az)a)", "azb", 0, 1, 1);
    x3("abc|(.abd)", "zabd", 0, 4, 1);
    x2("(?:abc)|(ABC)", "abc", 0, 3);
    x3("(?i:(abc))|(zzz)", "ABC", 0, 3, 1);
    x3("a*(.)", "aaaaz", 4, 5, 1);
    x3("a*?(.)", "aaaaz", 0, 1, 1);
    x3("a*?(c)", "aaaac", 4, 5, 1);
    x3("[bcd]a*(.)", "caaaaz", 5, 6, 1);
    x3("(\\Abb)cc", "bbcc", 0, 2, 1);
    n("(\\Abb)cc", "zbbcc");
    x3("(^bb)cc", "bbcc", 0, 2, 1);
    n("(^bb)cc", "zbbcc");
    x3("cc(bb$)", "ccbb", 2, 4, 1);
    n("cc(bb$)", "ccbbb");
    n("(\\1)", "");
    n("\\1(a)", "aa");
    n("(a(b)\\1)\\2+", "ababb");
    n("(?:(?:\\1|z)(a))+$", "zaa");
    x2("(?:(?:\\1|z)(a))+$", "zaaa", 0, 4);
    x2("(a)(?=\\1)", "aa", 0, 1);
    n("(a)$|\\1", "az");
    x2("(a)\\1", "aa", 0, 2);
    n("(a)\\1", "ab");
    x2("(a?)\\1", "aa", 0, 2);
    x2("(a??)\\1", "aa", 0, 0);
    x2("(a*)\\1", "aaaaa", 0, 4);
    x3("(a*)\\1", "aaaaa", 0, 2, 1);
    x2("a(b*)\\1", "abbbb", 0, 5);
    x2("a(b*)\\1", "ab", 0, 1);
    x2("(a*)(b*)\\1\\2", "aaabbaaabb", 0, 10);
    x2("(a*)(b*)\\2", "aaabbbb", 0, 7);
    x2("(((((((a*)b))))))c\\7", "aaabcaaa", 0, 8);
    x3("(((((((a*)b))))))c\\7", "aaabcaaa", 0, 3, 7);
    x2("(a)(b)(c)\\2\\1\\3", "abcbac", 0, 6);
    x2("([a-d])\\1", "cc", 0, 2);
    x2("(\\w\\d\\s)\\1", "f5 f5 ", 0, 6);
    n("(\\w\\d\\s)\\1", "f5 f5");
    x2("(who|[a-c]{3})\\1", "whowho", 0, 6);
    x2("...(who|[a-c]{3})\\1", "abcwhowho", 0, 9);
    x2("(who|[a-c]{3})\\1", "cbccbc", 0, 6);
    x2("(^a)\\1", "aa", 0, 2);
    n("(^a)\\1", "baa");
    n("(a$)\\1", "aa");
    n("(ab\\Z)\\1", "ab");
    x2("(a*\\Z)\\1", "a", 1, 1);
    x2(".(a*\\Z)\\1", "ba", 1, 2);
    x3("(.(abc)\\2)", "zabcabc", 0, 7, 1);
    x3("(.(..\\d.)\\2)", "z12341234", 0, 9, 1);
    x2("((?i:az))\\1", "AzAz", 0, 4);
    n("((?i:az))\\1", "Azaz");
    x2("(?<=a)b", "ab", 1, 2);
    n("(?<=a)b", "bb");
    x2("(?<=a|b)b", "bb", 1, 2);
    x2("(?<=a|bc)b", "bcb", 2, 3);
    x2("(?<=a|bc)b", "ab", 1, 2);
    x2("(?<=a|bc||defghij|klmnopq|r)z", "rz", 1, 2);
    x2("(a)\\g<1>", "aa", 0, 2);
    x2("(?<!a)b", "cb", 1, 2);
    n("(?<!a)b", "ab");
    x2("(?<!a|bc)b", "bbb", 0, 1);
    n("(?<!a|bc)z", "bcz");
    x2("(?<name1>a)", "a", 0, 1);
    x2("(?<name_2>ab)\\g<name_2>", "abab", 0, 4);
    x2("(?<name_3>.zv.)\\k<name_3>", "azvbazvb", 0, 8);
    x2("(?<=\\g<ab>)|-\\zEND (?<ab>XyZ)", "XyZ", 3, 3);
    x2("(?<n>|a\\g<n>)+", "", 0, 0);
    x2("(?<n>|\\(\\g<n>\\))+$", "()(())", 0, 6);
    x3("\\g<n>(?<n>.){0}", "X", 0, 1, 1);
    x2("\\g<n>(abc|df(?<n>.YZ){2,8}){0}", "XYZ", 0, 3);
    x2("\\A(?<n>(a\\g<n>)|)\\z", "aaaa", 0, 4);
    x2("(?<n>|\\g<m>\\g<n>)\\z|\\zEND (?<m>a|(b)\\g<m>)", "bbbbabba", 0, 8);
    x2("(?<name1240>\\w+\\sx)a+\\k<name1240>", "  fg xaaaaaaaafg x", 2, 18);
    x3("(z)()()(?<_9>a)\\g<_9>", "zaa", 2, 3, 4);   #XXX: memory number 1 -> 4
    x2("(.)(((?<_>a)))\\k<_>", "zaa", 0, 3);
    x2("((?<name1>\\d)|(?<name2>\\w))(\\k<name1>|\\k<name2>)", "ff", 0, 2);
    x2("(?:(?<x>)|(?<x>efg))\\k<x>", "", 0, 0);
    x2("(?:(?<x>abc)|(?<x>efg))\\k<x>", "abcefgefg", 3, 9);
    n("(?:(?<x>abc)|(?<x>efg))\\k<x>", "abcefg");
    x2("(?:(?<n1>.)|(?<n1>..)|(?<n1>...)|(?<n1>....)|(?<n1>.....)|(?<n1>......)|(?<n1>.......)|(?<n1>........)|(?<n1>.........)|(?<n1>..........)|(?<n1>...........)|(?<n1>............)|(?<n1>.............)|(?<n1>..............))\\k<n1>$", "a-pyumpyum", 2, 10);
    x3("(?:(?<n1>.)|(?<n1>..)|(?<n1>...)|(?<n1>....)|(?<n1>.....)|(?<n1>......)|(?<n1>.......)|(?<n1>........)|(?<n1>.........)|(?<n1>..........)|(?<n1>...........)|(?<n1>............)|(?<n1>.............)|(?<n1>..............))\\k<n1>$", "xxxxabcdefghijklmnabcdefghijklmn", 4, 18, 14);
    x3("(?<name1>)(?<name2>)(?<name3>)(?<name4>)(?<name5>)(?<name6>)(?<name7>)(?<name8>)(?<name9>)(?<name10>)(?<name11>)(?<name12>)(?<name13>)(?<name14>)(?<name15>)(?<name16>aaa)(?<name17>)$", "aaa", 0, 3, 16);
    x2("(?<foo>a|\\(\\g<foo>\\))", "a", 0, 1);
    x2("(?<foo>a|\\(\\g<foo>\\))", "((((((a))))))", 0, 13);
    x3("(?<foo>a|\\(\\g<foo>\\))", "((((((((a))))))))", 0, 17, 1);
    x2("\\g<bar>|\\zEND(?<bar>.*abc$)", "abcxxxabc", 0, 9);
    x2("\\g<1>|\\zEND(.a.)", "bac", 0, 3);
    x3("\\g<_A>\\g<_A>|\\zEND(.a.)(?<_A>.b.)", "xbxyby", 3, 6, 2);  #XXX: memory number 1 -> 2
    x2("\\A(?:\\g<pon>|\\g<pan>|\\zEND  (?<pan>a|c\\g<pon>c)(?<pon>b|d\\g<pan>d))$", "cdcbcdc", 0, 7);
    x2("\\A(?<n>|a\\g<m>)\\z|\\zEND (?<m>\\g<n>)", "aaaa", 0, 4);
    x2("(?<n>(a|b\\g<n>c){3,5})", "baaaaca", 1, 5);
    x2("(?<n>(a|b\\g<n>c){3,5})", "baaaacaaaaa", 0, 10);
    x2("(?<pare>\\(([^\\(\\)]++|\\g<pare>)*+\\))", "((a))", 0, 5);
    x2("()*\\1", "", 0, 0);
    x2("(?:()|())*\\1\\2", "", 0, 0);
    x3("(?:\\1a|())*", "a", 0, 0, 1);
    x2("x((.)*)*x", "0x1x2x3", 1, 6);
    x2("x((.)*)*x(?i:\\1)\\Z", "0x1x2x1X2", 1, 9);
    x2("(?:()|()|()|()|()|())*\\2\\5", "", 0, 0);
    x2("(?:()|()|()|(x)|()|())*\\2b\\5", "b", 0, 1);
    if encoding == "UTF-16LE":
        x2("\\xFA\\x8F", "\u8ffa", 0, 1);
    elif encoding == "UTF-8":
        x2("\\xE8\\xBF\\xBA", "\u8ffa", 0, 1);
    else:
        x2("\\xE7\\x92", "\u8ffa", 0, 1); # ""
    x2("", "", 0, 0);
    x2("", "", 0, 1);
    n("", "");
    x2("", "", 0, 2);
    x2("", "", 0, 3);
    x2("", "", 0, 35);
    x2("", "", 1, 2);
    x2("", "", 1, 3);
#    x2(b"\\xca\\xb8", b"\xca\xb8", 0, 2);   # "" (EUC-JP)
    x2(".", "", 0, 1);
    x2("..", "", 0, 2);
    x2("\\w", "", 0, 1);
    n("\\W", "");
    x2("[\\W]", "$", 1, 2);
    x2("\\S", "", 0, 1);
    x2("\\S", "", 0, 1);
    x2("\\b", "C ", 0, 0);
    x2("\\b", " ", 1, 1);
    x2("\\B", " ", 1, 1);
    x2("\\B", " ", 2, 2);
    x2("\\B", " ", 0, 0);
    x2("[]", "", 0, 1);
    n("[Ȃ]", "");
    x2("[-]", "", 0, 1);
    n("[^]", "");
    x2("[\\w]", "", 0, 1);
    n("[\\d]", "");
    x2("[\\D]", "", 0, 1);
    n("[\\s]", "");
    x2("[\\S]", "", 0, 1);
    x2("[\\w\\d]", "", 0, 1);
    x2("[\\w\\d]", "   ", 3, 4);
    n("\\wS", " S");
    x2("S\\W", "S ", 0, 3);
    x2("..", "", 0, 5);
    x2(".\\w\\W..", " ", 0, 7);
    x2("\\s\\w", " ", 0, 5);
    x2(".", "", 0, 4);
    n(".", "");
    x2(".", "", 0, 2);
    x2("^", "", 0, 1);
    x2("^$", "", 0, 1);
    x2("^\\w$", "", 0, 1);
    x2("^\\w$", "z", 0, 6);
    x2("^\\w...$", "z", 0, 7);
    x2("\\w\\w\\s\\W\\d", "a  4", 0, 8);
    x2("\\A", "", 0, 3);
    x2("ނ߂\\Z", "ނ߂", 0, 3);
    x2("\\z", "", 0, 3);
    x2("\\Z", "\n", 0, 3);
    x2("\\Gۂ", "ۂ", 0, 2);
    n("\\G", "");
    n("Ƃ\\G", "Ƃ");
    n("܂\\A", "܂");
    n("\\A", "܂");
    x2("(?=)", "", 0, 1);
    n("(?=).", "");
    x2("(?!)", "", 0, 1);
    n("(?!)", "");
    x2("(?i:)", "", 0, 1);
    x2("(?i:Ԃ)", "Ԃ", 0, 2);
    n("(?i:)", "");
    x2("(?s:.)", "\n", 0, 2);     #XXX: m -> s
    x2("(?s:.)", "\n", 1, 3);   #XXX: m -> s
    x2("?", "", 0, 0);
    x2("?", "", 0, 0);
    x2("?", "", 0, 1);
    x2("*", "", 0, 0);
    x2("*", "", 0, 1);
    x2("q*", "qqq", 0, 3);
    x2("n*", "nnnn", 0, 0);
    n("R+", "");
    x2("+", "", 0, 1);
    x2("+", "", 0, 4);
    x2("+", "", 0, 2);
    x2("+", "", 1, 5);
    x2(".?", "", 0, 1);
    x2(".*", "ς҂Ղ", 0, 4);
    x2(".+", "", 0, 1);
    x2(".+", "\n", 0, 4);
    x2("|", "", 0, 1);
    x2("|", "", 0, 1);
    x2("|", "", 0, 2);
    x2("|", "", 0, 2);
    x2("(?:|)", "", 0, 3);
    x2("(?:|)", "", 0, 4);
    x2("|(?:|)", "", 0, 2);
    x2("||", "", 1, 2);
    x2("|||||||||ĂƂȂ|ʂ", "", 0, 3);
    n("|||||||||ĂƂȂ|ʂ", "");
    x2("|^", "Ԃ", 1, 2);
    x2("|^", "", 0, 1);
    x2("S|\\G", "ԋS", 2, 3);
    x2("S|\\G", "ԋS", 0, 1);
    x2("S|\\A", "bԋS", 2, 3);
    x2("S|\\A", "", 0, 1);
    x2("S|\\Z", "ԋS", 1, 2);
    x2("S|\\Z", "", 0, 1);
    x2("S|\\Z", "\n", 0, 1);
    x2("S|\\z", "ԋS", 1, 2);
    x2("S|\\z", "", 0, 1);
    x2("\\w|\\s", "", 0, 1);
    x2("\\w|%", "%", 0, 1);
    x2("\\w|[&$]", "&", 0, 1);
    x2("[-]", "", 0, 1);
    x2("[-]|[^-]", "", 0, 1);
    x2("[-]|[^-]", "", 0, 1);
    x2("[^]", "\n", 0, 1);
    x2("(?:|[-])|", "", 0, 1);
    x2("(?:|[-])|", "", 0, 2);
    x2("|(?=)..", "", 0, 3);
    x2("|(?!)..", "", 0, 3);
    x2("(?=)..|(?=)..", "", 0, 3);
    x2("(?<=|)", "", 2, 3);
    n("(?>|)", "");
    x2("(?>|)", "", 0, 4);
    x2("?|", "", 0, 1);
    x2("?|", "", 0, 0);
    x2("?|", "", 0, 0);
    x2("*|", "", 0, 2);
    x2("*|*", "", 0, 0);
    x2("*|*", "", 0, 1);
    x2("[a]*|*", "a", 0, 2);
    x2("+|*", "", 0, 0);
    x2("+|*", "", 0, 3);
    x2("+|*", "", 0, 1);
    x2("+|*", "a", 0, 0);
    n("+|+", "");
    x2("(|)?", "", 0, 1);
    x2("(|)*", "", 0, 2);
    x2("(|)+", "", 0, 3);
    x2("(|)+", "", 0, 4);
    x2("(|)+", "", 2, 6);
    x2("(|)+", "", 1, 5);
    x2("(|)+", "", 0, 2);
    x2("(|)+", "$$zzzz", 6, 8);
    x2("(|)+", "", 0, 5);
    x2("(|)+", "", 1, 2);
    x2("(|)+", "", 1, 4);
    x2("(?:|)(?:|)", "", 0, 2);
    x2("(?:*|*)(?:*|*)", "", 0, 3);
    x2("(?:*|*)(?:+|+)", "", 0, 6);
    x2("(?:+|+){2}", "", 0, 6);
    x2("(?:+|+){1,2}", "", 0, 6);
    x2("(?:+|\\A*)", "", 0, 2);
    n("(?:+|\\A*)", "");
    x2("(?:^+|+)*", "", 6, 8);
    x2("(?:^+|+)*", "", 0, 7);
    x2("{0,}", "", 0, 4);
    x2("|(?i)c", "C", 0, 1);
    x2("(?i)c|", "C", 0, 1);
    x2("(?i:)|a", "a", 0, 1);
    n("(?i:)|a", "A");
    x2("[]?", "", 0, 1);
    x2("[]*", "", 0, 3);
    x2("[^]*", "", 0, 0);
    n("[^]+", "");
    x2("??", "", 0, 0);
    x2("??", "", 0, 3);
    x2("*?", "", 0, 0);
    x2("*?", "", 0, 1);
    x2("*?", "", 0, 4);
    x2("+?", "", 0, 1);
    x2("+?", "", 0, 2);
    x2("+?", "", 0, 4);
    x2("(?:V?)??", "V", 0, 0);
    x2("(?:V??)?", "V", 0, 0);
    x2("(?:?)+?", "", 0, 1);
    x2("(?:+)??", "", 0, 0);
    x2("(?:+)??", "ᑚ", 0, 4);
    x2("(?:)?{2}", "", 0, 0);
    x2("(?:S)?{2}", "SԋSԋS", 0, 4);
    x2("(?:S)*{0}", "SԋSԋS", 0, 0);
    x2("(?:S){3,}", "SԋSԋSԋS", 0, 8);
    n("(?:S){3,}", "SԋS");
    x2("(?:S){2,4}", "SԋSԋS", 0, 6);
    x2("(?:S){2,4}", "SԋSԋSԋSԋS", 0, 8);
    x2("(?:S){2,4}?", "SԋSԋSԋSԋS", 0, 4);
    x2("(?:S){,}", "S{,}", 0, 5);
    x2("(?:)+?{2}", "", 0, 6);
    x3("()", "", 0, 1, 1);
    x3("(ΐ)", "ΐ", 0, 2, 1);
    x2("(())", "", 0, 2);
    x3("(())", "", 0, 2, 1);
    x3("(())", "", 0, 2, 2);
    x3("((((((((((((((((((((ʎq))))))))))))))))))))", "ʎq", 0, 2, 20);
    x3("()()", "", 0, 2, 1);
    x3("()()", "", 2, 4, 2);
    x3("()()()", "", 3, 6, 3);
    x3("(()()())", "", 3, 6, 4);
    x3(".*(tH)E}(()V^)C", "tHE}V^C", 5, 9, 2);
    x2("(^)", "", 0, 1);
    x3("()|()", "", 1, 2, 1);
    x3("(^)|()", "", 1, 2, 2);
    x3("(?)", "", 0, 1, 1);
    x3("(*)", "܂܂", 0, 3, 1);
    x3("(*)", "", 0, 0, 1);
    x3("(+)", "", 0, 7, 1);
    x3("(+|*)", "ӂӂӂւ", 0, 3, 1);
    x3("(+|?)", "", 0, 1, 1);
    x3("()?", "", 0, 3, 1);
    x3("()*", "", 0, 3, 1);
    x3("()+", "", 0, 3, 1);
    x3("(|)+", "", 0, 3, 1);
    x3("([Ȃɂ][]|)+", "", 0, 3, 1);
    x3("((?i:))", "", 0, 3, 1);
    x3("((?s:.))", "\n", 0, 3, 1);    #XXX: m -> s
    x3("((?=))", "", 0, 1, 1);
    x3("|(.)", "񂠂", 0, 4, 1);
    x3("*(.)", "", 4, 5, 1);
    x3("*?(.)", "", 0, 1, 1);
    x3("*?()", "", 4, 5, 1);
    x3("[]*(.)", "", 5, 6, 1);
    x3("(\\A)", "", 0, 2, 1);
    n("(\\A)", "񂢂");
    x3("(^)", "", 0, 2, 1);
    n("(^)", "񂢂");
    x3("($)", "", 2, 4, 1);
    n("($)", "");
    x2("()\\1", "", 0, 2);
    n("()\\1", "");
    x2("(?)\\1", "", 0, 2);
    x2("(??)\\1", "", 0, 0);
    x2("(*)\\1", "", 0, 4);
    x3("(*)\\1", "", 0, 2, 1);
    x2("(*)\\1", "", 0, 5);
    x2("(*)\\1", "", 0, 1);
    x2("(*)(*)\\1\\2", "", 0, 10);
    x2("(*)(*)\\2", "", 0, 7);
    x3("(*)(*)\\2", "", 3, 5, 2);
    x2("(((((((*)))))))\\7", "ۂۂۂ؂҂ۂۂ", 0, 8);
    x3("(((((((*)))))))\\7", "ۂۂۂ؂҂ۂۂ", 0, 3, 7);
    x2("()()()\\2\\1\\3", "͂ЂӂЂ͂", 0, 6);
    x2("([-])\\1", "", 0, 2);
    x2("(\\w\\d\\s)\\1", "5 5 ", 0, 6);
    n("(\\w\\d\\s)\\1", "5 5");
    x2("(NH|[-]{3})\\1", "NHNH", 0, 4);
    x2("...(NH|[-]{3})\\1", "aNHNH", 0, 7);
    x2("(NH|[-]{3})\\1", "", 0, 6);
    x2("(^)\\1", "", 0, 2);
    n("(^)\\1", "߂ނ");
    n("($)\\1", "");
    n("(\\Z)\\1", "");
    x2("(*\\Z)\\1", "", 1, 1);
    x2(".(*\\Z)\\1", "", 1, 2);
    x3("(.(₢)\\2)", "z₢₢", 0, 7, 1);
    x3("(.(..\\d.)\\2)", "12341234", 0, 9, 1);
    x2("((?i:v))\\1", "vv", 0, 6);
    x2("(?<>|\\(\\g<>\\))", "(((((())))))", 0, 13);
    x2("\\A(?:\\g<_1>|\\g<]_2>|\\zI  (?<_1>|\\g<]_2>)(?<]_2>|F\\g<_1>F))$", "FFݎFF", 0, 13);
    x2("[[Ђ]]", "", 0, 1);
    x2("[[]]", "", 0, 1);
    n("[[^]]", "");
    n("[^[]]", "");
    x2("[^[^]]", "", 0, 1);
    x2("[[]&&]", "", 0, 1);
    n("[[]&&]", "");
    n("[[]&&]", "");
    x2("[-&&-&&-]", "", 0, 1);
    n("[^-&&-&&-]", "");
    x2("[[^&&]&&-]", "", 0, 1);
    n("[[^&&]&&-]", "");
    x2("[[^-&&]&&[^-]]", "", 0, 1);
    n("[[^-&&]&&[^-]]", "");
    x2("[^[^]&&[^]]", "", 0, 1);
    x2("[^[^]&&[^]]", "", 0, 1);
    n("[^[^]&&[^]]", "");
    x2("[-&&-]", "-", 0, 1);
    x2("[^[^a-z]&&[^bcdefg]q-w]", "", 0, 1);
    x2("[^[^a-z]&&[^bcdefg]g-w]", "f", 0, 1);
    x2("[^[^a-z]&&[^bcdefg]g-w]", "g", 0, 1);
    n("[^[^a-z]&&[^bcdefg]g-w]", "2");
    x2("a<b>o[W̃_E[h<\\/b>", "a<b>o[W̃_E[h</b>", 0, 20);
    x2(".<b>o[W̃_E[h<\\/b>", "a<b>o[W̃_E[h</b>", 0, 20);
    
    
    # additional test patterns
    if is_unicode_encoding(encoding):
        x2("\\x{3042}\\x{3044}", "", 0, 2)
    else:
        x2("\\x{82a0}\\x{82A2}", "", 0, 2)
    x2("\\p{Hiragana}\\p{Katakana}", "C", 0, 2)
    x2("(?ms)^A.B$", "X\nA\nB\nZ", 2, 5)  # (?ms)
    n("(?<!(?<=a)b|c)d", "abd")
    n("(?<!(?<=a)b|c)d", "cd")
    x2("(?<!(?<=a)b|c)d", "bd", 1, 2)
    x2("(a){2}z", "aaz", 0, 3)
    x2("(?<=a).*b", "aab", 1, 3)
    x2("(?<=(?<!A)B)C", "BBC", 2, 3)
    n("(?<=(?<!A)B)C", "ABC")
    n("(?i)(?<!aa|b)c", "Aac")
    n("(?i)(?<!b|aa)c", "Aac")
    x2("(?<=\\babc)d", " abcd", 4, 5)
    x2("(?<=\\Babc)d", "aabcd", 4, 5)
    x2("a\\b?a", "aa", 0, 2)
    x2("[^x]*x", "aaax", 0, 4)
    x2("(?i)[\\x{0}-B]+", "\x00\x01\x02\x1f\x20@AaBbC", 0, 10)
    x2("(?i)a{2}", "AA", 0, 2)
    if is_unicode_encoding(encoding):
        # The longest script name
        x2("\\p{Other_Default_Ignorable_Code_Point}+", "\u034F\uFFF8\U000E0FFF", 0, 3)
        # The longest block name
        x2("\\p{In_Unified_Canadian_Aboriginal_Syllabics_Extended}+", "\u18B0\u18FF", 0, 2)
    x2("[0-9-a]+", " 0123456789-a ", 1, 13)     # same as [0-9\-a]
    x2("[0-9-\\s]+", " 0123456789-a ", 0, 12)   # same as [0-9\-\s]
    x2("(?i:a) B", "a B", 0, 3)
    x2("(?i:a )B", "a B", 0, 3)
    x2("B (?i:a)", "B a", 0, 3)
    x2("B(?i: a)", "B a", 0, 3)
    if is_unicode_encoding(encoding):
        x2("(?a)[\p{Space}\d]", "\u00a0", 0, 1)
        x2("(?a)[\d\p{Space}]", "\u00a0", 0, 1)
        n("(?a)[^\p{Space}\d]", "\u00a0")
        n("(?a)[^\d\p{Space}]", "\u00a0")
    n("x.*?\\Z$", "x\ny")
    n("x.*?\\Z$", "x\r\ny")
    x2("x.*?\\Z$", "x\n", 0, 1)
    x2("x.*?\\Z$", "x\r\n", 0, 2)   # \Z will match between \r and \n.
    x2("(?<=fo).*", "foo", 2, 3)
    x2("(?s)(?<=fo).*", "foo", 2, 3)    #XXX: m -> s
    x2("(?s)(?<=fo).+", "foo", 2, 3)    #XXX: m -> s
    x2("\\n?\\z", "hello", 5, 5)
    x2("\\z", "hello", 5, 5)
    x2("\\n?\\z", "ɂ", 5, 5)
    x2("\\z", "ɂ", 5, 5)
    
    # character classes (tests for character class optimization)
    x2("[@][a]", "@a", 0, 2);
    x2(".*[a][b][c][d][e]", "abcde", 0, 5);
    x2("(?i)[A\\x{41}]", "a", 0, 1);
    x2("[abA]", "a", 0, 1);
    x2("[[ab]&&[ac]]+", "aaa", 0, 3);
    x2("[[]&&[]]+", "", 0, 3);
    
    # possessive quantifiers
    n("a?+a", "a")          # Ver.1.xx fails
    n("a*+a", "aaaa")       # Ver.1.xx fails
    n("a++a", "aaaa")       # Ver.1.xx fails
    n("a{2,3}+a", "aaa")    # Ver.1.xx fails
    
    # linebreak
    x2("\\R", "\n", 0, 1)
    x2("\\R", "\r", 0, 1)
    x2("\\R{3}", "\r\r\n\n", 0, 4)
    
    # extended grapheme cluster
    x2("\\X{5}", "ab\n", 0, 5)
    if is_unicode_encoding(encoding):
        x2("\\X", "\u306F\u309A\n", 0, 2)
    
    # keep
    x2("ab\\Kcd", "abcd", 2, 4)
    x2("ab\\Kc(\\Kd|z)", "abcd", 3, 4)
    x2("ab\\Kc(\\Kz|d)", "abcd", 2, 4)
    x2("(a\\K)*", "aaab", 3, 3)
    x3("(a\\K)*", "aaab", 2, 3, 1)
#    x2("a\\K?a", "aa", 0, 2)        # error: differ from perl
    x2("ab(?=c\Kd)", "abcd", 2, 2)          # This behaviour is currently not well defined. (see: perlre)
    x2("(?<=a\\Kb|aa)cd", "abcd", 1, 4)     # This behaviour is currently not well defined. (see: perlre)
    x2("(?<=ab|a\\Ka)cd", "abcd", 2, 4)     # This behaviour is currently not well defined. (see: perlre)
    
    # named group and subroutine call
    x2("(?<name_2>ab)(?&name_2)", "abab", 0, 4);
    x2("(?<name_2>ab)(?1)", "abab", 0, 4);
    x2("(?<n>|\\((?&n)\\))+$", "()(())", 0, 6);
    x2("(a|x(?-1)x)", "xax", 0, 3);
    x2("(a|(x(?-2)x))", "xax", 0, 3);
    x2("a|x(?0)x", "xax", 0, 3);
    x2("a|x(?R)x", "xax", 0, 3);
    x2("(a|x\g<0>x)", "xax", 0, 3);
    x2("(a|x\g'0'x)", "xax", 0, 3);
    x2("(?-i:(?+1))(?i:(a)){0}", "A", 0, 1);
    x2("(?-i:\g<+1>)(?i:(a)){0}", "A", 0, 1);
    x2("(?-i:\g'+1')(?i:(a)){0}", "A", 0, 1);
    
    # character set modifiers
    x2("(?u)\\w+", "a#", 0, 2);
    x2("(?a)\\w+", "a#", 1, 2);
    x2("(?u)\\W+", "a#", 2, 3);
    x2("(?a)\\W+", "a#", 0, 1);
    
    x2("(?a)\\b", "a", 1, 1);
    x2("(?a)\\w\\b", "a", 0, 1);
    x2("(?a)\\B", "a  ", 2, 2);
    
    x2("(?u)\\B", " ", 2, 2);
    x2("(?a)\\B", " ", 0, 0);
    x2("(?a)\\B", "a ", 2, 2);
    
    x2("(?a)\\p{Alpha}\\P{Alpha}", "aB", 0, 2);
    x2("(?u)\\p{Alpha}\\P{Alpha}", "aB", 0, 2);
    x2("(?a)[[:word:]]+", "a", 0, 1);
    x2("(?a)[[:^word:]]+", "a", 1, 2);
    x2("(?u)[[:word:]]+", "a", 0, 2);
    n("(?u)[[:^word:]]+", "a");
    
    # \g{} backref
    x2("((?<name1>\\d)|(?<name2>\\w))(\\g{name1}|\\g{name2})", "ff", 0, 2);
    x2("(?:(?<x>)|(?<x>efg))\\g{x}", "", 0, 0);
    x2("(?:(?<x>abc)|(?<x>efg))\\g{x}", "abcefgefg", 3, 9);
    n("(?:(?<x>abc)|(?<x>efg))\\g{x}", "abcefg");
    x2("((.*)a\\g{2}f)", "bacbabf", 3, 7);
    x2("(.*)a\\g{1}f", "baczzzzzz\nbazz\nzzzzbabf", 19, 23);
    x2("((.*)a\\g{-1}f)", "bacbabf", 3, 7);
    x2("(.*)a\\g{-1}f", "baczzzzzz\nbazz\nzzzzbabf", 19, 23);
    x2("(*)(*)\\g{-2}\\g{-1}", "", 0, 10);
    
    # Python/PCRE compatible named group
    x2("(?P<name_2>ab)(?P>name_2)", "abab", 0, 4);
    x2("(?P<n>|\\((?P>n)\\))+$", "()(())", 0, 6);
    x2("((?P<name1>\\d)|(?P<name2>\\w))((?P=name1)|(?P=name2))", "ff", 0, 2);
    
    # Fullwidth Alphabet
    n("", "`abcdefghijklmnopqrstuvwxy");
    x2("(?i)", "", 0, 26);
    x2("(?i)", "`abcdefghijklmnopqrstuvwxy", 0, 26);
    x2("(?i)`abcdefghijklmnopqrstuvwxy", "", 0, 26);
    x2("(?i)`abcdefghijklmnopqrstuvwxy", "`abcdefghijklmnopqrstuvwxy", 0, 26);
    
    # Greek
    n("ÃăŃƃǃȃɃʃ˃̃̓΃σЃу҃ӃԃՃ", "");
    x2("(?i)ÃăŃƃǃȃɃʃ˃̃̓΃σЃу҃ӃԃՃ", "ÃăŃƃǃȃɃʃ˃̃̓΃σЃу҃ӃԃՃ", 0, 24);
    x2("(?i)ÃăŃƃǃȃɃʃ˃̃̓΃σЃу҃ӃԃՃ", "", 0, 24);
    x2("(?i)", "ÃăŃƃǃȃɃʃ˃̃̓΃σЃу҃ӃԃՃ", 0, 24);
    x2("(?i)", "", 0, 24);
    
    # Cyrillic
    n("pqrstuvwxyz{|}~", "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`");
    x2("(?i)pqrstuvwxyz{|}~", "pqrstuvwxyz{|}~", 0, 33);
    x2("(?i)pqrstuvwxyz{|}~", "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`", 0, 33);
    x2("(?i)@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`", "pqrstuvwxyz{|}~", 0, 33);
    x2("(?i)@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`", "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`", 0, 33);
    
    # multiple name definition
    x2("(?<a>a)(?<a>b)\\k<a>", "aba", 0, 3)
    x2("(?<a>a)(?<a>b)(?&a)", "aba", 0, 3)
    x2("(?<a>(a|.)(?<a>b))(?&a)", "abcb", 0, 4)
    
    # branch reset
#    x3("(?|(c)|(?:(b)|(a)))", "a", 0, 1, 2)
#    x3("(?|(c)|(?|(b)|(a)))", "a", 0, 1, 1)
    
    # conditional expression
    x2("(?:(a)|(b))(?(1)cd)e", "acde", 0, 4)
    n("(?:(a)|(b))(?(1)cd)e", "ae")
    x2("(?:(a)|(b))(?(2)cd)e", "ae", 0, 2)
    n("(?:(a)|(b))(?(2)cd)e", "acde")
    x2("(?:(a)|(b))(?(1)c|d)", "ac", 0, 2)
    x2("(?:(a)|(b))(?(1)c|d)", "bd", 0, 2)
    n("(?:(a)|(b))(?(1)c|d)", "ad")
    n("(?:(a)|(b))(?(1)c|d)", "bc")
    x2("(?:(a)|(b))(?:(?(1)cd)e|fg)", "acde", 0, 4)
    x2("(?:(a)|(b))(?:(?(1)cd|x)e|fg)", "bxe", 0, 3)
    n("(?:(a)|(b))(?:(?(2)cd|x)e|fg)", "bxe")
    x2("(?:(?<x>a)|(?<y>b))(?:(?(<x>)cd|x)e|fg)", "bxe", 0, 3)
    n("(?:(?<x>a)|(?<y>b))(?:(?(<y>)cd|x)e|fg)", "bxe")
    x2("((?<=a))?(?(1)b|c)", "abc", 1, 2)
    x2("((?<=a))?(?(1)b|c)", "bc", 1, 2)
    x2("((?<x>x)|(?<y>y))(?(<x>)y|x)", "xy", 0, 2)
    x2("((?<x>x)|(?<y>y))(?(<x>)y|x)", "yx", 0, 2)
    n("((?<x>x)|(?<y>y))(?(<x>)y|x)", "xx")
    n("((?<x>x)|(?<y>y))(?(<x>)y|x)", "yy")
    
    # Implicit-anchor optimization
    x2("(?s:.*abc)", "dddabdd\nddabc", 0, 13)   # optimized /(?s:.*abc)/ ==> /\A(?s:.*abc)/
    x2("(?s:.+abc)", "dddabdd\nddabc", 0, 13)   # optimized
    x2("(?-s:.*abc)", "dddabdd\nddabc", 8, 13)  # optimized /(?-s:.*abc)/ ==> /(?:^|\A)(?s:.*abc)/
    x2("(?-s:.+abc)", "dddabdd\nddabc", 8, 13)  # optimized
    x2("(?-s:.*abc)", "dddabdd\nabc", 8, 11)    # optimized
    n("(?-s:.+abc)", "dddabdd\nabc")            # optimized
    x2("(?s:.*\\Z)", "dddabdd\nddabc", 0, 13)   # optimized /(?s:.*\Z)/ ==> /\A(?s:.*\Z)/
    x2("(?-s:.*\\Z)", "dddabdd\nddabc", 8, 13)  # optimized /(?-s:.*\Z)/ ==> /(?:^|\A)(?s:.*\Z)/
    x2("(.*)X\\1", "1234X2345", 1, 8)           # not optimized
    
    # Allow options in look-behind
    x2("(?<=(?i)ab)cd", "ABcd", 2, 4)
    x2("(?<=(?i:ab))cd", "ABcd", 2, 4)
    n("(?<=(?i)ab)cd", "ABCD")
    n("(?<=(?i:ab))cd", "ABCD")
    x2("(?<!(?i)ab)cd", "aacd", 2, 4)
    x2("(?<!(?i:ab))cd", "aacd", 2, 4)
    n("(?<!(?i)ab)cd", "ABcd")
    n("(?<!(?i:ab))cd", "ABcd")
    
    
    print("\nRESULT   SUCC: %d,  FAIL: %d,  ERROR: %d\n" % (
           nsucc, nfail, nerror))


if __name__ == '__main__':
    main()

