/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

class RBlank
extends BaseBoundableRenderable {
    public final int ascentPlusLeading;
    private final FontMetrics fontMetrics;

    public RBlank(ModelNode me2, FontMetrics fm2, RenderableContainer container, int ascentPlusLeading, int width, int height) {
        super(container, me2);
        this.fontMetrics = fm2;
        this.ascentPlusLeading = ascentPlusLeading;
        this.width = width;
        this.height = height;
    }

    protected void invalidateLayoutLocal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g10) {
        Color over;
        int td2;
        RenderState rs2 = this.modelNode.getRenderState();
        Color bkg = rs2.getTextBackgroundColor();
        if (bkg != null) {
            Color oldColor = g10.getColor();
            try {
                g10.setColor(bkg);
                g10.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g10.setColor(oldColor);
            }
        }
        if ((td2 = rs2.getTextDecorationMask()) != 0) {
            if ((td2 & 1) != 0) {
                int lineOffset = this.ascentPlusLeading + 2;
                g10.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td2 & 4) != 0) {
                FontMetrics fm2 = this.fontMetrics;
                int lineOffset = fm2.getLeading() + (fm2.getAscent() + fm2.getDescent()) / 2;
                g10.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td2 & 2) != 0) {
                int lineOffset = this.fontMetrics.getLeading();
                g10.drawLine(0, lineOffset, this.width, lineOffset);
            }
            if ((td2 & 8) != 0) {
                // empty if block
            }
        }
        if ((over = rs2.getOverlayColor()) != null) {
            Color oldColor = g10.getColor();
            try {
                g10.setColor(over);
                g10.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g10.setColor(oldColor);
            }
        }
    }

    public boolean paintSelection(Graphics g10, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        if (this == startPoint.renderable || this == endPoint.renderable ? inSelection : !inSelection) {
            return false;
        }
        g10.setColor(SELECTION_COLOR);
        g10.setXORMode(SELECTION_XOR);
        g10.fillRect(0, 0, this.width, this.height);
        g10.setPaintMode();
        return true;
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        if (this == startPoint.renderable || this == endPoint.renderable ? inSelection : !inSelection) {
            return false;
        }
        buffer.append(' ');
        return true;
    }

    public RenderableSpot getLowestRenderableSpot(int x10, int y10) {
        return new RenderableSpot(this, x10, y10);
    }
}

