/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.config.ConfigMap;
import flex.messaging.security.MessagingSecurity;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.messaging.Subtopic;
import flex.messaging.services.messaging.adapters.MessagingSecurityConstraintManager;

public abstract class MessagingAdapter
extends ServiceAdapter
implements MessagingSecurity {
    private MessagingSecurityConstraintManager constraintManager;

    public MessagingAdapter() {
        this(false);
    }

    public MessagingAdapter(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id2, ConfigMap properties) {
        super.initialize(id2, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        ConfigMap serverSettings = properties.getPropertyAsMap("server", null);
        if (serverSettings != null) {
            String ref;
            ConfigMap subscribe;
            String ref2;
            ConfigMap send = serverSettings.getPropertyAsMap("send-security-constraint", null);
            if (send != null && (ref2 = send.getPropertyAsString("ref", null)) != null) {
                if (this.constraintManager == null) {
                    this.constraintManager = new MessagingSecurityConstraintManager(this.getDestination().getService().getMessageBroker());
                }
                this.constraintManager.createSendConstraint(ref2);
            }
            if ((subscribe = serverSettings.getPropertyAsMap("subscribe-security-constraint", null)) != null && (ref = subscribe.getPropertyAsString("ref", null)) != null) {
                if (this.constraintManager == null) {
                    this.constraintManager = new MessagingSecurityConstraintManager(this.getDestination().getService().getMessageBroker());
                }
                this.constraintManager.createSubscribeConstraint(ref);
            }
        }
    }

    protected void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
    }

    public boolean allowSubscribe(Subtopic subtopic) {
        return true;
    }

    public boolean allowSend(Subtopic subtopic) {
        return true;
    }

    public MessagingSecurityConstraintManager getSecurityConstraintManager() {
        return this.constraintManager;
    }

    public void setSecurityConstraintManager(MessagingSecurityConstraintManager constraintManager) {
        this.constraintManager = constraintManager;
    }
}

