/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.MessageException;
import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.services.messaging.adapters.JMSConsumer;
import flex.messaging.services.messaging.adapters.JMSSettings;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;

public class JMSTopicConsumer
extends JMSConsumer {
    protected boolean durableConsumers;
    protected String durableSubscriptionName;

    public void initialize(JMSSettings settings) {
        super.initialize(settings);
        this.durableConsumers = settings.useDurableConsumers();
    }

    protected void validate() {
        super.validate();
        if (this.durableConsumers && this.durableSubscriptionName == null) {
            ConfigurationException ce2 = new ConfigurationException();
            ce2.setMessage(10823, new Object[]{this.destinationJndiName});
            throw ce2;
        }
    }

    public void start() throws NamingException, JMSException {
        TopicConnectionFactory topicFactory;
        Topic topic;
        super.start();
        try {
            topic = (Topic)this.destination;
        }
        catch (ClassCastException cce) {
            MessageException me2 = new MessageException();
            me2.setMessage(10815, new Object[]{this.destinationJndiName, this.destination.getClass().getName()});
            throw me2;
        }
        try {
            topicFactory = (TopicConnectionFactory)this.connectionFactory;
            this.connection = this.connectionCredentials != null ? topicFactory.createTopicConnection(this.connectionCredentials.getUsername(), this.connectionCredentials.getPassword()) : topicFactory.createTopicConnection();
        }
        catch (ClassCastException cce) {
            MessageException me3 = new MessageException();
            me3.setMessage(10816, new Object[]{this.destinationJndiName, this.connectionFactory.getClass().getName()});
            throw me3;
        }
        TopicConnection topicConnection = (TopicConnection)this.connection;
        if (this.durableConsumers) {
            try {
                if (Log.isDebug()) {
                    Log.getLogger("Service.Message.JMS").debug("JMS consumer for JMS destination '" + this.destinationJndiName + "' is setting its underlying connection's client id to " + this.durableSubscriptionName + " for durable subscription.");
                }
                topicConnection.setClientID(this.durableSubscriptionName);
            }
            catch (Exception e10) {
                ExecutorService clientIdSetter = Executors.newSingleThreadExecutor();
                ClientIdSetterCallable cisc = new ClientIdSetterCallable(topicFactory, this.durableSubscriptionName);
                Future future = clientIdSetter.submit(cisc);
                try {
                    topicConnection = (TopicConnection)future.get();
                }
                catch (InterruptedException ie2) {
                    if (Log.isWarn()) {
                        Log.getLogger("Service.Message.JMS").warn("The proxied durable JMS subscription with name, " + this.durableSubscriptionName + " could not set its client id " + "on the topic connection because it was interrupted: " + ie2.toString());
                    }
                }
                catch (ExecutionException ee2) {
                    MessageException me4 = new MessageException();
                    me4.setMessage(10819, new Object[]{this.destinationJndiName});
                    throw me4;
                }
            }
        }
        this.session = topicConnection.createTopicSession(false, this.getAcknowledgeMode());
        TopicSession topicSession = (TopicSession)this.session;
        this.consumer = this.selectorExpression != null ? (this.durableConsumers && this.durableSubscriptionName != null ? topicSession.createDurableSubscriber(topic, this.durableSubscriptionName, this.selectorExpression, false) : topicSession.createSubscriber(topic, this.selectorExpression, false)) : (this.durableConsumers && this.durableSubscriptionName != null ? topicSession.createDurableSubscriber(topic, this.durableSubscriptionName) : topicSession.createSubscriber(topic));
        this.startMessageReceiver();
    }

    public void stop(boolean unsubscribe) {
        block8: {
            if (unsubscribe) {
                block7: {
                    this.stopMessageReceiver();
                    try {
                        if (this.consumer != null) {
                            this.consumer.close();
                        }
                    }
                    catch (Exception e10) {
                        if (!Log.isWarn()) break block7;
                        Log.getLogger("Service.Message.JMS").warn("JMS consumer for JMS destination '" + this.destinationJndiName + "' received an error while closing its underlying MessageConsumer: " + e10.getMessage());
                    }
                }
                if (this.durableConsumers) {
                    try {
                        TopicSession topicSession = (TopicSession)this.session;
                        topicSession.unsubscribe(this.durableSubscriptionName);
                    }
                    catch (Exception e11) {
                        if (!Log.isWarn()) break block8;
                        Log.getLogger("Service.Message.JMS").warn("The proxied durable JMS subscription with name, " + this.durableSubscriptionName + " failed to unsubscribe : " + e11.toString());
                    }
                }
            }
        }
        super.stop();
    }

    public boolean isDurableConsumers() {
        return this.durableConsumers;
    }

    public void setDurableConsumers(boolean durableConsumers) {
        this.durableConsumers = durableConsumers;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    class ClientIdSetterCallable
    implements Callable {
        private TopicConnectionFactory tcf;
        private String clientId;
        private TopicConnection topicConnection;

        public ClientIdSetterCallable(TopicConnectionFactory tcf, String clientId) {
            this.tcf = tcf;
            this.clientId = clientId;
        }

        public Object call() throws JMSException {
            this.topicConnection = this.tcf.createTopicConnection();
            this.topicConnection.setClientID(this.clientId);
            return this.topicConnection;
        }
    }
}

