/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import flex.messaging.FlexComponent;
import flex.messaging.FlexContext;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.security.AppServerLoginCommand;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.LoginCommandExt;
import flex.messaging.security.SecurityException;
import java.security.Principal;
import java.util.List;

public class LoginManager
implements FlexComponent {
    public static final String LOG_CATEGORY = "Security";
    private static final int INVALID_LOGIN = 10050;
    private static final int LOGIN_REQ = 10051;
    private static final int NO_LOGIN_COMMAND = 10053;
    private static final int CANNOT_REAUTH = 10054;
    private static final int ACCESS_DENIED = 10055;
    private static final int LOGIN_REQ_FOR_AUTH = 10056;
    private static final int NO_BASIC_SECURITY = 10057;
    private static final int PER_CLIENT_ANT_APPSERVER = 10065;
    private LoginCommand loginCommand;
    private boolean perClientAuthentication = false;
    private boolean started;

    public void initialize(String id2, ConfigMap configMap) {
    }

    protected void validate() {
        if (this.perClientAuthentication && this.loginCommand instanceof AppServerLoginCommand) {
            ConfigurationException configException = new ConfigurationException();
            configException.setMessage(10065);
            throw configException;
        }
    }

    public void start() {
        if (!this.started) {
            this.validate();
            if (this.loginCommand != null) {
                this.loginCommand.start(FlexContext.getServletConfig());
            }
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            if (this.loginCommand != null) {
                this.loginCommand.stop();
            }
            this.started = false;
        }
    }

    public boolean isPerClientAuthentication() {
        return this.perClientAuthentication;
    }

    public void setPerClientAuthentication(boolean perClientAuthentication) {
        this.perClientAuthentication = perClientAuthentication;
    }

    public boolean isStarted() {
        return this.started;
    }

    public LoginCommand getLoginCommand() {
        return this.loginCommand;
    }

    public void setLoginCommand(LoginCommand value) {
        if (this.loginCommand == value) {
            return;
        }
        this.loginCommand = value;
        if (this.started) {
            this.loginCommand.start(FlexContext.getServletConfig());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void login(String username, Object credentials) {
        if (this.getCurrentPrincipal() == null) {
            if (this.loginCommand == null) {
                SecurityException se2 = new SecurityException();
                se2.setMessage(10053);
                se2.setCode("Server.Authentication");
                throw se2;
            }
            if (username != null && credentials != null) {
                Principal authenticated = this.loginCommand.doAuthentication(username, credentials);
                if (authenticated == null) {
                    SecurityException se3 = new SecurityException();
                    se3.setMessage(10050);
                    se3.setCode("Client.Authentication");
                    throw se3;
                }
                this.setCurrentPrincipal(authenticated);
                return;
            }
            SecurityException se4 = new SecurityException();
            se4.setMessage(10051);
            se4.setCode("Client.Authentication");
            throw se4;
        }
        String comparisonUsername = this.loginCommand instanceof LoginCommandExt ? ((LoginCommandExt)((Object)this.loginCommand)).getPrincipalNameFromCredentials(username, credentials) : username;
        if (comparisonUsername == null) return;
        if (comparisonUsername.equals(this.getCurrentPrincipal().getName())) return;
        SecurityException se5 = new SecurityException();
        se5.setMessage(10054);
        se5.setCode("Client.Authentication");
        throw se5;
    }

    public void logout() {
        if (this.loginCommand != null) {
            this.loginCommand.logout(this.getCurrentPrincipal());
            if (FlexContext.isPerClientAuthentication()) {
                FlexContext.setUserPrincipal(null);
            } else {
                FlexContext.getFlexSession().invalidate();
            }
        } else {
            FlexContext.getFlexSession().invalidate();
            SecurityException se2 = new SecurityException();
            se2.setMessage(10053);
            se2.setCode("Server.Authorization");
            throw se2;
        }
    }

    public void checkConstraint(SecurityConstraint constraint) {
        if (constraint == null) {
            return;
        }
        Principal currentPrincipal = this.getCurrentPrincipal();
        if (currentPrincipal != null) {
            boolean authorized;
            List roles = constraint.getRoles();
            boolean bl2 = authorized = roles == null || this.checkRoles(currentPrincipal, roles);
            if (!authorized) {
                SecurityException se2 = new SecurityException();
                se2.setMessage(10055);
                se2.setCode("Client.Authorization");
                throw se2;
            }
        } else {
            if (!this.isCustomAuth(constraint)) {
                if (FlexContext.getHttpResponse() == null) {
                    Endpoint endpoint = FlexContext.getEndpoint();
                    String endpointId = endpoint != null ? endpoint.getId() : "unknown";
                    SecurityException se3 = new SecurityException();
                    se3.setMessage(10057, new Object[]{constraint.getId(), endpointId});
                    se3.setCode("Client.Authorization");
                    throw se3;
                }
                FlexContext.getHttpResponse().setStatus(401);
                FlexContext.getHttpResponse().addHeader("WWW-Authenticate", "Basic realm=\"default\"");
            }
            SecurityException se4 = new SecurityException();
            se4.setMessage(10056);
            se4.setCode("Client.Authentication");
            throw se4;
        }
    }

    public boolean checkRoles(Principal principal, List roles) {
        if (this.loginCommand == null) {
            if (Log.isWarn()) {
                Log.getLogger(LOG_CATEGORY).warn("Login command is null. Please ensure that the login-command tag has the correct server attribute value, or use 'all' to use the login command regardless of the server.");
            }
            return false;
        }
        return this.loginCommand.doAuthorization(principal, roles);
    }

    private Principal getCurrentPrincipal() {
        return FlexContext.getUserPrincipal();
    }

    private void setCurrentPrincipal(Principal p10) {
        FlexContext.setUserPrincipal(p10);
    }

    private boolean isCustomAuth(SecurityConstraint constraint) {
        return "Custom".equals(constraint.getMethod());
    }
}

