/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.log.Log;
import flex.messaging.messages.AbstractMessage;
import flex.messaging.messages.AsyncMessageExt;
import flex.messaging.messages.Message;
import flex.messaging.messages.SmallMessage;
import flex.messaging.util.UUIDUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AsyncMessage
extends AbstractMessage
implements SmallMessage {
    private static final long serialVersionUID = -3549535089417916783L;
    public static final String SUBTOPIC_HEADER_NAME = "DSSubtopic";
    private static byte CORRELATION_ID_FLAG = 1;
    private static byte CORRELATION_ID_BYTES_FLAG = (byte)2;
    protected String correlationId;
    protected byte[] correlationIdBytes;

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public Message getSmallMessage() {
        if (this.getClass() == AsyncMessage.class) {
            return new AsyncMessageExt(this);
        }
        return null;
    }

    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readExternal(input);
        short[] flagsArray = this.readFlags(input);
        for (int i10 = 0; i10 < flagsArray.length; ++i10) {
            short flags = flagsArray[i10];
            int reservedPosition = 0;
            if (i10 == 0) {
                if ((flags & CORRELATION_ID_FLAG) != 0) {
                    this.correlationId = (String)input.readObject();
                }
                if ((flags & CORRELATION_ID_BYTES_FLAG) != 0) {
                    this.correlationIdBytes = (byte[])input.readObject();
                    this.correlationId = UUIDUtils.fromByteArray(this.correlationIdBytes);
                }
                reservedPosition = 2;
            }
            if (flags >> reservedPosition == 0) continue;
            for (int j10 = reservedPosition; j10 < 6; j10 = (int)((short)(j10 + 1))) {
                if ((flags >> j10 & 1) == 0) continue;
                input.readObject();
            }
        }
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        if (this.correlationIdBytes == null && this.correlationId != null) {
            this.correlationIdBytes = UUIDUtils.toByteArray(this.correlationId);
        }
        short flags = 0;
        if (this.correlationId != null && this.correlationIdBytes == null) {
            flags = (short)(flags | CORRELATION_ID_FLAG);
        }
        if (this.correlationIdBytes != null) {
            flags = (short)(flags | CORRELATION_ID_BYTES_FLAG);
        }
        output.writeByte(flags);
        if (this.correlationId != null && this.correlationIdBytes == null) {
            output.writeObject(this.correlationId);
        }
        if (this.correlationIdBytes != null) {
            output.writeObject(this.correlationIdBytes);
        }
    }

    protected String toStringFields(int indentLevel) {
        String sep = this.getFieldSeparator(indentLevel);
        String s10 = sep + "clientId = " + (Log.isExcludedProperty("clientId") ? "** [Value Suppressed] **" : this.clientId);
        s10 = s10 + sep + "correlationId = " + (Log.isExcludedProperty("correlationId") ? "** [Value Suppressed] **" : this.correlationId);
        s10 = s10 + sep + "destination = " + (Log.isExcludedProperty("destination") ? "** [Value Suppressed] **" : this.destination);
        s10 = s10 + sep + "messageId = " + (Log.isExcludedProperty("messageId") ? "** [Value Suppressed] **" : this.messageId);
        s10 = s10 + sep + "timestamp = " + (Log.isExcludedProperty("timestamp") ? "** [Value Suppressed] **" : String.valueOf(this.timestamp));
        s10 = s10 + sep + "timeToLive = " + (Log.isExcludedProperty("timeToLive") ? "** [Value Suppressed] **" : String.valueOf(this.timeToLive));
        s10 = s10 + sep + "body = " + (Log.isExcludedProperty("body") ? "** [Value Suppressed] **" : this.bodyToString(this.body, indentLevel));
        s10 = s10 + super.toStringFields(indentLevel);
        return s10;
    }
}

