/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.log;

import flex.messaging.log.Log;
import flex.messaging.log.LogEvent;
import flex.messaging.log.Target;
import flex.messaging.util.PrettyPrinter;
import flex.messaging.util.StringUtils;
import java.util.ArrayList;

public class Logger {
    private volatile String category;
    private final ArrayList targets;

    public Logger(String category) {
        this.category = category;
        this.targets = new ArrayList();
    }

    public String getCategory() {
        return this.category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTarget() {
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            return this.targets != null && !this.targets.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTarget(Target target) {
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            if (!this.targets.contains(target)) {
                this.targets.add(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTarget(Target target) {
        ArrayList arrayList = this.targets;
        synchronized (arrayList) {
            this.targets.remove(target);
        }
    }

    public void debug(String message) {
        this.log((short)2, message, null, null);
    }

    public void debug(String message, Throwable t10) {
        this.log((short)2, message, null, t10);
    }

    public void debug(String message, Object[] parameters) {
        this.log((short)2, message, parameters, null);
    }

    public void debug(String message, Object[] parameters, Throwable t10) {
        this.log((short)2, message, parameters, t10);
    }

    public void info(String message) {
        this.log((short)4, message, null, null);
    }

    public void info(String message, Throwable t10) {
        this.log((short)4, message, null, t10);
    }

    public void info(String message, Object[] parameters) {
        this.log((short)4, message, parameters, null);
    }

    public void info(String message, Object[] parameters, Throwable t10) {
        this.log((short)4, message, parameters, t10);
    }

    public void warn(String message) {
        this.log((short)6, message, null, null);
    }

    public void warn(String message, Throwable t10) {
        this.log((short)6, message, null, t10);
    }

    public void warn(String message, Object[] parameters) {
        this.log((short)6, message, parameters, null);
    }

    public void warn(String message, Object[] parameters, Throwable t10) {
        this.log((short)6, message, parameters, t10);
    }

    public void error(String message) {
        this.log((short)8, message, null, null);
    }

    public void error(String message, Throwable t10) {
        this.log((short)8, message, null, t10);
    }

    public void error(String message, Object[] parameters) {
        this.log((short)8, message, parameters, null);
    }

    public void error(String message, Object[] parameters, Throwable t10) {
        this.log((short)8, message, parameters, t10);
    }

    public void fatal(String message) {
        this.log((short)1000, message, null, null);
    }

    public void fatal(String message, Throwable t10) {
        this.log((short)1000, message, null, t10);
    }

    public void fatal(String message, Object[] parameters) {
        this.log((short)1000, message, parameters, null);
    }

    public void fatal(String message, Object[] parameters, Throwable t10) {
        this.log((short)1000, message, parameters, t10);
    }

    public void log(short level, String message, Object[] parameters, Throwable t10) {
        this.log(level, message, parameters, t10, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(short level, String message, Object[] parameters, Throwable t10, boolean verifyLevel) {
        if (!(this.targets.size() <= 0 || verifyLevel && level < Log.getTargetLevel())) {
            if (parameters != null) {
                PrettyPrinter prettyPrinter = Log.getPrettyPrinter();
                for (int i10 = 0; i10 < parameters.length; ++i10) {
                    String replacement = parameters[i10] != null ? prettyPrinter.prettify(parameters[i10]) : "null";
                    message = StringUtils.substitute(message, "{" + i10 + "}", replacement);
                }
            }
            LogEvent event = new LogEvent(this, message, level, t10);
            ArrayList arrayList = this.targets;
            synchronized (arrayList) {
                for (Target tgt : this.targets) {
                    if (verifyLevel && level < tgt.getLevel()) continue;
                    tgt.logEvent(event);
                }
            }
        }
    }
}

