/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.io.amfx.AmfxTypes;
import flex.messaging.util.Hex;
import flex.messaging.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class AmfxOutput
extends AbstractAmfOutput
implements AmfxTypes {
    protected IdentityHashMap objectTable = new IdentityHashMap(64);
    protected HashMap traitsTable = new HashMap(10);
    protected HashMap stringTable = new HashMap(64);

    public AmfxOutput(SerializationContext context) {
        super(context);
    }

    public void reset() {
        super.reset();
        this.objectTable.clear();
        this.traitsTable.clear();
        this.stringTable.clear();
    }

    protected Amf3Output createAMF3Output() {
        return new Amf3Output(this.context);
    }

    public void writeObject(Object o10) throws IOException {
        if (o10 == null) {
            this.writeAMFNull();
            return;
        }
        if (!this.context.legacyExternalizable && o10 instanceof Externalizable) {
            this.writeCustomObject(o10);
        } else if (o10 instanceof String || o10 instanceof Character) {
            String s10 = o10.toString();
            this.writeString(s10);
        } else if (o10 instanceof Number) {
            if (o10 instanceof Integer || o10 instanceof Short || o10 instanceof Byte) {
                int i10 = ((Number)o10).intValue();
                this.writeAMFInt(i10);
            } else if (!this.context.legacyBigNumbers && (o10 instanceof BigInteger || o10 instanceof BigDecimal)) {
                this.writeString(((Number)o10).toString());
            } else {
                double d10 = ((Number)o10).doubleValue();
                this.writeAMFDouble(d10);
            }
        } else if (o10 instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o10);
        } else if (o10 instanceof Date) {
            this.writeDate((Date)o10);
        } else if (o10 instanceof Calendar) {
            this.writeDate(((Calendar)o10).getTime());
        } else if (o10 instanceof Document) {
            String xml = this.documentToString(o10);
            int len = xml.length() + 15;
            StringBuffer sb2 = new StringBuffer(len);
            sb2.append("<xml>");
            this.writeEscapedString(sb2, xml);
            sb2.append("</xml>");
            this.writeUTF(sb2);
            if (this.isDebug) {
                this.trace.writeString(xml);
            }
        } else if (o10 instanceof Enum && PropertyProxyRegistry.getRegistry().getProxy(o10.getClass()) == null) {
            Enum enumValue = (Enum)o10;
            this.writeString(enumValue.name());
        } else {
            Class<?> cls = o10.getClass();
            if (o10 instanceof Map && this.context.legacyMap && !(o10 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o10);
            } else if (o10 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o10, null);
                } else {
                    this.writeArrayCollection((Collection)o10, null);
                }
            } else if (cls.isArray()) {
                this.writeAMFArray(o10, cls.getComponentType());
            } else {
                if (o10 instanceof RowSet) {
                    o10 = new PagedRowSet((RowSet)o10, Integer.MAX_VALUE, false);
                } else if (o10 instanceof Throwable && this.context.legacyThrowable) {
                    o10 = new StatusInfoProxy((Throwable)o10);
                }
                this.writeCustomObject(o10);
            }
        }
    }

    public void writeObjectTraits(TraitsInfo ti2) throws IOException {
        String className = ti2.getClassName();
        if (className == null || className.length() == 0) {
            this.writeUTF("<object>");
        } else {
            int len = 127;
            StringBuffer sb2 = new StringBuffer(len);
            sb2.append("<").append("object").append(" type=\"");
            sb2.append(className);
            sb2.append("\">");
            this.writeUTF(sb2);
        }
        if (this.isDebug) {
            this.trace.startAMFObject(className, this.objectTable.size() - 1);
        }
        if (ti2.length() == 0 && className == null) {
            this.writeUTF("<traits/>");
        } else if (!this.byReference(ti2)) {
            if (ti2.isExternalizable()) {
                this.writeUTF("<traits externalizable=\"true\" />");
            } else {
                int count = ti2.getProperties().size();
                if (count <= 0) {
                    this.writeUTF("<traits/>");
                } else {
                    this.writeUTF("<traits>");
                    for (int i10 = 0; i10 < count; ++i10) {
                        String propName = ti2.getProperty(i10);
                        this.writeString(propName, true);
                    }
                    this.writeUTF("</traits>");
                }
            }
        }
    }

    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.writeObject(value);
    }

    public void writeObjectEnd() throws IOException {
        this.writeUTF("</object>");
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    public void writeUTF(String s10) throws IOException {
        byte[] bytes = s10.getBytes("UTF-8");
        this.out.write(bytes);
    }

    protected void writeAMFBoolean(boolean b10) throws IOException {
        if (b10) {
            this.writeUTF("<true/>");
        } else {
            this.writeUTF("<false/>");
        }
        if (this.isDebug) {
            this.trace.write(b10);
        }
    }

    protected void writeAMFDouble(double d10) throws IOException {
        int buflen = 40;
        StringBuffer sb2 = new StringBuffer(buflen);
        sb2.append("<double>");
        sb2.append(d10);
        sb2.append("</double>");
        this.writeUTF(sb2);
        if (this.isDebug) {
            this.trace.write(d10);
        }
    }

    protected void writeAMFInt(int i10) throws IOException {
        int buflen = 25;
        StringBuffer sb2 = new StringBuffer(buflen);
        sb2.append("<int>");
        sb2.append(i10);
        sb2.append("</int>");
        this.writeUTF(sb2);
        if (this.isDebug) {
            this.trace.write(i10);
        }
    }

    protected void writeByteArray(byte[] ba) throws IOException {
        int length = ba.length * 2;
        int len = 23 + length;
        StringBuffer sb2 = new StringBuffer(len);
        sb2.append("<bytearray>");
        this.writeUTF(sb2);
        Hex.Encoder encoder = new Hex.Encoder(ba.length * 2);
        encoder.encode(ba);
        String encoded = encoder.drain();
        this.writeUTF(encoded);
        this.writeUTF("</bytearray>");
        if (this.isDebug) {
            this.trace.startByteArray(this.objectTable.size() - 1, ba.length);
        }
    }

    protected void writeByteArray(Byte[] ba) throws IOException {
        int length = ba.length;
        byte[] bytes = new byte[length];
        for (int i10 = 0; i10 < length; ++i10) {
            Byte b10 = ba[i10];
            bytes[i10] = b10 == null ? (byte)0 : ba[i10];
        }
        this.writeByteArray(bytes);
    }

    public void writeUTF(StringBuffer sb2) throws IOException {
        byte[] bytes = sb2.toString().getBytes("UTF-8");
        this.out.write(bytes);
    }

    protected void writeDate(Date d10) throws IOException {
        if (!this.byReference(d10)) {
            int buflen = 30;
            long time = d10.getTime();
            StringBuffer sb2 = new StringBuffer(buflen);
            sb2.append("<date>");
            sb2.append(time);
            sb2.append("</date>");
            this.writeUTF(sb2);
            if (this.isDebug) {
                this.trace.write(d10);
            }
        }
    }

    protected void writeMapAsECMAArray(Map map) throws IOException {
        int len = 20;
        StringBuffer sb2 = new StringBuffer(len);
        sb2.append("<").append("array").append(" ecma=\"true\">");
        this.writeUTF(sb2);
        if (this.isDebug) {
            this.trace.startAMFArray(this.objectTable.size() - 1);
        }
        for (Object key : map.keySet()) {
            if (key == null) continue;
            String propName = key.toString();
            sb2 = new StringBuffer();
            sb2.append("<").append("item").append(" name=\"").append(propName).append("\">");
            this.writeUTF(sb2);
            if (this.isDebug) {
                this.trace.namedElement(propName);
            }
            this.writeObject(map.get(key));
            this.writeUTF("</item>");
        }
        this.writeUTF("</array>");
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
    }

    protected void writeAMFNull() throws IOException {
        this.writeUTF("<null/>");
        if (this.isDebug) {
            this.trace.writeNull();
        }
    }

    protected void writeString(String s10) throws IOException {
        this.writeString(s10, false);
        if (this.isDebug) {
            this.trace.writeString(s10);
        }
    }

    protected void writeAMFArray(Object o10, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o10);
        } else if (componentType.equals(Byte.class)) {
            this.writeByteArray((Byte[])o10);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o10);
        } else {
            this.writeObjectArray((Object[])o10, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        if (!this.byReference(col)) {
            ArrayCollection ac2;
            if (col instanceof ArrayCollection) {
                ac2 = (ArrayCollection)col;
            } else {
                ac2 = new ArrayCollection(col);
                if (desc != null) {
                    ac2.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac2);
            this.writePropertyProxy(proxy, ac2);
        }
    }

    protected void writeCustomObject(Object o10) throws IOException {
        PropertyProxy proxy = null;
        if (o10 instanceof PropertyProxy) {
            proxy = (PropertyProxy)o10;
            if ((o10 = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o10 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o10, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o10, proxy.getDescriptor());
                }
                return;
            }
            if (o10.getClass().isArray()) {
                this.writeObjectArray((Object[])o10, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o10 instanceof Map && !(o10 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o10);
                return;
            }
        }
        if (!this.byReference(o10)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o10);
            }
            this.writePropertyProxy(proxy, o10);
        }
    }

    protected void writePropertyProxy(PropertyProxy pp2, Object instance) throws IOException {
        Object newInst = pp2.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + pp2.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            pp2 = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        List propertyNames = null;
        boolean externalizable = pp2.isExternalizable(instance);
        if (!externalizable) {
            propertyNames = pp2.getPropertyNames(instance);
            if (pp2 instanceof BeanProxy) {
                BeanProxy bp2 = (BeanProxy)pp2;
                Iterator it2 = propertyNames.iterator();
                while (it2.hasNext()) {
                    String propName = (String)it2.next();
                    if (!bp2.isWriteOnly(instance, propName)) continue;
                    it2.remove();
                }
            }
        }
        TraitsInfo ti2 = new TraitsInfo(pp2.getAlias(instance), pp2.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti2);
        if (externalizable) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            Amf3Output objOut = this.createAMF3Output();
            objOut.setOutputStream(bout);
            ((Externalizable)instance).writeExternal(objOut);
            this.writeByteArray(bout.toByteArray());
        } else if (propertyNames != null) {
            for (String propName : propertyNames) {
                Object value = pp2.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writeString(String s10, boolean isTrait) throws IOException {
        if (s10.length() == 0) {
            this.writeUTF("<string/>");
        } else if (!this.byReference(s10)) {
            int len = s10.length() + 35;
            StringBuffer sb2 = new StringBuffer(len);
            sb2.append("<string>");
            if (!isTrait) {
                this.writeEscapedString(sb2, s10);
            } else {
                sb2.append(s10);
            }
            sb2.append("</string>");
            this.writeUTF(sb2);
        }
    }

    protected void writeEscapedString(StringBuffer sb2, String s10) {
        StringBuffer temp = new StringBuffer(s10.length());
        char[] chars = s10.toCharArray();
        for (int i10 = 0; i10 < chars.length; ++i10) {
            char c10 = chars[i10];
            if (c10 >= ' ') {
                if (c10 == '&') {
                    temp.append("&amp;");
                    continue;
                }
                if (c10 == '<') {
                    temp.append("&lt;");
                    continue;
                }
                if (c10 > '\ud7ff' && (c10 < '\ue000' || c10 > '\ufffd')) {
                    temp.append("&#x").append(Integer.toHexString(c10)).append(";");
                    continue;
                }
                temp.append(c10);
                continue;
            }
            if (c10 == '\t' || c10 == '\n' || c10 == '\r') {
                temp.append(c10);
                continue;
            }
            temp.append("&#x").append(Integer.toHexString(c10)).append(";");
        }
        sb2.append(temp);
    }

    protected void writeCharArrayAsString(Character[] ca) throws IOException {
        int length = ca.length;
        char[] chars = new char[length];
        for (int i10 = 0; i10 < length; ++i10) {
            Character c10 = ca[i10];
            chars[i10] = c10 == null ? (char)'\u0000' : ca[i10].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca) throws IOException {
        String str = new String(ca);
        this.writeString(str);
    }

    protected void writeCollection(Collection c10, SerializationDescriptor descriptor) throws IOException {
        if (!this.byReference(c10)) {
            this.writeObjectArrayDirectly(c10.toArray(), descriptor);
        }
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        if (!this.byReference(values)) {
            this.writeObjectArrayDirectly(values, descriptor);
        }
    }

    protected void writeObjectArrayDirectly(Object[] values, SerializationDescriptor descriptor) throws IOException {
        int len = 25;
        StringBuffer sb2 = new StringBuffer(len);
        sb2.append("<").append("array").append(" length=\"");
        sb2.append(values.length);
        sb2.append("\">");
        this.writeUTF(sb2);
        if (this.isDebug) {
            this.trace.startAMFArray(this.objectTable.size() - 1);
        }
        for (int i10 = 0; i10 < values.length; ++i10) {
            if (this.isDebug) {
                this.trace.arrayElement(i10);
            }
            this.writeObject(values[i10]);
        }
        this.writeUTF("</array>");
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        Class<?> aType = obj.getClass().getComponentType();
        if (aType.equals(Character.TYPE)) {
            char[] c10 = (char[])obj;
            this.writeCharArrayAsString(c10);
        } else if (aType.equals(Byte.TYPE)) {
            this.writeByteArray((byte[])obj);
        } else if (!this.byReference(obj)) {
            int length = Array.getLength(obj);
            int buflen = 25;
            StringBuffer sb2 = new StringBuffer(buflen);
            sb2.append("<").append("array").append(" length=\"");
            sb2.append(length);
            sb2.append("\">");
            this.writeUTF(sb2);
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            if (aType.equals(Boolean.TYPE)) {
                boolean[] b10 = (boolean[])obj;
                for (int i10 = 0; i10 < b10.length; ++i10) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i10);
                    }
                    this.writeAMFBoolean(b10[i10]);
                }
            } else if (aType.equals(Integer.TYPE) || aType.equals(Short.TYPE)) {
                for (int i11 = 0; i11 < length; ++i11) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i11);
                    }
                    int v10 = Array.getInt(obj, i11);
                    this.writeAMFInt(v10);
                }
            } else {
                for (int i12 = 0; i12 < length; ++i12) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i12);
                    }
                    double v11 = Array.getDouble(obj, i12);
                    this.writeAMFDouble(v11);
                }
            }
            this.writeUTF("</array>");
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(Object o) throws IOException {
        ref = this.objectTable.get(o);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("ref").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!this.isDebug) ** GOTO lbl21
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Object reference is not an Integer");
            }
        } else {
            this.objectTable.put(o, new Integer(this.objectTable.size()));
        }
lbl21:
        // 3 sources

        return ref != null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(String s) throws IOException {
        ref = this.stringTable.get(s);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("string").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl21
                this.trace.writeStringRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("String reference is not an Integer");
            }
        } else {
            this.stringTable.put(s, new Integer(this.stringTable.size()));
        }
lbl21:
        // 3 sources

        return ref != null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(TraitsInfo ti) throws IOException {
        if (ti.length() == 0 && ti.getClassName() == null) {
            return false;
        }
        ref = this.traitsTable.get(ti);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                len = 20;
                sb = new StringBuffer(len);
                sb.append("<").append("traits").append(" id=\"");
                sb.append(refNum);
                sb.append("\"/>");
                this.writeUTF(sb);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl23
                this.trace.writeTraitsInfoRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("Traits reference is not an Integer");
            }
        } else {
            this.traitsTable.put(ti, new Integer(this.traitsTable.size()));
        }
lbl23:
        // 3 sources

        return ref != null;
    }
}

