/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.amf.translator.TranslationException;
import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MapDecoder
extends ActionScriptDecoder {
    public boolean hasShell() {
        return true;
    }

    protected boolean isSuitableMap(Object encodedObject, Class desiredClass) {
        return encodedObject != null && encodedObject instanceof Map && desiredClass.isAssignableFrom(encodedObject.getClass());
    }

    public Object createShell(Object encodedObject, Class desiredClass) {
        try {
            if (this.isSuitableMap(encodedObject, desiredClass)) {
                return encodedObject;
            }
            if (desiredClass.isInterface() || !Map.class.isAssignableFrom(desiredClass)) {
                if (SortedMap.class.isAssignableFrom(desiredClass)) {
                    return new TreeMap();
                }
                return new HashMap();
            }
            return desiredClass.newInstance();
        }
        catch (Exception e10) {
            TranslationException ex2 = new TranslationException("Could not create Map " + desiredClass, e10);
            ex2.setCode("Server.Processing");
            throw ex2;
        }
    }

    public Object decodeObject(Object shell, Object encodedObject, Class desiredClass) {
        if (shell == null || encodedObject == null) {
            return null;
        }
        if (this.isSuitableMap(encodedObject, desiredClass)) {
            return encodedObject;
        }
        return this.decodeMap((Map)shell, (Map)encodedObject);
    }

    protected Map decodeMap(Map shell, Map map) {
        if (shell != map) {
            shell.putAll(map);
        } else {
            shell = map;
        }
        return shell;
    }
}

