/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.ArrayCollection;
import flex.messaging.io.ArrayList;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.AmfTrace;
import java.util.Collection;
import java.util.Map;

abstract class AmfIO {
    protected final SerializationContext context;
    protected boolean isDebug;
    protected AmfTrace trace;
    private int nestObjectLevel;
    private int nestCollectionLevel;
    private char[] tempCharArray = null;
    private byte[] tempByteArray = null;

    AmfIO(SerializationContext context) {
        this.context = context;
    }

    public void setDebugTrace(AmfTrace trace) {
        this.trace = trace;
        this.isDebug = this.trace != null;
    }

    public void reset() {
        this.nestObjectLevel = 0;
        this.nestCollectionLevel = 0;
        TypeMarshallingContext marshallingContext = TypeMarshallingContext.getTypeMarshallingContext();
        marshallingContext.reset();
    }

    final char[] getTempCharArray(int capacity) {
        char[] result = this.tempCharArray;
        if (result == null || result.length < capacity) {
            this.tempCharArray = result = new char[capacity * 2];
        }
        return result;
    }

    final byte[] getTempByteArray(int capacity) {
        byte[] result = this.tempByteArray;
        if (result == null || result.length < capacity) {
            this.tempByteArray = result = new byte[capacity * 2];
        }
        return result;
    }

    protected void increaseNestObjectLevel() {
        ++this.nestObjectLevel;
        if (this.nestObjectLevel > this.context.maxObjectNestLevel) {
            SerializationException se2 = new SerializationException();
            se2.setMessage(10315, new Object[]{this.context.maxObjectNestLevel});
            throw se2;
        }
    }

    protected void decreaseNestObjectLevel() {
        --this.nestObjectLevel;
    }

    protected void increaseNestCollectionLevel() {
        ++this.nestCollectionLevel;
        if (this.nestCollectionLevel > this.context.maxCollectionNestLevel) {
            SerializationException se2 = new SerializationException();
            se2.setMessage(10316, new Object[]{this.context.maxCollectionNestLevel});
            throw se2;
        }
    }

    protected void decreaseNestCollectionLevel() {
        --this.nestCollectionLevel;
    }

    public static boolean isCollectionClass(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (ArrayCollection.class.equals(clazz)) {
            return true;
        }
        return ArrayList.class.equals(clazz);
    }
}

