/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.UnknownTypeException;
import flex.messaging.io.amf.AbstractAmfInput;
import flex.messaging.io.amf.ActionMessageInput;
import flex.messaging.io.amf.Amf3Input;
import flex.messaging.io.amf.AmfTypes;
import flex.messaging.util.ClassUtil;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Amf0Input
extends AbstractAmfInput
implements AmfTypes {
    protected ActionMessageInput avmPlusInput;
    protected List objectsTable = new ArrayList(64);

    public Amf0Input(SerializationContext context) {
        super(context);
    }

    public void reset() {
        super.reset();
        this.objectsTable.clear();
        if (this.avmPlusInput != null) {
            this.avmPlusInput.reset();
        }
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        byte type = this.in.readByte();
        Object value = this.readObjectValue(type);
        return value;
    }

    protected Object readObjectValue(int type) throws ClassNotFoundException, IOException {
        Object value = null;
        switch (type) {
            case 0: {
                value = this.readDouble();
                break;
            }
            case 1: {
                value = this.readBoolean();
                break;
            }
            case 2: {
                value = this.readString();
                break;
            }
            case 17: {
                if (this.avmPlusInput == null) {
                    this.avmPlusInput = new Amf3Input(this.context);
                    this.avmPlusInput.setDebugTrace(this.trace);
                    this.avmPlusInput.setInputStream(this.in);
                }
                value = this.avmPlusInput.readObject();
                break;
            }
            case 10: {
                value = this.readArrayValue();
                break;
            }
            case 16: {
                String typeName = this.in.readUTF();
                value = this.readObjectValue(typeName);
                break;
            }
            case 12: {
                ClassUtil.validateCreation(String.class);
                value = this.readLongUTF();
                if (!this.isDebug) break;
                this.trace.writeString((String)value);
                break;
            }
            case 3: {
                value = this.readObjectValue(null);
                break;
            }
            case 15: {
                value = this.readXml();
                break;
            }
            case 5: {
                if (!this.isDebug) break;
                this.trace.writeNull();
                break;
            }
            case 11: {
                value = this.readDate();
                break;
            }
            case 8: {
                value = this.readECMAArrayValue();
                break;
            }
            case 7: {
                int refNum = this.in.readUnsignedShort();
                if (this.isDebug) {
                    this.trace.writeRef(refNum);
                }
                value = this.objectsTable.get(refNum);
                break;
            }
            case 6: {
                if (!this.isDebug) break;
                this.trace.writeUndefined();
                break;
            }
            case 13: {
                if (this.isDebug) {
                    this.trace.write("UNSUPPORTED");
                }
                UnknownTypeException ex2 = new UnknownTypeException();
                ex2.setMessage(10302);
                throw ex2;
            }
            case 9: {
                if (this.isDebug) {
                    this.trace.write("UNEXPECTED OBJECT END");
                }
                UnknownTypeException ex1 = new UnknownTypeException();
                ex1.setMessage(10303);
                throw ex1;
            }
            case 14: {
                if (this.isDebug) {
                    this.trace.write("UNEXPECTED RECORDSET");
                }
                UnknownTypeException ex2 = new UnknownTypeException();
                ex2.setMessage(10304);
                throw ex2;
            }
            default: {
                if (this.isDebug) {
                    this.trace.write("UNKNOWN TYPE");
                }
                UnknownTypeException ex3 = new UnknownTypeException();
                ex3.setMessage(10301, new Object[]{new Integer(type)});
                throw ex3;
            }
        }
        return value;
    }

    protected Date readDate() throws IOException {
        ClassUtil.validateCreation(Date.class);
        long time = (long)this.in.readDouble();
        this.in.readShort();
        Date d10 = new Date(time);
        if (this.isDebug) {
            this.trace.write(d10.toString());
        }
        return d10;
    }

    public boolean readBoolean() throws IOException {
        ClassUtil.validateCreation(Boolean.class);
        boolean b10 = super.readBoolean();
        if (this.isDebug) {
            this.trace.write(b10);
        }
        return b10;
    }

    public double readDouble() throws IOException {
        ClassUtil.validateCreation(Double.class);
        double d10 = super.readDouble();
        if (this.isDebug) {
            this.trace.write(d10);
        }
        return d10;
    }

    protected Map readECMAArrayValue() throws ClassNotFoundException, IOException {
        ClassUtil.validateCreation(HashMap.class);
        int size = this.in.readInt();
        HashMap<String, Object> h10 = size == 0 ? new HashMap<String, Object>() : new HashMap(size);
        this.rememberObject(h10);
        if (this.isDebug) {
            this.trace.startECMAArray(this.objectsTable.size() - 1);
        }
        String name = this.in.readUTF();
        byte type = this.in.readByte();
        while (type != 9) {
            if (type != 9) {
                if (this.isDebug) {
                    this.trace.namedElement(name);
                }
                Object value = this.readObjectValueOneLevelDown(type, true);
                if (!name.equals("length")) {
                    ClassUtil.validateAssignment(h10, name, value);
                    h10.put(name, value);
                }
            }
            name = this.in.readUTF();
            type = this.in.readByte();
        }
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
        return h10;
    }

    protected String readString() throws IOException {
        ClassUtil.validateCreation(String.class);
        String s10 = this.readUTF();
        if (this.isDebug) {
            this.trace.writeString(s10);
        }
        return s10;
    }

    protected Object readArrayValue() throws ClassNotFoundException, IOException {
        Object l10;
        int size = this.in.readInt();
        boolean useListTemporarily = false;
        if (this.context.legacyCollection || size > 1024) {
            useListTemporarily = !this.context.legacyCollection;
            ClassUtil.validateCreation(ArrayList.class);
            int initialCapacity = size < 1024 ? size : 1024;
            l10 = new ArrayList(initialCapacity);
        } else {
            ClassUtil.validateCreation(Object[].class);
            l10 = new Object[size];
        }
        int objectId = this.rememberObject(l10);
        if (this.isDebug) {
            this.trace.startAMFArray(this.objectsTable.size() - 1);
        }
        for (int i10 = 0; i10 < size; ++i10) {
            if (this.isDebug) {
                this.trace.arrayElement(i10);
            }
            byte type = this.in.readByte();
            Object value = this.readObjectValueOneLevelDown(type, true);
            ClassUtil.validateAssignment(l10, i10, value);
            if (l10 instanceof ArrayList) {
                ((ArrayList)l10).add(value);
                continue;
            }
            Array.set(l10, i10, value);
        }
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
        if (useListTemporarily) {
            l10 = ((ArrayList)l10).toArray();
            this.objectsTable.set(objectId, l10);
        }
        return l10;
    }

    protected Object readObjectValue(String className) throws ClassNotFoundException, IOException {
        Object newObj;
        Object[] params = new Object[]{className, null};
        Object object = this.createObjectInstance(params);
        className = (String)params[0];
        PropertyProxy proxy = (PropertyProxy)params[1];
        int objectId = this.rememberObject(object);
        if (this.isDebug) {
            this.trace.startAMFObject(className, this.objectsTable.size() - 1);
        }
        boolean isCollectionClass = Amf0Input.isCollectionClass(object);
        String propertyName = this.in.readUTF();
        byte type = this.in.readByte();
        while (type != 9) {
            if (this.isDebug) {
                this.trace.namedElement(propertyName);
            }
            Object value = this.readObjectValueOneLevelDown(type, isCollectionClass);
            proxy.setValue(object, propertyName, value);
            propertyName = this.in.readUTF();
            type = this.in.readByte();
        }
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
        if ((newObj = proxy.instanceComplete(object)) != object) {
            this.objectsTable.set(objectId, newObj);
            object = newObj;
        }
        return object;
    }

    protected String readLongUTF() throws IOException {
        int utflen = this.in.readInt();
        this.checkUTFLength(utflen);
        char[] charr = this.getTempCharArray(utflen);
        byte[] bytearr = this.getTempByteArray(utflen);
        int count = 0;
        int chCount = 0;
        this.in.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            int c10 = bytearr[count] & 0xFF;
            switch (c10 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    charr[chCount] = (char)c10;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charr[chCount] = (char)((c10 & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charr[chCount] = (char)((c10 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
            ++chCount;
        }
        return new String(charr, 0, chCount);
    }

    protected Object readXml() throws IOException {
        String xml = this.readLongUTF();
        if (this.isDebug) {
            this.trace.write(xml);
        }
        return this.stringToDocument(xml);
    }

    protected int rememberObject(Object obj) {
        int id2 = this.objectsTable.size();
        this.objectsTable.add(obj);
        return id2;
    }

    protected Object readObjectValueOneLevelDown(int type, boolean nestCollectionLevelDown) throws ClassNotFoundException, IOException {
        this.increaseNestObjectLevel();
        if (nestCollectionLevelDown) {
            this.increaseNestCollectionLevel();
        }
        Object value = this.readObjectValue(type);
        this.decreaseNestObjectLevel();
        if (nestCollectionLevelDown) {
            this.decreaseNestCollectionLevel();
        }
        return value;
    }
}

