/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;

public class ThrottleSettings {
    public static final String ELEMENT_INBOUND = "throttle-inbound";
    public static final String ELEMENT_OUTBOUND = "throttle-outbound";
    public static final String ELEMENT_POLICY = "policy";
    public static final String ELEMENT_DEST_FREQ = "max-frequency";
    public static final String ELEMENT_CLIENT_FREQ = "max-client-frequency";
    private static final int ERR_MSG_INVALID_INBOUND_POLICY = 11130;
    private static final int ERR_MSG_INVALID_INCOMING_CLENT_FREQ = 11131;
    private static final int ERR_MSG_INVALID_INCOMING_DEST_FREQ = 11132;
    private static final int ERR_MSG_INVALID_OUTGOING_CLIENT_FREQ = 11133;
    private static final int ERR_MSG_INVALID_OUTGOING_DEST_FREQ = 11134;
    private static final int ERR_MSG_INVALID_NEGATIVE_VALUE = 11135;
    private String destinationName;
    private int inClientMessagesPerSec;
    private int inDestinationMessagesPerSec;
    private int outClientMessagesPerSec;
    private int outDestinationMessagesPerSec;
    private Policy inPolicy = Policy.NONE;
    private Policy outPolicy = Policy.NONE;

    public static Policy parsePolicy(String policy) {
        if (Policy.NONE.toString().equalsIgnoreCase(policy)) {
            return Policy.NONE;
        }
        if (Policy.IGNORE.toString().equalsIgnoreCase(policy)) {
            return Policy.IGNORE;
        }
        if (Policy.ERROR.toString().equalsIgnoreCase(policy)) {
            return Policy.ERROR;
        }
        if (Policy.BUFFER.toString().equalsIgnoreCase(policy)) {
            return Policy.BUFFER;
        }
        if (Policy.CONFLATE.toString().equalsIgnoreCase(policy)) {
            return Policy.CONFLATE;
        }
        ConfigurationException ex2 = new ConfigurationException();
        throw ex2;
    }

    public boolean isClientThrottleEnabled() {
        return this.isInboundClientThrottleEnabled() || this.isOutboundClientThrottleEnabled();
    }

    public boolean isInboundClientThrottleEnabled() {
        return this.inPolicy != Policy.NONE && this.getIncomingClientFrequency() > 0;
    }

    public boolean isOutboundClientThrottleEnabled() {
        return this.outPolicy != Policy.NONE && this.getOutgoingClientFrequency() > 0;
    }

    public boolean isDestinationThrottleEnabled() {
        return this.isInboundDestinationThrottleEnabled() || this.isOutboundDestinationThrottleEnabled();
    }

    public boolean isInboundDestinationThrottleEnabled() {
        return this.inPolicy != Policy.NONE && this.getIncomingDestinationFrequency() > 0;
    }

    public boolean isOutboundDestinationThrottleEnabled() {
        return this.outPolicy != Policy.NONE && this.getOutgoingDestinationFrequency() > 0;
    }

    public Policy getInboundPolicy() {
        return this.inPolicy;
    }

    public void setInboundPolicy(Policy inPolicy) {
        if (inPolicy != Policy.NONE && inPolicy != Policy.ERROR && inPolicy != Policy.IGNORE) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(11130, new Object[]{inPolicy, this.destinationName});
            throw ex2;
        }
        this.inPolicy = inPolicy;
    }

    public Policy getOutboundPolicy() {
        return this.outPolicy;
    }

    public void setOutboundPolicy(Policy outPolicy) {
        this.outPolicy = outPolicy;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public int getIncomingClientFrequency() {
        return this.inClientMessagesPerSec;
    }

    public void setIncomingClientFrequency(int n10) {
        String name = "incoming client frequency";
        this.blockNegative(n10, name);
        if (this.inDestinationMessagesPerSec > 0 && n10 > this.inDestinationMessagesPerSec) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(11131, new Object[]{name, this.destinationName, n10, this.inDestinationMessagesPerSec});
            throw ex2;
        }
        this.inClientMessagesPerSec = n10;
    }

    public int getIncomingDestinationFrequency() {
        return this.inDestinationMessagesPerSec;
    }

    public void setIncomingDestinationFrequency(int n10) {
        String name = "The incoming destination frequency";
        this.blockNegative(n10, name);
        if (this.inClientMessagesPerSec > 0 && n10 < this.inClientMessagesPerSec) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(11132, new Object[]{name, this.destinationName, n10, this.inClientMessagesPerSec});
            throw ex2;
        }
        this.inDestinationMessagesPerSec = n10;
    }

    public int getOutgoingClientFrequency() {
        return this.outClientMessagesPerSec;
    }

    public void setOutgoingClientFrequency(int n10) {
        String name = "The outgoing client frequency";
        this.blockNegative(n10, name);
        if (this.outDestinationMessagesPerSec > 0 && n10 > this.outDestinationMessagesPerSec) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(11133, new Object[]{name, this.destinationName, n10, this.outDestinationMessagesPerSec});
            throw ex2;
        }
        this.outClientMessagesPerSec = n10;
    }

    public int getOutgoingDestinationFrequency() {
        return this.outDestinationMessagesPerSec;
    }

    public void setOutgoingDestinationFrequency(int n10) {
        String name = "The outgoing destination frequency";
        this.blockNegative(n10, name);
        if (this.outClientMessagesPerSec > 0 && n10 < this.outClientMessagesPerSec) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(11134, new Object[]{name, this.destinationName, n10, this.outClientMessagesPerSec});
            throw ex2;
        }
        this.outDestinationMessagesPerSec = n10;
    }

    protected void blockNegative(int n10, String name) {
        if (n10 < 0) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage(11135, new Object[]{name, this.destinationName});
            throw ex2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Policy {
        NONE,
        ERROR,
        IGNORE,
        BUFFER,
        CONFLATE;

    }
}

