/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.cluster.Cluster;
import flex.messaging.cluster.ClusterException;
import flex.messaging.config.ClusterSettings;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.util.ClassUtil;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClusterManager {
    private MessageBroker broker;
    private LinkedHashMap<String, Cluster> clusters;
    private Map<String, Cluster> clustersForDestination;
    private Map<String, Element> clusterConfig;
    private Map<String, ClusterSettings> clusterSettings;
    private Map<String, Boolean> backendSharedForDestination;
    private Cluster defaultCluster;
    private String defaultClusterId;

    public ClusterManager(MessageBroker broker) {
        this.broker = broker;
        this.clusters = new LinkedHashMap();
        this.clusterConfig = new HashMap<String, Element>();
        this.clusterSettings = new HashMap<String, ClusterSettings>();
        this.clustersForDestination = new HashMap<String, Cluster>();
        this.backendSharedForDestination = new HashMap<String, Boolean>();
    }

    public MessageBroker getMessageBroker() {
        return this.broker;
    }

    public Cluster getDefaultCluster() {
        return this.defaultCluster;
    }

    public String getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public void invokeEndpointOperation(String endpointId, String operationName, Object[] params) {
        Object[] arguments = new Object[2 + params.length];
        arguments[0] = endpointId;
        arguments[1] = operationName;
        int n10 = params.length;
        int i10 = 2;
        for (int j10 = 0; j10 < n10; ++j10) {
            arguments[i10] = params[j10];
            ++i10;
        }
        if (this.defaultCluster != null) {
            this.defaultCluster.broadcastServiceOperation(operationName, arguments);
        } else {
            for (Cluster cluster : this.clusters.values()) {
                cluster.broadcastServiceOperation(operationName, arguments);
            }
        }
    }

    public void invokePeerToPeerEndpointOperation(String endpointId, String operationName, Object[] params, Object targetAddress) {
        Object[] arguments = new Object[2 + params.length];
        arguments[0] = endpointId;
        arguments[1] = operationName;
        int n10 = params.length;
        int i10 = 2;
        for (int j10 = 0; j10 < n10; ++j10) {
            arguments[i10] = params[j10];
            ++i10;
        }
        if (this.defaultCluster != null) {
            this.defaultCluster.sendPointToPointServiceOperation(operationName, arguments, targetAddress);
        } else {
            for (Cluster cluster : this.clusters.values()) {
                cluster.sendPointToPointServiceOperation(operationName, arguments, targetAddress);
            }
        }
    }

    public void invokeServiceOperation(String serviceType, String destinationName, String operationName, Object[] params) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        ArrayList<Object> newParams = new ArrayList<Object>(Arrays.asList(params));
        newParams.add(0, serviceType);
        newParams.add(1, destinationName);
        c10.broadcastServiceOperation(operationName, newParams.toArray());
    }

    public void invokePeerToPeerOperation(String serviceType, String destinationName, String operationName, Object[] params, Object targetAddress) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        ArrayList<Object> newParams = new ArrayList<Object>(Arrays.asList(params));
        newParams.add(0, serviceType);
        newParams.add(1, destinationName);
        c10.sendPointToPointServiceOperation(operationName, newParams.toArray(), targetAddress);
    }

    public boolean isDestinationClustered(String serviceType, String destinationName) {
        return this.getCluster(serviceType, destinationName) != null;
    }

    public boolean isBackendShared(String serviceType, String destinationName) {
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        Boolean shared = this.backendSharedForDestination.get(destKey);
        return shared != null ? shared : false;
    }

    public List getClusterMemberAddresses(String serviceType, String destinationName) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        return c10 != null ? c10.getMemberAddresses() : Collections.EMPTY_LIST;
    }

    public List getClusterMemberAddresses() {
        if (this.defaultCluster != null) {
            return this.defaultCluster.getMemberAddresses();
        }
        TreeSet uniqueAddresses = new TreeSet();
        for (Cluster cluster : this.clusters.values()) {
            uniqueAddresses.addAll(cluster.getMemberAddresses());
        }
        return new ArrayList(uniqueAddresses);
    }

    public void prepareCluster(ClusterSettings settings) {
        InputStream propsFile;
        if (settings.getPropsFileName() == null) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10201, new Object[]{settings.getClusterName(), settings.getPropsFileName()});
            throw cx2;
        }
        try {
            propsFile = this.broker.resolveInternalPath(settings.getPropsFileName());
        }
        catch (Throwable t10) {
            ClusterException cx3 = new ClusterException();
            cx3.setMessage(10208, new Object[]{settings.getPropsFileName()});
            cx3.setRootCause(t10);
            throw cx3;
        }
        if (propsFile == null) {
            ClusterException cx4 = new ClusterException();
            cx4.setMessage(10208, new Object[]{settings.getPropsFileName()});
            throw cx4;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc2 = builder.parse(propsFile);
            if (settings.isDefault()) {
                this.defaultClusterId = settings.getClusterName();
            }
            this.clusterConfig.put(settings.getClusterName(), doc2.getDocumentElement());
            this.clusterSettings.put(settings.getClusterName(), settings);
        }
        catch (Exception ex2) {
            ClusterException cx5 = new ClusterException();
            cx5.setMessage(10213);
            cx5.setRootCause(ex2);
            throw cx5;
        }
    }

    public Object getLocalAddress(String serviceType, String destinationName) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        return c10 != null ? c10.getLocalAddress() : null;
    }

    public Object getLocalAddress() {
        if (this.defaultCluster != null) {
            return this.defaultCluster.getLocalAddress();
        }
        Iterator<Map.Entry<String, Cluster>> i$ = this.clusters.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<String, Cluster> entry = i$.next();
            return entry.getValue().getLocalAddress();
        }
        return null;
    }

    public Cluster getClusterById(String clusterId) {
        return this.clusters.get(clusterId);
    }

    public Cluster getCluster(String serviceType, String destinationName) {
        Cluster cluster = null;
        try {
            String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
            cluster = this.clustersForDestination.get(destKey);
            if (cluster == null) {
                cluster = this.defaultCluster;
            }
        }
        catch (NoClassDefFoundError nex) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10202, new Object[]{destinationName});
            cx2.setRootCause(nex);
            throw cx2;
        }
        return cluster;
    }

    public void destroyClusters() {
        Iterator<Cluster> iter = this.clusters.values().iterator();
        while (iter.hasNext()) {
            Cluster cluster = iter.next();
            cluster.destroy();
            iter.remove();
        }
    }

    public void clusterDestinationChannel(String clusterId, String serviceType, String destinationName, String channelId, String endpointUrl, int endpointPort, boolean sharedBackend) {
        Cluster cluster = this.getClusterById(clusterId);
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        if (cluster == null) {
            if (!this.clusterConfig.containsKey(clusterId)) {
                ClusterException cx2 = new ClusterException();
                cx2.setMessage(10207, new Object[]{destinationName, clusterId});
                throw cx2;
            }
            cluster = this.createCluster(clusterId, serviceType, destinationName);
        } else {
            this.clustersForDestination.put(destKey, cluster);
        }
        this.backendSharedForDestination.put(destKey, sharedBackend ? Boolean.TRUE : Boolean.FALSE);
        if (cluster.getURLLoadBalancing()) {
            cluster.addLocalEndpointForChannel(serviceType, destinationName, channelId, endpointUrl, endpointPort);
        }
    }

    public void clusterDestination(Destination destination) {
        ClusterSettings cls;
        String clusterId = destination.getNetworkSettings().getClusterId();
        if (clusterId == null) {
            clusterId = this.getDefaultClusterId();
        }
        if ((cls = this.clusterSettings.get(clusterId)) == null) {
            ClusterException ce2 = new ClusterException();
            ce2.setMessage(10217, new Object[]{destination.getId(), clusterId});
            throw ce2;
        }
        for (String channelId : destination.getChannels()) {
            int tokenStart;
            Endpoint endpoint = this.broker.getEndpoint(channelId);
            String endpointUrl = endpoint.getUrl();
            int endpointPort = endpoint.getPort();
            if (cls.getURLLoadBalancing() && (tokenStart = endpointUrl.indexOf(123)) != -1) {
                int tokenEnd = endpointUrl.indexOf(125, tokenStart);
                tokenEnd = tokenEnd == -1 ? endpointUrl.length() : ++tokenEnd;
                ClusterException ce3 = new ClusterException();
                ce3.setMessage(10209, new Object[]{destination.getId(), channelId, endpointUrl.substring(tokenStart, tokenEnd)});
                throw ce3;
            }
            this.clusterDestinationChannel(clusterId, destination.getServiceType(), destination.getId(), channelId, endpointUrl, endpointPort, destination.getNetworkSettings().isSharedBackend());
        }
    }

    public List getEndpointsForDestination(String serviceType, String destinationName) {
        Cluster c10 = this.getCluster(serviceType, destinationName);
        return c10 != null ? c10.getAllEndpoints(serviceType, destinationName) : null;
    }

    private Cluster createCluster(String clusterId, String serviceType, String destinationName) {
        String destKey = Cluster.getClusterDestinationKey(serviceType, destinationName);
        Element propsFile = this.clusterConfig.get(clusterId);
        ClusterSettings cls = this.clusterSettings.get(clusterId);
        Cluster cluster = null;
        Class clusterClass = ClassUtil.createClass(cls.getImplementationClass());
        Constructor clusterConstructor = null;
        try {
            clusterConstructor = clusterClass.getConstructor(ClusterManager.class);
        }
        catch (Exception e10) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10210);
            cx2.setRootCause(e10);
            throw cx2;
        }
        try {
            cluster = (Cluster)clusterConstructor.newInstance(this);
            cluster.setClusterPropertiesFile(propsFile);
            cluster.setURLLoadBalancing(cls.getURLLoadBalancing());
            cluster.initialize(clusterId, cls.getProperties());
        }
        catch (Exception e11) {
            ClusterException cx3 = new ClusterException();
            cx3.setMessage(10211);
            cx3.setRootCause(e11);
            throw cx3;
        }
        this.clustersForDestination.put(destKey, cluster);
        this.clusters.put(clusterId, cluster);
        if (this.defaultClusterId != null && this.defaultClusterId.equals(clusterId)) {
            this.defaultCluster = cluster;
        }
        return cluster;
    }
}

