/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.AbstractFlexSessionProvider;
import flex.messaging.FlexContext;
import flex.messaging.HttpFlexSession;
import flex.messaging.log.Log;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpFlexSessionProvider
extends AbstractFlexSessionProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpFlexSession getOrCreateSession(HttpServletRequest request) {
        HttpFlexSession flexSession;
        HttpSession httpSession = request.getSession(true);
        if (!HttpFlexSession.isHttpSessionListener && !HttpFlexSession.warnedNoEventRedispatch) {
            HttpFlexSession.warnedNoEventRedispatch = true;
            if (Log.isWarn()) {
                Log.getLogger(HttpFlexSession.WARN_LOG_CATEGORY).warn("HttpFlexSession has not been registered as a listener in web.xml for this application so no events will be dispatched to FlexSessionAttributeListeners or FlexSessionBindingListeners. To correct this, register flex.messaging.HttpFlexSession as a listener in web.xml.");
            }
        }
        boolean isNew = false;
        HttpSession httpSession2 = httpSession;
        synchronized (httpSession2) {
            flexSession = (HttpFlexSession)httpSession.getAttribute("__flexSession");
            if (flexSession == null) {
                flexSession = new HttpFlexSession(this);
                FlexContext.setThreadLocalSession(flexSession);
                httpSession.setAttribute("__flexSession", (Object)flexSession);
                flexSession.setHttpSession(httpSession);
                isNew = true;
            } else {
                FlexContext.setThreadLocalSession(flexSession);
                if (flexSession.httpSession == null) {
                    flexSession.setHttpSession(httpSession);
                    isNew = true;
                }
            }
        }
        if (isNew) {
            this.getFlexSessionManager().registerFlexSession(flexSession);
            flexSession.notifyCreated();
            if (Log.isDebug()) {
                Log.getLogger("Endpoint.FlexSession").debug("FlexSession created with id '" + flexSession.getId() + "' for an Http-based client connection.");
            }
        }
        return flexSession;
    }
}

